/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueueClient
implements RequestQueue {
    public static final String QUEUE_TIMESTAMP = "queueTimestamp";
    public static final Logger log = LoggerFactory.getLogger(QueueClient.class);
    private MonitoringHandler monitoringHandler;
    private Vertx vertx;

    public QueueClient(Vertx vertx, @Nullable MonitoringHandler monitoringHandler) {
        this.vertx = vertx;
        this.monitoringHandler = monitoringHandler;
    }

    protected String getRedisquesAddress() {
        return Address.redisquesAddress();
    }

    @Override
    public void enqueue(HttpServerRequest request, Buffer buffer, String queue) {
        this.enqueue(request, request.headers(), buffer, queue);
    }

    @Override
    public void enqueue(HttpServerRequest request, MultiMap headers, Buffer buffer, String queue) {
        HttpRequest queuedRequest = new HttpRequest(request.method(), request.uri(), headers, buffer.getBytes());
        this.enqueue(request, queuedRequest, queue);
    }

    @Override
    public void enqueue(HttpRequest request, String queue) {
        this.enqueue(null, request, queue);
    }

    @Override
    public void enqueue(HttpRequest request, String queue, Handler<Void> doneHandler) {
        this.enqueue(null, request, queue, doneHandler);
    }

    @Override
    public void lockedEnqueue(HttpRequest queuedRequest, String queue, String lockRequestedBy, Handler<Void> doneHandler) {
        this.vertx.eventBus().request(this.getRedisquesAddress(), (Object)RedisquesAPI.buildLockedEnqueueOperation((String)queue, (String)queuedRequest.toJsonObject().put(QUEUE_TIMESTAMP, (Object)System.currentTimeMillis()).encode(), (String)lockRequestedBy), event -> {
            if ("ok".equals(((JsonObject)((Message)event.result()).body()).getString("status")) && this.monitoringHandler != null) {
                this.monitoringHandler.updateLastUsedQueueSizeInformation(queue);
                this.monitoringHandler.updateEnqueue();
            }
            if (doneHandler != null) {
                doneHandler.handle(null);
            }
        });
    }

    @Override
    public Future<Void> deleteLock(String queue) {
        Promise promise = Promise.promise();
        this.vertx.eventBus().request(this.getRedisquesAddress(), (Object)RedisquesAPI.buildDeleteLockOperation((String)queue), event -> {
            if (event.failed()) {
                promise.fail(event.cause());
                return;
            }
            if ("ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                promise.complete();
                return;
            }
            promise.fail("Failed to delete lock for queue " + queue);
        });
        return promise.future();
    }

    @Override
    public Future<Void> deleteAllQueueItems(String queue, boolean unlock) {
        Promise promise = Promise.promise();
        this.vertx.eventBus().request(this.getRedisquesAddress(), (Object)RedisquesAPI.buildDeleteAllQueueItemsOperation((String)queue, (boolean)unlock), event -> {
            if (event.succeeded()) {
                promise.complete();
            } else {
                promise.fail("Failed to delete all queue items for queue " + queue + " with unlock " + unlock + ". Cause: " + event.cause());
            }
        });
        return promise.future();
    }

    @Override
    public Future<Void> enqueueFuture(HttpRequest queuedRequest, String queue) {
        Promise promise = Promise.promise();
        this.vertx.eventBus().request(this.getRedisquesAddress(), (Object)RedisquesAPI.buildEnqueueOperation((String)queue, (String)queuedRequest.toJsonObject().put(QUEUE_TIMESTAMP, (Object)System.currentTimeMillis()).encode()), event -> {
            if ("ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                if (this.monitoringHandler != null) {
                    this.monitoringHandler.updateLastUsedQueueSizeInformation(queue);
                    this.monitoringHandler.updateEnqueue();
                }
                promise.complete();
            } else {
                promise.fail(((JsonObject)((Message)event.result()).body()).getString("message"));
            }
        });
        return promise.future();
    }

    private void enqueue(HttpServerRequest request, HttpRequest queuedRequest, String queue) {
        this.enqueue(request, queuedRequest, queue, null);
    }

    private void enqueue(HttpServerRequest request, HttpRequest queuedRequest, String queue, Handler<Void> doneHandler) {
        if (!QueueProcessor.httpMethodIsQueueable(queuedRequest.getMethod())) {
            log.warn("Ignore enqueue of unsupported HTTP method in '{} {}'.", (Object)queuedRequest.getMethod(), (Object)queuedRequest.getUri());
            if (doneHandler != null) {
                doneHandler.handle(null);
            }
            return;
        }
        this.vertx.eventBus().request(this.getRedisquesAddress(), (Object)RedisquesAPI.buildEnqueueOperation((String)queue, (String)queuedRequest.toJsonObject().put(QUEUE_TIMESTAMP, (Object)System.currentTimeMillis()).encode()), event -> {
            if ("ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                if (this.monitoringHandler != null) {
                    this.monitoringHandler.updateLastUsedQueueSizeInformation(queue);
                    this.monitoringHandler.updateEnqueue();
                }
                if (request != null) {
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.ACCEPTED, QueueClient.class);
                    request.response().setStatusCode(StatusCode.ACCEPTED.getStatusCode());
                    request.response().setStatusMessage(StatusCode.ACCEPTED.getStatusMessage());
                    request.response().end();
                }
            } else if (request != null) {
                ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.INTERNAL_SERVER_ERROR, QueueClient.class);
                request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
                request.response().end(((JsonObject)((Message)event.result()).body()).getString("message"));
            }
            if (doneHandler != null) {
                doneHandler.handle(null);
            }
        });
    }
}

