/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import javax.annotation.Nullable;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.duplicate.DuplicateCheckHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.gateleen.queue.queuing.splitter.NoOpQueueSplitter;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitter;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueuingHandler
implements Handler<Buffer> {
    public static final String QUEUE_HEADER = "x-queue";
    public static final String ORIGINALLY_QUEUED_HEADER = "x-originally-queued";
    public static final String DUPLICATE_CHECK_HEADER = "x-duplicate-check";
    private final RequestQueue requestQueue;
    private final HttpServerRequest request;
    private final Vertx vertx;
    private final RedisProvider redisProvider;
    private final QueueSplitter queueSplitter;

    public static boolean isQueued(HttpServerRequest request) {
        String queue = request.headers().get(QUEUE_HEADER);
        return HttpMethod.GET != request.method() && queue != null && !queue.trim().isEmpty();
    }

    public QueuingHandler(Vertx vertx, RedisProvider redisProvider, HttpServerRequest request, @Nullable MonitoringHandler monitoringHandler) {
        this(vertx, redisProvider, request, new QueueClient(vertx, monitoringHandler), (QueueSplitter)new NoOpQueueSplitter());
    }

    public QueuingHandler(Vertx vertx, RedisProvider redisProvider, HttpServerRequest request, @Nullable MonitoringHandler monitoringHandler, QueueSplitter queueSplitter) {
        this(vertx, redisProvider, request, new QueueClient(vertx, monitoringHandler), queueSplitter == null ? new NoOpQueueSplitter() : queueSplitter);
    }

    public QueuingHandler(Vertx vertx, RedisProvider redisProvider, HttpServerRequest request, RequestQueue requestQueue, QueueSplitter queueSplitter) {
        this.request = request;
        this.vertx = vertx;
        this.redisProvider = redisProvider;
        this.requestQueue = requestQueue;
        this.queueSplitter = queueSplitter;
    }

    public void handle(Buffer buffer) {
        String queue = this.request.headers().get(QUEUE_HEADER);
        MultiMap headers = this.request.headers();
        headers.remove(QUEUE_HEADER);
        headers.add(ORIGINALLY_QUEUED_HEADER, "true");
        if (headers.names().contains(DUPLICATE_CHECK_HEADER)) {
            DuplicateCheckHandler.checkDuplicateRequest(this.redisProvider, this.request.uri(), buffer, headers.get(DUPLICATE_CHECK_HEADER), (Handler<Boolean>)((Handler)requestIsDuplicate -> {
                if (requestIsDuplicate.booleanValue()) {
                    this.request.response().setStatusCode(StatusCode.ACCEPTED.getStatusCode());
                    this.request.response().setStatusMessage(StatusCode.ACCEPTED.getStatusMessage());
                    this.request.response().end();
                } else {
                    this.requestQueue.enqueue(this.request, headers, buffer, this.queueSplitter.convertToSubQueue(queue, this.request));
                }
            }));
        } else {
            this.requestQueue.enqueue(this.request, headers, buffer, this.queueSplitter.convertToSubQueue(queue, this.request));
        }
    }

    @Deprecated
    public static void cleanup(Vertx vertx) {
        vertx.eventBus().request(Address.redisquesAddress(), (Object)RedisquesAPI.buildCheckOperation());
    }
}

