/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.api;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.api.QueueCircuitBreakerAPI;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;

public class QueueCircuitBreakerHttpRequestHandler
implements Handler<HttpServerRequest> {
    private Logger log = LoggerFactory.getLogger(QueueCircuitBreakerHttpRequestHandler.class);
    private Router router;
    private final String allPrefix = "_all";
    private final String statusSuffix = "/status";
    private final String circuitIdParam = "/:circuitId";
    private EventBus eventBus;
    private QueueCircuitBreakerStorage storage;
    public static final String HTTP_REQUEST_API_ADDRESS = "gateleen.queue-circuit-breaker.http-request-api";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "content-type";

    public QueueCircuitBreakerHttpRequestHandler(Vertx vertx, QueueCircuitBreakerStorage storage, String prefix) {
        this.router = Router.router((Vertx)vertx);
        this.eventBus = vertx.eventBus();
        this.storage = storage;
        this.registerAPIConsumer();
        this.router.get(prefix).handler(ctx -> {
            this.log(ctx.request(), "list all circuits");
            this.handleGetAllCircuitsRequest((RoutingContext)ctx);
        });
        this.router.get(prefix + "/_all").handler(ctx -> {
            this.log(ctx.request(), "list all circuits");
            this.handleGetAllCircuitsRequest((RoutingContext)ctx);
        });
        this.router.putWithRegex(prefix + "/_all/status").handler(ctx -> ctx.request().bodyHandler(event -> {
            QueueCircuitState state = this.extractStatusFromBody((Buffer)event);
            this.log(ctx.request(), "change all circuit states to " + state);
            if (state == null) {
                this.respondWith(StatusCode.BAD_REQUEST, "Body must contain a correct 'status' value", ctx.request());
            } else if (QueueCircuitState.CLOSED != state) {
                this.respondWith(StatusCode.FORBIDDEN, "Status can be changed to 'CLOSED' only", ctx.request());
            } else {
                this.eventBus.request(HTTP_REQUEST_API_ADDRESS, (Object)QueueCircuitBreakerAPI.buildCloseAllCircuitsOperation(), reply -> {
                    if (reply.succeeded()) {
                        JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                        if ("ok".equals(replyBody.getString("status"))) {
                            ctx.response().end();
                        } else {
                            ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                            ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                        }
                    } else {
                        ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                        ctx.response().end(reply.cause().getMessage());
                    }
                });
            }
        }));
        this.router.getWithRegex(prefix + "/_all/status").handler(ctx -> this.respondWith(StatusCode.METHOD_NOT_ALLOWED, ctx.request()));
        this.router.get(prefix + "/:circuitId/status").handler(ctx -> {
            String circuitId = this.extractCircuitId((RoutingContext)ctx);
            this.log(ctx.request(), "get status of circuit " + circuitId);
            this.eventBus.request(HTTP_REQUEST_API_ADDRESS, (Object)QueueCircuitBreakerAPI.buildGetCircuitStatusOperation(circuitId), reply -> {
                if (reply.succeeded()) {
                    JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                    if ("ok".equals(replyBody.getString("status"))) {
                        this.jsonResponse(ctx.response(), replyBody.getJsonObject("value"));
                    } else {
                        ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                        ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                    }
                } else {
                    ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                    ctx.response().end(reply.cause().getMessage());
                }
            });
        });
        this.router.put(prefix + "/:circuitId/status").handler(ctx -> {
            String circuitId = this.extractCircuitId((RoutingContext)ctx);
            ctx.request().bodyHandler(event -> {
                QueueCircuitState state = this.extractStatusFromBody((Buffer)event);
                this.log(ctx.request(), "change status of circuit " + circuitId + " to " + state);
                if (state == null) {
                    this.respondWith(StatusCode.BAD_REQUEST, "Body must contain a correct 'status' value", ctx.request());
                } else if (QueueCircuitState.CLOSED != state) {
                    this.respondWith(StatusCode.FORBIDDEN, "Status can be changed to 'CLOSED' only", ctx.request());
                } else {
                    this.eventBus.request(HTTP_REQUEST_API_ADDRESS, (Object)QueueCircuitBreakerAPI.buildCloseCircuitOperation(circuitId), reply -> {
                        if (reply.succeeded()) {
                            JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                            if ("ok".equals(replyBody.getString("status"))) {
                                ctx.response().end();
                            } else {
                                ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                                ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                            }
                        } else {
                            ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                            ctx.response().end(reply.cause().getMessage());
                        }
                    });
                }
            });
        });
        this.router.get(prefix + "/:circuitId").handler(ctx -> {
            String circuitId = this.extractCircuitId((RoutingContext)ctx);
            this.log(ctx.request(), "get information of circuit " + circuitId);
            this.eventBus.request(HTTP_REQUEST_API_ADDRESS, (Object)QueueCircuitBreakerAPI.buildGetCircuitInformationOperation(circuitId), reply -> {
                if (reply.succeeded()) {
                    JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                    if ("ok".equals(replyBody.getString("status"))) {
                        this.jsonResponse(ctx.response(), replyBody.getJsonObject("value"));
                    } else {
                        ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                        ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                    }
                } else {
                    ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                    ctx.response().end(reply.cause().getMessage());
                }
            });
        });
        this.router.routeWithRegex(".*").handler(ctx -> this.respondWith(StatusCode.METHOD_NOT_ALLOWED, ctx.request()));
    }

    public void handle(HttpServerRequest request) {
        this.router.handle((Object)request);
    }

    private void log(HttpServerRequest request, String logMessage) {
        RequestLoggerFactory.getLogger(QueueCircuitBreakerHttpRequestHandler.class, (HttpServerRequest)request).info(logMessage);
    }

    private void respondWith(StatusCode statusCode, String responseMessage, HttpServerRequest request) {
        this.log(request, "Responding with status code " + statusCode + " and message: " + responseMessage);
        request.response().setStatusCode(statusCode.getStatusCode());
        request.response().setStatusMessage(statusCode.getStatusMessage());
        request.response().end(responseMessage);
    }

    private void respondWith(StatusCode statusCode, HttpServerRequest request) {
        this.respondWith(statusCode, statusCode.getStatusMessage(), request);
    }

    private QueueCircuitState extractStatusFromBody(Buffer bodyBuffer) {
        if (StringUtils.isNotEmptyTrimmed((String)bodyBuffer.toString())) {
            try {
                JsonObject obj = bodyBuffer.toJsonObject();
                return QueueCircuitState.fromString(obj.getString("status"), null);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private void jsonResponse(HttpServerResponse response, JsonObject object) {
        response.putHeader(CONTENT_TYPE, APPLICATION_JSON);
        response.end(object.encode());
    }

    private String extractCircuitId(RoutingContext ctx) {
        return ctx.request().getParam("circuitId");
    }

    private void handleGetAllCircuitsRequest(RoutingContext ctx) {
        this.eventBus.request(HTTP_REQUEST_API_ADDRESS, (Object)QueueCircuitBreakerAPI.buildGetAllCircuitsOperation(), reply -> {
            if (reply.succeeded()) {
                JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                if ("ok".equals(replyBody.getString("status"))) {
                    this.jsonResponse(ctx.response(), replyBody.getJsonObject("value"));
                } else {
                    ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                    ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                }
            } else {
                ctx.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                ctx.response().end(reply.cause().getMessage());
            }
        });
    }

    private void registerAPIConsumer() {
        this.eventBus.localConsumer(HTTP_REQUEST_API_ADDRESS, event -> {
            String opString = ((JsonObject)event.body()).getString("operation");
            QueueCircuitBreakerAPI.Operation operation = QueueCircuitBreakerAPI.Operation.fromString(opString);
            if (operation == null) {
                this.unsupportedOperation(opString, (Message<JsonObject>)event);
                return;
            }
            switch (operation) {
                case getCircuitInformation: {
                    this.handleGetCircuitInformation((Message<JsonObject>)event);
                    break;
                }
                case getCircuitStatus: {
                    this.handleGetCircuitStatus((Message<JsonObject>)event);
                    break;
                }
                case closeCircuit: {
                    this.handleCloseCircuit((Message<JsonObject>)event);
                    break;
                }
                case closeAllCircuits: {
                    this.handleCloseAllCircuits((Message<JsonObject>)event);
                    break;
                }
                case getAllCircuits: {
                    this.handleGetAllCircuits((Message<JsonObject>)event);
                    break;
                }
                default: {
                    this.unsupportedOperation(opString, (Message<JsonObject>)event);
                }
            }
        });
    }

    private void handleGetCircuitInformation(Message<JsonObject> message) {
        String circuitHash = ((JsonObject)message.body()).getJsonObject("payload").getString("circuit");
        this.storage.getQueueCircuitInformation(circuitHash).onComplete(event -> {
            if (event.failed()) {
                message.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)event.cause().getMessage()));
                return;
            }
            message.reply((Object)new JsonObject().put("status", (Object)"ok").put("value", event.result()));
        });
    }

    private void handleGetCircuitStatus(Message<JsonObject> message) {
        String circuitHash = ((JsonObject)message.body()).getJsonObject("payload").getString("circuit");
        this.storage.getQueueCircuitState(circuitHash).onComplete(event -> {
            if (event.failed()) {
                message.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)event.cause().getMessage()));
                return;
            }
            message.reply((Object)new JsonObject().put("status", (Object)"ok").put("value", (Object)new JsonObject().put("status", (Object)((QueueCircuitState)((Object)((Object)event.result()))).name().toLowerCase())));
        });
    }

    private void handleCloseCircuit(Message<JsonObject> message) {
        String circuitHash = ((JsonObject)message.body()).getJsonObject("payload").getString("circuit");
        PatternAndCircuitHash patternAndCircuitHash = new PatternAndCircuitHash(null, circuitHash, null);
        this.storage.closeCircuit(patternAndCircuitHash).onComplete(event -> {
            if (event.failed()) {
                message.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)event.cause().getMessage()));
                return;
            }
            message.reply((Object)new JsonObject().put("status", (Object)"ok"));
        });
    }

    private void handleCloseAllCircuits(Message<JsonObject> message) {
        this.storage.closeAllCircuits().onComplete(event -> {
            if (event.failed()) {
                message.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)event.cause().getMessage()));
                return;
            }
            message.reply((Object)new JsonObject().put("status", (Object)"ok"));
        });
    }

    private void handleGetAllCircuits(Message<JsonObject> message) {
        this.storage.getAllCircuits().onComplete(event -> {
            if (event.failed()) {
                message.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)event.cause().getMessage()));
                return;
            }
            message.reply((Object)new JsonObject().put("status", (Object)"ok").put("value", event.result()));
        });
    }

    private void unsupportedOperation(String operation, Message<JsonObject> event) {
        JsonObject reply = new JsonObject();
        String message = "Unsupported operation received: " + operation;
        this.log.error(message);
        reply.put("status", (Object)"error");
        reply.put("message", (Object)message);
        event.reply((Object)reply);
    }
}

