/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.monitoring;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.exception.GateleenExceptionFactory;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.LockUtil;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;

public class QueueCircuitBreakerMetricsCollector {
    private final Logger log = LoggerFactory.getLogger(QueueCircuitBreakerMetricsCollector.class);
    private final Lock lock;
    private final LockUtil lockUtil;
    public static final String COLLECT_METRICS_TASK_LOCK = "collectCircuitBreakerMetrics";
    public static final String CIRCUIT_BREAKER_STATUS_METRIC = "gateleen.circuitbreaker.status";
    public static final String CIRCUIT_BREAKER_FAILRATIO_METRIC = "gateleen.circuitbreaker.failratio";
    private final QueueCircuitBreakerStorage queueCircuitBreakerStorage;
    private final MeterRegistry meterRegistry;
    private final long metricCollectionIntervalMs;
    private final Map<String, AtomicInteger> circuitStateMap = new HashMap<String, AtomicInteger>();
    private final Map<String, AtomicInteger> circuitFailRatioMap = new HashMap<String, AtomicInteger>();

    public QueueCircuitBreakerMetricsCollector(Vertx vertx, Lock lock, QueueCircuitBreakerStorage queueCircuitBreakerStorage, MeterRegistry meterRegistry, GateleenExceptionFactory exceptionFactory, long metricCollectionIntervalSeconds) {
        this.lock = lock;
        this.lockUtil = new LockUtil(exceptionFactory);
        this.queueCircuitBreakerStorage = queueCircuitBreakerStorage;
        this.meterRegistry = meterRegistry;
        this.metricCollectionIntervalMs = metricCollectionIntervalSeconds * 1000L;
        vertx.setPeriodic(this.metricCollectionIntervalMs, event -> this.collectMetrics().onFailure(event1 -> this.log.error("Could not collect metrics. Message: {}", (Object)event1.getMessage())));
    }

    public Future<Void> collectMetrics() {
        this.log.debug("Collecting metrics");
        Promise promise = Promise.promise();
        String token = this.createToken();
        LockUtil.acquireLock((Lock)this.lock, (String)COLLECT_METRICS_TASK_LOCK, (String)token, (long)LockUtil.calcLockExpiry((long)this.metricCollectionIntervalMs), (Logger)this.log).onComplete(lockEvent -> {
            if (lockEvent.succeeded()) {
                if (((Boolean)lockEvent.result()).booleanValue()) {
                    this.handleMetricsCollection(token).onComplete(event -> {
                        if (event.succeeded()) {
                            promise.complete();
                        } else {
                            promise.fail(event.cause());
                        }
                    });
                } else {
                    promise.complete();
                }
            } else {
                this.log.error("Could not acquire lock '{}'. Message: {}", (Object)COLLECT_METRICS_TASK_LOCK, (Object)lockEvent.cause().getMessage());
                promise.fail(lockEvent.cause().getMessage());
            }
        });
        return promise.future();
    }

    private Future<Void> handleMetricsCollection(String token) {
        return this.queueCircuitBreakerStorage.getAllCircuits().compose(entries -> {
            this.extractMetricsFromCircuitsObject((JsonObject)entries);
            return Future.succeededFuture();
        }).andThen(event -> this.lockUtil.releaseLock(this.lock, COLLECT_METRICS_TASK_LOCK, token, this.log));
    }

    private void extractMetricsFromCircuitsObject(JsonObject circuits) {
        circuits.stream().forEach(entry -> {
            String circuitName = (String)entry.getKey();
            JsonObject circuitValue = (JsonObject)entry.getValue();
            QueueCircuitState queueCircuitState = QueueCircuitState.fromString(circuitValue.getString("status"), null);
            if (queueCircuitState == null) {
                this.log.warn("No status found for circuit '{}'", (Object)circuitName);
                return;
            }
            JsonObject infos = circuitValue.getJsonObject("infos");
            if (infos != null) {
                String metric = infos.getString("metricName");
                Integer failRatio = infos.getInteger("failRatio");
                if (metric != null && failRatio != null) {
                    this.publishMetric(metric, queueCircuitState, failRatio);
                }
            }
        });
    }

    private void publishMetric(String metricName, QueueCircuitState queueCircuitState, int failRatio) {
        Integer stateValue = this.circuitStateToValue(queueCircuitState);
        if (stateValue != null) {
            this.getCircuitStateMeter(metricName).set(stateValue);
        }
        this.getCircuitFailRatioMeter(metricName).set(failRatio);
    }

    private String createToken() {
        return Address.instanceAddress() + "_" + System.currentTimeMillis() + "_collectCircuitBreakerMetrics";
    }

    private AtomicInteger getCircuitStateMeter(String metricName) {
        return this.circuitStateMap.computeIfAbsent(metricName, key -> {
            AtomicInteger newMeterValue = new AtomicInteger();
            Gauge.builder((String)CIRCUIT_BREAKER_STATUS_METRIC, (Object)newMeterValue, AtomicInteger::get).description("Status of the circuit, 0=CLOSED, 1=HALF_OPEN, 2=OPEN").tag("metricName", metricName).register(this.meterRegistry);
            return newMeterValue;
        });
    }

    private AtomicInteger getCircuitFailRatioMeter(String metricName) {
        return this.circuitFailRatioMap.computeIfAbsent(metricName, key -> {
            AtomicInteger newMeterValue = new AtomicInteger();
            Gauge.builder((String)CIRCUIT_BREAKER_FAILRATIO_METRIC, (Object)newMeterValue, AtomicInteger::get).description("Fail ratio of the circuit in percentage").tag("metricName", metricName).register(this.meterRegistry);
            return newMeterValue;
        });
    }

    private Integer circuitStateToValue(QueueCircuitState queueCircuitState) {
        switch (queueCircuitState) {
            case CLOSED: {
                return 0;
            }
            case HALF_OPEN: {
                return 1;
            }
            case OPEN: {
                return 2;
            }
        }
        return null;
    }
}

