/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.splitter;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class QueueSplitterConfiguration {
    private final Pattern queue;
    private final String postfixDelimiter;
    @Nullable
    private final List<String> postfixFromStatic;
    @Nullable
    private final String postfixFromHeader;
    @Nullable
    private final Pattern postfixFromUrl;

    public QueueSplitterConfiguration(Pattern queue, String postfixDelimiter, @Nullable List<String> postfixFromStatic, @Nullable String postfixFromHeader, @Nullable Pattern postfixFromUrl) {
        this.queue = queue;
        this.postfixDelimiter = postfixDelimiter;
        this.postfixFromStatic = postfixFromStatic;
        this.postfixFromHeader = postfixFromHeader;
        this.postfixFromUrl = postfixFromUrl;
    }

    public Pattern getQueue() {
        return this.queue;
    }

    public String getPostfixDelimiter() {
        return this.postfixDelimiter;
    }

    @Nullable
    public List<String> getPostfixFromStatic() {
        return this.postfixFromStatic;
    }

    @Nullable
    public String getPostfixFromHeader() {
        return this.postfixFromHeader;
    }

    @Nullable
    public Pattern getPostfixFromUrl() {
        return this.postfixFromUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueSplitterConfiguration that = (QueueSplitterConfiguration)o;
        return Objects.equals(this.queue, that.queue) && Objects.equals(this.postfixDelimiter, that.postfixDelimiter) && Objects.equals(this.postfixFromStatic, that.postfixFromStatic) && Objects.equals(this.postfixFromHeader, that.postfixFromHeader) && Objects.equals(this.postfixFromUrl, that.postfixFromUrl);
    }

    public int hashCode() {
        return Objects.hash(this.queue, this.postfixDelimiter, this.postfixFromStatic, this.postfixFromHeader, this.postfixFromUrl);
    }

    public String toString() {
        return "QueueSplitterConfiguration{queue=" + String.valueOf(this.queue) + ", postfixDelimiter='" + this.postfixDelimiter + "', postfixFromStatic=" + String.valueOf(this.postfixFromStatic) + ", postfixFromHeader='" + this.postfixFromHeader + "', postfixFromUrl='" + String.valueOf(this.postfixFromUrl) + "'}";
    }

    public boolean isSplitStatic() {
        return this.postfixFromStatic != null && !this.postfixFromStatic.isEmpty();
    }

    public boolean isSplitFromRequest() {
        return this.postfixFromHeader != null || this.postfixFromUrl != null;
    }
}

