/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.splitter;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceConsumer;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitter;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitterConfiguration;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitterConfigurationParser;
import org.swisspush.gateleen.queue.queuing.splitter.executors.QueueSplitExecutor;
import org.swisspush.gateleen.queue.queuing.splitter.executors.QueueSplitExecutorFromRequest;
import org.swisspush.gateleen.queue.queuing.splitter.executors.QueueSplitExecutorFromStaticList;

public class QueueSplitterImpl
extends ConfigurationResourceConsumer
implements QueueSplitter {
    private final Logger log = LoggerFactory.getLogger(QueueSplitterImpl.class);
    private final Map<String, Object> properties;
    private List<QueueSplitExecutor> queueSplitExecutors = new ArrayList<QueueSplitExecutor>();

    public QueueSplitterImpl(ConfigurationResourceManager configurationResourceManager, String configResourceUri) {
        this(configurationResourceManager, configResourceUri, new HashMap<String, Object>());
    }

    public QueueSplitterImpl(ConfigurationResourceManager configurationResourceManager, String configResourceUri, Map<String, Object> properties) {
        super(configurationResourceManager, configResourceUri, "gateleen_queue_splitter_configuration_schema");
        this.properties = properties;
    }

    @Override
    public Future<Void> initialize() {
        Promise promise = Promise.promise();
        this.configurationResourceManager().getRegisteredResource(this.configResourceUri()).onComplete(event -> {
            if (event.succeeded() && ((Optional)event.result()).isPresent()) {
                this.initializeQueueSplitterConfiguration((Buffer)((Optional)event.result()).get());
                promise.complete();
            } else {
                this.log.warn("No queue splitter configuration resource with uri '{}' found. Unable to setup splitter configuration correctly", (Object)this.configResourceUri());
                promise.complete();
            }
        });
        return promise.future();
    }

    private void initializeQueueSplitterConfiguration(Buffer configuration) {
        List<QueueSplitterConfiguration> configurations = QueueSplitterConfigurationParser.parse(configuration, this.properties);
        this.queueSplitExecutors.clear();
        this.queueSplitExecutors = configurations.stream().map(queueSplitterConfiguration -> {
            if (queueSplitterConfiguration.isSplitStatic()) {
                return new QueueSplitExecutorFromStaticList((QueueSplitterConfiguration)queueSplitterConfiguration);
            }
            return new QueueSplitExecutorFromRequest((QueueSplitterConfiguration)queueSplitterConfiguration);
        }).collect(Collectors.toList());
    }

    @Override
    public String convertToSubQueue(String queue, HttpServerRequest request) {
        Optional<QueueSplitExecutor> executor = this.queueSplitExecutors.stream().filter(splitExecutor -> splitExecutor.matches(queue)).findFirst();
        return executor.isPresent() ? executor.get().executeSplit(queue, request) : queue;
    }

    public void resourceChanged(String resourceUri, Buffer resource) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Queue splitter configuration resource {} was updated. Going to initialize with new configuration", (Object)resourceUri);
            this.initializeQueueSplitterConfiguration(resource);
        }
    }

    public void resourceRemoved(String resourceUri) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Queue splitter configuration resource {} was removed. Going to release all executors", (Object)resourceUri);
            this.queueSplitExecutors.clear();
        }
    }
}

