/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueueBrowser
implements Handler<HttpServerRequest> {
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE = "content-type";
    public static final String UTF_8 = "UTF-8";
    public static final String PAYLOAD = "payload";
    private static Logger log = LoggerFactory.getLogger(QueueBrowser.class);
    private static final int DEFAULT_QUEUE_NUM = 1000;
    private static final int DEFAULT_MAX_QUEUEITEM_COUNT = 49;
    private static final String SHOW_EMPTY_QUEUES_PARAM = "showEmptyQueues";
    private EventBus eb;
    private final String redisquesAddress;
    private Router router;

    public QueueBrowser(Vertx vertx, String prefix, String redisquesAddress, MonitoringHandler monitoringHandler) {
        this.router = Router.router((Vertx)vertx);
        this.redisquesAddress = redisquesAddress;
        this.eb = vertx.eventBus();
        this.router.get(prefix + "/").handler(ctx -> {
            JsonObject result = new JsonObject();
            JsonArray items = new JsonArray();
            items.add((Object)"locks/");
            items.add((Object)"monitoring");
            items.add((Object)"queues/");
            result.put(this.lastPart(ctx.request().path(), "/"), (Object)items);
            ctx.response().putHeader(CONTENT_TYPE, APPLICATION_JSON);
            ctx.response().end(result.encode());
        });
        this.router.get(prefix + "/queues/").handler(ctx -> monitoringHandler.updateQueuesSizesInformation(1000, false, new MonitoringHandler.MonitoringCallback((RoutingContext)ctx){
            final /* synthetic */ RoutingContext val$ctx;
            {
                this.val$ctx = routingContext;
            }

            public void onDone(JsonObject result) {
                JsonArray array = result.getJsonArray("queues");
                JsonArray resultArray = new JsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject arrayEntry = array.getJsonObject(i);
                    resultArray.add((Object)arrayEntry.getString("name"));
                }
                result.put(QueueBrowser.this.lastPart(this.val$ctx.request().path(), "/"), (Object)resultArray);
                QueueBrowser.this.jsonResponse(this.val$ctx.response(), result);
            }

            public void onFail(String errorMessage, int statusCode) {
                this.val$ctx.response().setStatusCode(statusCode);
                this.val$ctx.response().setStatusMessage(errorMessage);
                this.val$ctx.response().end();
            }
        }));
        this.router.getWithRegex(prefix + "/queues/[^/]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path(), "/");
            String limitParam = null;
            if (ctx.request() != null && ctx.request().params().contains("limit")) {
                limitParam = ctx.request().params().get("limit");
            }
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildGetQueueItemsOperation((String)queue, limitParam), reply -> {
                JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                if ("ok".equals(replyBody.getString("status"))) {
                    List list = ((JsonObject)((Message)reply.result()).body()).getJsonArray("value").getList();
                    JsonArray items = new JsonArray();
                    for (Object item : list.toArray()) {
                        items.add((Object)((String)item));
                    }
                    JsonObject result = new JsonObject().put(queue, (Object)items);
                    this.jsonResponse(ctx.response(), result);
                } else {
                    ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                    ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("message"));
                    log.warn("Error in routerMatcher.getWithRegEx. Command = '" + (replyBody.getString("command") == null ? "<null>" : replyBody.getString("command")) + "'.");
                }
            });
        });
        this.router.deleteWithRegex(prefix + "/queues/[^/]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path(), "/");
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildDeleteAllQueueItemsOperation((String)queue), reply -> ctx.response().end());
        });
        this.router.getWithRegex(prefix + "/queues/([^/]+)/[0-9]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path().substring(0, ctx.request().path().length() - 2), "/");
            int index = Integer.parseInt(this.lastPart(ctx.request().path(), "/"));
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildGetQueueItemOperation((String)queue, (int)index), reply -> {
                JsonObject replyBody = (JsonObject)((Message)reply.result()).body();
                if ("ok".equals(replyBody.getString("status"))) {
                    ctx.response().putHeader(CONTENT_TYPE, APPLICATION_JSON);
                    ctx.response().end(this.decode(((JsonObject)((Message)reply.result()).body()).getString("value")));
                } else {
                    ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                    ctx.response().setStatusMessage(StatusCode.NOT_FOUND.getStatusMessage());
                    ctx.response().end("Not Found");
                }
            });
        });
        this.router.putWithRegex(prefix + "/queues/([^/]+)/[0-9]+").handler(ctx -> {
            String queue = this.part(ctx.request().path(), "/", 2);
            this.checkLocked(queue, ctx.request(), (Handler<Void>)((Handler)aVoid -> {
                int index = Integer.parseInt(this.lastPart(ctx.request().path(), "/"));
                ctx.request().bodyHandler(buffer -> {
                    String strBuffer = this.encode(buffer.toString());
                    this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildReplaceQueueItemOperation((String)queue, (int)index, (String)strBuffer), reply -> this.checkReply((Message<JsonObject>)((Message)reply.result()), ctx.request(), StatusCode.NOT_FOUND));
                });
            }));
        });
        this.router.deleteWithRegex(prefix + "/queues/([^/]+)/[0-9]+").handler(ctx -> {
            String queue = this.part(ctx.request().path(), "/", 2);
            int index = Integer.parseInt(this.lastPart(ctx.request().path(), "/"));
            this.checkLocked(queue, ctx.request(), (Handler<Void>)((Handler)aVoid -> this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildDeleteQueueItemOperation((String)queue, (int)index), reply -> this.checkReply((Message<JsonObject>)((Message)reply.result()), ctx.request(), StatusCode.NOT_FOUND))));
        });
        this.router.postWithRegex(prefix + "/queues/([^/]+)/").handler(ctx -> {
            String queue = this.part(ctx.request().path(), "/", 1);
            ctx.request().bodyHandler(buffer -> {
                String strBuffer = this.encode(buffer.toString());
                this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildAddQueueItemOperation((String)queue, (String)strBuffer), reply -> this.checkReply((Message<JsonObject>)((Message)reply.result()), ctx.request(), StatusCode.BAD_REQUEST));
            });
        });
        this.router.getWithRegex(prefix + "/locks/").handler(ctx -> this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildGetAllLocksOperation(), reply -> {
            if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                this.jsonResponse(ctx.response(), ((JsonObject)((Message)reply.result()).body()).getJsonObject("value"));
            } else {
                ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                ctx.response().setStatusMessage(StatusCode.NOT_FOUND.getStatusMessage());
                ctx.response().end("Not Found");
            }
        }));
        this.router.putWithRegex(prefix + "/locks/[^/]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path(), "/");
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildPutLockOperation((String)queue, (String)this.extractUser(ctx.request())), reply -> this.checkReply((Message<JsonObject>)((Message)reply.result()), ctx.request(), StatusCode.BAD_REQUEST));
        });
        this.router.getWithRegex(prefix + "/locks/[^/]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path(), "/");
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildGetLockOperation((String)queue), reply -> {
                if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                    ctx.response().putHeader(CONTENT_TYPE, APPLICATION_JSON);
                    ctx.response().end(((JsonObject)((Message)reply.result()).body()).getString("value"));
                } else {
                    ctx.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                    ctx.response().setStatusMessage(StatusCode.NOT_FOUND.getStatusMessage());
                    ctx.response().end("No such lock");
                }
            });
        });
        this.router.deleteWithRegex(prefix + "/locks/[^/]+").handler(ctx -> {
            String queue = this.lastPart(ctx.request().path(), "/");
            this.eb.request(redisquesAddress, (Object)RedisquesAPI.buildDeleteLockOperation((String)queue), reply -> this.checkReply((Message<JsonObject>)((Message)reply.result()), ctx.request(), StatusCode.BAD_REQUEST));
        });
        this.router.getWithRegex(prefix + "/monitoring/[^/]*").handler(ctx -> {
            int numQueues = this.extractNumOfQueuesValue(ctx.request().path(), "/");
            boolean showEmptyQueues = this.showEmptyQueues(ctx.request().params());
            monitoringHandler.updateQueuesSizesInformation(numQueues, showEmptyQueues, new MonitoringHandler.MonitoringCallback((RoutingContext)ctx){
                final /* synthetic */ RoutingContext val$ctx;
                {
                    this.val$ctx = routingContext;
                }

                public void onDone(JsonObject result) {
                    QueueBrowser.this.jsonResponse(this.val$ctx.response(), result);
                }

                public void onFail(String errorMessage, int statusCode) {
                    this.val$ctx.response().setStatusCode(statusCode);
                    this.val$ctx.response().setStatusMessage(errorMessage);
                    this.val$ctx.response().end();
                }
            });
        });
    }

    private String extractUser(HttpServerRequest request) {
        String user = request.headers().get("x-rp-usr");
        if (user == null) {
            user = "Unknown";
        }
        return user;
    }

    private void checkReply(Message<JsonObject> reply, HttpServerRequest request, StatusCode statusCode) {
        if ("ok".equals(((JsonObject)reply.body()).getString("status"))) {
            request.response().end();
        } else {
            request.response().setStatusCode(statusCode.getStatusCode());
            request.response().setStatusMessage(statusCode.getStatusMessage());
            request.response().end(statusCode.getStatusMessage());
        }
    }

    private String lastPart(String source, String separator) {
        String[] tokens = source.split(separator);
        return tokens[tokens.length - 1];
    }

    private String part(String source, String separator, int pos) {
        String[] tokens = source.split(separator);
        return tokens[tokens.length - pos];
    }

    private boolean showEmptyQueues(MultiMap requestParams) {
        String showEmptyQueues = StringUtils.getStringOrEmpty((String)requestParams.get(SHOW_EMPTY_QUEUES_PARAM));
        return showEmptyQueues.equalsIgnoreCase("true") || showEmptyQueues.equals("1");
    }

    private int getMaxQueueItemCountIndex(HttpServerRequest request) {
        int defaultMaxIndex = 49;
        if (request != null && request.params().contains("limit")) {
            String limitParam = request.params().get("limit");
            try {
                int maxIndex = Integer.parseInt(limitParam) - 1;
                if (maxIndex >= 0) {
                    defaultMaxIndex = maxIndex;
                }
            }
            catch (NumberFormatException ex) {
                log.warn("Invalid limit parameter '{}' configured for max queue item count. Using default {}", (Object)limitParam, (Object)49);
            }
        }
        return defaultMaxIndex;
    }

    private int extractNumOfQueuesValue(String source, String separator) {
        Integer numQueues;
        String numberOfQueuesStr = this.lastPart(source, separator);
        try {
            numQueues = Integer.parseInt(numberOfQueuesStr);
        }
        catch (Exception e) {
            numQueues = 1000;
            log.warn("Queue size monitoring url was used with wrong or without number of queues param. Using default {}", (Object)1000);
        }
        return numQueues;
    }

    public void handle(HttpServerRequest request) {
        this.router.handle((Object)request);
    }

    public String encode(String decoded) {
        JsonObject object = new JsonObject(decoded);
        JsonObject payloadObject = object.getJsonObject("payloadObject");
        String payloadString = payloadObject != null ? payloadObject.encode() : object.getString("payloadString");
        if (payloadString != null) {
            object.put(PAYLOAD, (Object)payloadString.getBytes(Charset.forName(UTF_8)));
            object.remove("payloadString");
            object.remove("payloadObject");
        }
        int length = 0;
        if (object.containsKey(PAYLOAD)) {
            length = object.getBinary(PAYLOAD).length;
        }
        JsonArray newHeaders = new JsonArray();
        for (Object headerObj : object.getJsonArray("headers")) {
            JsonArray header = (JsonArray)headerObj;
            String key = header.getString(0);
            if (key.equalsIgnoreCase("content-length")) {
                JsonArray contentLengthHeader = new JsonArray();
                contentLengthHeader.add((Object)"Content-Length");
                contentLengthHeader.add((Object)Integer.toString(length));
                newHeaders.add((Object)contentLengthHeader);
                continue;
            }
            newHeaders.add((Object)header);
        }
        object.put("headers", (Object)newHeaders);
        return object.toString();
    }

    public String decode(String encoded) {
        JsonObject object = new JsonObject(encoded);
        JsonArray headers = object.getJsonArray("headers");
        for (Object headerObj : headers) {
            JsonArray header = (JsonArray)headerObj;
            String key = header.getString(0);
            String value = header.getString(1);
            if (!key.equalsIgnoreCase(CONTENT_TYPE) || !value.contains("text/") && !value.contains(APPLICATION_JSON)) continue;
            try {
                object.put("payloadObject", (Object)new JsonObject(new String(object.getBinary(PAYLOAD), Charset.forName(UTF_8))));
            }
            catch (DecodeException e) {
                object.put("payloadString", (Object)new String(object.getBinary(PAYLOAD), Charset.forName(UTF_8)));
            }
            object.remove(PAYLOAD);
            break;
        }
        return object.toString();
    }

    private void checkLocked(String queue, HttpServerRequest request, Handler<Void> handler) {
        request.pause();
        this.eb.request(this.redisquesAddress, (Object)RedisquesAPI.buildGetLockOperation((String)queue), reply -> {
            if ("No such lock".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                request.resume();
                request.response().setStatusCode(StatusCode.CONFLICT.getStatusCode());
                request.response().setStatusMessage("Queue must be locked to perform this operation");
                request.response().end("Queue must be locked to perform this operation");
            } else {
                handler.handle(null);
                request.resume();
            }
        });
    }

    private void jsonResponse(HttpServerResponse response, JsonObject object) {
        response.putHeader(CONTENT_TYPE, APPLICATION_JSON);
        response.end(object.encode());
    }
}

