/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.Response;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.util.RedisUtils;

public class UnlockSampleQueuesRedisCommand
implements RedisCommand {
    private final LuaScriptState luaScriptState;
    private final List<String> keys;
    private final List<String> arguments;
    private final Promise<Response> promise;
    private final RedisProvider redisProvider;
    private final Logger log;

    public UnlockSampleQueuesRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisProvider redisProvider, Logger log, Promise<Response> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisProvider = redisProvider;
        this.log = log;
        this.promise = promise;
    }

    public void exec(int executionCounter) {
        List args = RedisUtils.toPayload((Object[])new Object[]{this.luaScriptState.getSha(), this.keys.size(), this.keys, this.arguments});
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                Response result = (Response)event.result();
                this.promise.complete((Object)result);
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("UnlockSampleQueuesRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: {}", (Object)executionCounter);
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new UnlockSampleQueuesRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisProvider, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("UnlockSampleQueuesRedisCommand request failed with message: " + message);
                }
            }
        })).onFailure(throwable -> this.promise.fail("Redis: UnlockSampleQueuesRedisCommand request failed with message: " + throwable.getMessage()));
    }
}

