/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.runconfig;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.redis.RedisClient;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Log4jConfigurer;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.cors.CORSHandler;
import org.swisspush.gateleen.core.event.EventBusHandler;
import org.swisspush.gateleen.core.property.PropertyHandler;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.resource.CopyResourceHandler;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.delegate.DelegateHandler;
import org.swisspush.gateleen.delta.DeltaHandler;
import org.swisspush.gateleen.expansion.ExpansionHandler;
import org.swisspush.gateleen.expansion.ZipExtractHandler;
import org.swisspush.gateleen.hook.HookHandler;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.merge.MergeHandler;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.packing.PackingHandler;
import org.swisspush.gateleen.qos.QoSHandler;
import org.swisspush.gateleen.queue.queuing.QueueBrowser;
import org.swisspush.gateleen.queue.queuing.QueuingHandler;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.routing.Router;
import org.swisspush.gateleen.scheduler.SchedulerResourceManager;
import org.swisspush.gateleen.security.authorization.Authorizer;
import org.swisspush.gateleen.user.RoleProfileHandler;
import org.swisspush.gateleen.user.UserProfileConfiguration;
import org.swisspush.gateleen.user.UserProfileHandler;
import org.swisspush.gateleen.validation.ValidationHandler;
import org.swisspush.gateleen.validation.ValidationResourceManager;
import org.swisspush.redisques.util.RedisquesConfiguration;
import org.swisspush.reststorage.util.ModuleConfiguration;

public class RunConfig {
    public static final String SERVER_TIMESTAMP_HEADER = "X-Server-Timestamp";
    public static final String SERVER_ARRIVAL_TIMESTAMP_HEADER = "X-Server-Arrival-Timestamp";
    public static final long EVENTBUS_BRIDGE_PING_INTERVAL = 600000L;
    public static final String ROOT = "/playground";
    public static final String SERVER_NAME = "gateleen";
    public static final String SERVER_ROOT = "/playground/server";
    public static final String ROLE_PATTERN = "^z-gateleen[-_](.*)$";
    public static final String[] PROFILE_PROPERTIES_PROVIDED_BY_THE_PROXY = new String[]{"username", "personalNumber", "fullname", "mail", "department", "lang"};
    public static final String[] PROFILE_PROPERTIES_PROVIDED_BY_THE_CLIENT = new String[]{"tour", "zip", "context", "contextIsDefault", "passkeyChanged", "volumeBeep", "torchMode", "spn"};
    private DateTimeFormatter dfISO8601;
    private DateTimeFormatter isoDateTimeParser;
    private Logger log;
    private Logger requestLog;
    private Random random;
    private final Class verticleClass;
    private Vertx vertx;
    private RedisClient redisClient;
    private Router router;
    private CORSHandler corsHandler;
    private SchedulerResourceManager schedulerResourceManager;
    private ValidationResourceManager validationResourceManager;
    private LoggingResourceManager loggingResourceManager;
    private ConfigurationResourceManager configurationResourceManager;
    private QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager;
    private EventBusHandler eventBusHandler;
    private ValidationHandler validationHandler;
    private HookHandler hookHandler;
    private UserProfileHandler userProfileHandler;
    private RoleProfileHandler roleProfileHandler;
    private ExpansionHandler expansionHandler;
    private DeltaHandler deltaHandler;
    private MonitoringHandler monitoringHandler;
    private QueueBrowser queueBrowser;
    private Authorizer authorizer;
    private CopyResourceHandler copyResourceHandler;
    private QoSHandler qosHandler;
    private PropertyHandler propertyHandler;
    private ZipExtractHandler zipExtractHandler;
    private DelegateHandler delegateHandler;
    private MergeHandler mergeHandler;

    public RunConfig(Vertx vertx, RedisClient redisClient, Class verticleClass, Router router, MonitoringHandler monitoringHandler, QueueBrowser queueBrowser, CORSHandler corsHandler, SchedulerResourceManager schedulerResourceManager, ValidationResourceManager validationResourceManager, LoggingResourceManager loggingResourceManager, ConfigurationResourceManager configurationResourceManager, QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager, EventBusHandler eventBusHandler, ValidationHandler validationHandler, HookHandler hookHandler, UserProfileHandler userProfileHandler, RoleProfileHandler roleProfileHandler, ExpansionHandler expansionHandler, DeltaHandler deltaHandler, Authorizer authorizer, CopyResourceHandler copyResourceHandler, QoSHandler qosHandler, PropertyHandler propertyHandler, ZipExtractHandler zipExtractHandler, DelegateHandler delegateHandler, MergeHandler mergeHandler) {
        this.vertx = vertx;
        this.redisClient = redisClient;
        this.verticleClass = verticleClass;
        this.router = router;
        this.monitoringHandler = monitoringHandler;
        this.queueBrowser = queueBrowser;
        this.corsHandler = corsHandler;
        this.schedulerResourceManager = schedulerResourceManager;
        this.validationResourceManager = validationResourceManager;
        this.loggingResourceManager = loggingResourceManager;
        this.configurationResourceManager = configurationResourceManager;
        this.queueCircuitBreakerConfigurationResourceManager = queueCircuitBreakerConfigurationResourceManager;
        this.eventBusHandler = eventBusHandler;
        this.validationHandler = validationHandler;
        this.hookHandler = hookHandler;
        this.userProfileHandler = userProfileHandler;
        this.roleProfileHandler = roleProfileHandler;
        this.expansionHandler = expansionHandler;
        this.deltaHandler = deltaHandler;
        this.authorizer = authorizer;
        this.copyResourceHandler = copyResourceHandler;
        this.qosHandler = qosHandler;
        this.propertyHandler = propertyHandler;
        this.zipExtractHandler = zipExtractHandler;
        this.delegateHandler = delegateHandler;
        this.mergeHandler = mergeHandler;
        this.init();
    }

    private RunConfig(RunConfigBuilder builder) {
        this(builder.vertx, builder.redisClient, builder.verticleClass, builder.router, builder.monitoringHandler, builder.queueBrowser, builder.corsHandler, builder.schedulerResourceManager, builder.validationResourceManager, builder.loggingResourceManager, builder.configurationResourceManager, builder.queueCircuitBreakerConfigurationResourceManager, builder.eventBusHandler, builder.validationHandler, builder.hookHandler, builder.userProfileHandler, builder.roleProfileHandler, builder.expansionHandler, builder.deltaHandler, builder.authorizer, builder.copyResourceHandler, builder.qosHandler, builder.propertyHandler, builder.zipExtractHandler, builder.delegateHandler, builder.mergeHandler);
    }

    private void init() {
        this.random = new Random(System.currentTimeMillis());
        this.log = LoggerFactory.getLogger((Class)this.verticleClass);
        this.requestLog = LoggerFactory.getLogger((String)"Request");
        this.dfISO8601 = ISODateTimeFormat.dateTime().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
        this.isoDateTimeParser = ISODateTimeFormat.dateTimeParser();
        String conf = "classpath:gateleen/config/logging/log4j.xml";
        this.log.info("gateleen starting with log configuration " + conf);
        try {
            Log4jConfigurer.initLogging((String)conf);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static RunConfigBuilder with() {
        return new RunConfigBuilder();
    }

    public static Map<String, Object> buildRedisProps(String redisHost, int redisPort) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("redis.host", redisHost);
        props.put("redis.port", redisPort);
        props.put("redis.encoding", "UTF-8");
        return props;
    }

    public static JsonObject buildModRedisConfig(String redisHost, int redisPort) {
        JsonObject config = new JsonObject();
        config.put("host", redisHost);
        config.put("port", Integer.valueOf(redisPort));
        config.put("encoding", "UTF-8");
        return config;
    }

    public static JsonObject buildMetricsConfig() {
        JsonObject metricsConfig = new JsonObject();
        metricsConfig.put("address", Address.monitoringAddress());
        return metricsConfig;
    }

    public static JsonObject buildRedisquesConfig() {
        return RedisquesConfiguration.with().address(Address.redisquesAddress()).processorAddress(Address.queueProcessorAddress()).httpRequestHandlerEnabled(true).httpRequestHandlerPort(Integer.valueOf(7015)).build().asJsonObject();
    }

    public static JsonObject buildStorageConfig() {
        return ModuleConfiguration.with().storageType(ModuleConfiguration.StorageType.redis).storageAddress(Address.storageAddress() + "-main").build().asJsonObject();
    }

    public static UserProfileConfiguration buildUserProfileConfiguration() {
        String[] allAllowedProfileProperties = (String[])ArrayUtils.addAll((Object[])PROFILE_PROPERTIES_PROVIDED_BY_THE_PROXY, (Object[])PROFILE_PROPERTIES_PROVIDED_BY_THE_CLIENT);
        String matchEverythingExceptUnknown = "(?!^unknown$).*";
        String fallbackValue = "unknown";
        UserProfileConfiguration.ProfileProperty departmentConfig = UserProfileConfiguration.ProfileProperty.with((String)"x-rp-department", (String)"department").setUpdateStrategy(UserProfileConfiguration.UpdateStrategy.UPDATE_ALWAYS).setValueToUseIfNoOtherValidValue("unknown").validationRegex("(?!^unknown$).*").setOptional(false).build();
        UserProfileConfiguration.ProfileProperty mailConfig = UserProfileConfiguration.ProfileProperty.with((String)"x-rp-mail", (String)"mail").setUpdateStrategy(UserProfileConfiguration.UpdateStrategy.UPDATE_ALWAYS).setValueToUseIfNoOtherValidValue("unknown").validationRegex("(?!^unknown$).*").setOptional(false).build();
        UserProfileConfiguration.ProfileProperty employeeIdConfig = UserProfileConfiguration.ProfileProperty.with((String)"x-rp-employeeid", (String)"personalNumber").validationRegex("\\d*{8}").setUpdateStrategy(UserProfileConfiguration.UpdateStrategy.UPDATE_ALWAYS).setValueToUseIfNoOtherValidValue("unknown").setOptional(false).build();
        UserProfileConfiguration.ProfileProperty usernameConfig = UserProfileConfiguration.ProfileProperty.with((String)"x-rp-usr", (String)"username").setUpdateStrategy(UserProfileConfiguration.UpdateStrategy.UPDATE_ONLY_IF_PROFILE_VALUE_IS_INVALID).setOptional(false).build();
        UserProfileConfiguration.ProfileProperty fullNameConfig = UserProfileConfiguration.ProfileProperty.with((String)"x-rp-displayname", (String)"fullName").setUpdateStrategy(UserProfileConfiguration.UpdateStrategy.UPDATE_ALWAYS).setOptional(false).build();
        return UserProfileConfiguration.create().userProfileUriPattern("/playground/server/users/v1/([^/]+)/profile").roleProfilesRoot("/playground/server/roles/v1/").rolePattern(ROLE_PATTERN).addAllowedProfileProperties(allAllowedProfileProperties).addProfileProperty(departmentConfig).addProfileProperty(mailConfig).addProfileProperty(employeeIdConfig).addProfileProperty(usernameConfig).addProfileProperty(fullNameConfig).build();
    }

    public static void deployModules(Vertx vertx, Class verticleClass, Map<String, Object> props, Handler<Boolean> handler) {
        Logger log = LoggerFactory.getLogger((Class)verticleClass);
        String redisHost = (String)props.get("redis.host");
        Integer redisPort = (Integer)props.get("redis.port");
        log.info("deploying redis module with host:" + redisHost + " port:" + redisPort);
        vertx.deployVerticle("org.swisspush.redisques.RedisQues", new DeploymentOptions().setConfig(RunConfig.buildRedisquesConfig()).setInstances(4), event -> {
            if (event.failed()) {
                log.error("Could not load redisques module", event.cause());
                handler.handle((Object)false);
                return;
            }
            vertx.deployVerticle("org.swisspush.reststorage.RestStorageMod", new DeploymentOptions().setConfig(RunConfig.buildStorageConfig()).setInstances(4), event1 -> {
                if (event1.failed()) {
                    log.error("Could not load rest storage redis module", event1.cause());
                    handler.handle((Object)false);
                    return;
                }
                vertx.deployVerticle("org.swisspush.metrics.MetricsModule", new DeploymentOptions().setConfig(RunConfig.buildMetricsConfig()), event2 -> {
                    if (event2.failed()) {
                        log.error("Could not load metrics module", event2.cause());
                        handler.handle((Object)false);
                        return;
                    }
                    handler.handle((Object)true);
                });
            });
        });
    }

    public Handler<RoutingContext> buildRoutingContextHandler() {
        if (this.propertyHandler != null) {
            if (this.router != null) {
                this.propertyHandler.addRefreshable((Refreshable)this.router);
            }
            if (this.schedulerResourceManager != null) {
                this.propertyHandler.addRefreshable((Refreshable)this.schedulerResourceManager);
            }
        }
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                HttpServerRequest request = ctx.request();
                if (!request.headers().contains("x-rp-unique_id")) {
                    request.headers().set("x-rp-unique_id", new UUID(RunConfig.this.random.nextLong(), RunConfig.this.random.nextLong()).toString().replace("-", ""));
                }
                request.exceptionHandler(exception -> LoggerFactory.getLogger((Class)RunConfig.this.verticleClass).trace("Exception in client", exception));
                RunConfig.this.logRequest(request);
                if (RunConfig.this.qosHandler != null && RunConfig.this.qosHandler.handle(request)) {
                    return;
                }
                if (RunConfig.this.corsHandler != null) {
                    RunConfig.this.corsHandler.handle(request);
                    if (RunConfig.this.corsHandler.isOptionsRequest(request)) {
                        return;
                    }
                }
                if (RunConfig.this.authorizer != null) {
                    RunConfig.this.authorizer.authorize(request).setHandler(event -> {
                        if (event.succeeded() && ((Boolean)event.result()).booleanValue()) {
                            this.handleRequest(request);
                        } else if (event.failed()) {
                            ResponseStatusCodeLogUtil.debug((HttpServerRequest)request, (StatusCode)StatusCode.INTERNAL_SERVER_ERROR, RunConfig.class);
                            request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                            request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
                            request.response().end(event.cause().getMessage());
                        }
                    });
                } else {
                    this.handleRequest(request);
                }
            }

            private void handleRequest(HttpServerRequest request) {
                if (request.path().equals("/playground/server/cleanup")) {
                    QueuingHandler.cleanup((Vertx)RunConfig.this.vertx);
                    request.response().end();
                    return;
                }
                if (PackingHandler.isPacked((HttpServerRequest)request)) {
                    request.bodyHandler((Handler)new PackingHandler(request, (Handler)new QueuingHandler(RunConfig.this.vertx, RunConfig.this.redisClient, request, RunConfig.this.monitoringHandler)));
                } else if (QueuingHandler.isQueued((HttpServerRequest)request)) {
                    RunConfig.this.setISO8601Timestamps(request);
                    request.bodyHandler((Handler)new QueuingHandler(RunConfig.this.vertx, RunConfig.this.redisClient, request, RunConfig.this.monitoringHandler));
                } else {
                    if (RunConfig.this.copyResourceHandler != null && RunConfig.this.copyResourceHandler.handle(request)) {
                        return;
                    }
                    if (request.path().startsWith("/playground/server/queuing/")) {
                        RunConfig.this.queueBrowser.handle(request);
                        return;
                    }
                    if (RunConfig.this.hookHandler != null && RunConfig.this.hookHandler.handle(request)) {
                        return;
                    }
                    if (RunConfig.this.eventBusHandler != null && RunConfig.this.eventBusHandler.handle(request)) {
                        return;
                    }
                    if (RunConfig.this.validationHandler != null && RunConfig.this.validationHandler.isToValidate(request)) {
                        RunConfig.this.validationHandler.handle(request);
                        return;
                    }
                    if (RunConfig.this.loggingResourceManager != null && RunConfig.this.loggingResourceManager.handleLoggingResource(request)) {
                        return;
                    }
                    if (RunConfig.this.configurationResourceManager != null && RunConfig.this.configurationResourceManager.handleConfigurationResource(request)) {
                        return;
                    }
                    if (RunConfig.this.validationResourceManager != null && RunConfig.this.validationResourceManager.handleValidationResource(request)) {
                        return;
                    }
                    if (RunConfig.this.schedulerResourceManager != null && RunConfig.this.schedulerResourceManager.handleSchedulerResource(request)) {
                        return;
                    }
                    if (RunConfig.this.queueCircuitBreakerConfigurationResourceManager != null && RunConfig.this.queueCircuitBreakerConfigurationResourceManager.handleConfigurationResource(request)) {
                        return;
                    }
                    if (RunConfig.this.propertyHandler != null && RunConfig.this.propertyHandler.handle(request)) {
                        return;
                    }
                    if (RunConfig.this.zipExtractHandler != null && RunConfig.this.zipExtractHandler.handle(request)) {
                        return;
                    }
                    if (RunConfig.this.delegateHandler != null && RunConfig.this.delegateHandler.handle(request)) {
                        return;
                    }
                    if (RunConfig.this.userProfileHandler != null && RunConfig.this.userProfileHandler.isUserProfileRequest(request)) {
                        RunConfig.this.userProfileHandler.handle(request);
                    } else if (RunConfig.this.roleProfileHandler != null && RunConfig.this.roleProfileHandler.isRoleProfileRequest(request)) {
                        RunConfig.this.roleProfileHandler.handle(request);
                    } else if (RunConfig.this.expansionHandler != null && RunConfig.this.expansionHandler.isZipRequest(request)) {
                        RunConfig.this.expansionHandler.handleZipRecursion(request);
                    } else if (RunConfig.this.expansionHandler != null && RunConfig.this.expansionHandler.isExpansionRequest(request)) {
                        RunConfig.this.expansionHandler.handleExpansionRecursion(request);
                    } else if (RunConfig.this.deltaHandler != null && RunConfig.this.deltaHandler.isDeltaRequest(request)) {
                        RunConfig.this.setISO8601Timestamps(request);
                        RunConfig.this.deltaHandler.handle(request, RunConfig.this.router);
                    } else {
                        if (RunConfig.this.mergeHandler != null && RunConfig.this.mergeHandler.handle(request)) {
                            return;
                        }
                        RunConfig.this.setISO8601Timestamps(request);
                        RunConfig.this.router.route(request);
                    }
                }
            }
        };
    }

    public static Map<String, Object> subMap(Map<String, Object> map, String prefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            Object value = entry.getValue();
            try {
                value = Integer.valueOf(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private void logRequest(HttpServerRequest request) {
        String behalf;
        String queue;
        String app;
        String device;
        this.monitoringHandler.updateIncomingRequests(request);
        StringBuilder sb = new StringBuilder();
        String uid = request.headers().get("x-rp-unique_id");
        if (uid != null) {
            sb.append(uid);
            sb.append(" ");
        } else {
            uid = request.headers().get("x-rp-unique-id");
            if (uid != null) {
                sb.append(uid);
                sb.append(" ");
            }
        }
        sb.append(request.method());
        sb.append(" ");
        sb.append(request.uri());
        sb.append(" ");
        String user = request.headers().get("x-rp-usr");
        if (user != null) {
            sb.append("u=");
            sb.append(user);
            sb.append(" ");
        }
        if ((device = request.headers().get("x-rp-deviceid")) != null) {
            sb.append("d=");
            sb.append(device);
            sb.append(" ");
        }
        if ((app = request.headers().get("x-appid")) != null) {
            sb.append("a=");
            sb.append(app);
            sb.append(" ");
        }
        if ((queue = request.headers().get("x-queue")) != null) {
            sb.append("q=");
            sb.append(queue);
            sb.append(" ");
        }
        if ((behalf = request.headers().get("x-on-behalf-of")) != null) {
            sb.append("b=");
            sb.append(behalf);
            sb.append(" ");
        }
        if (request.uri().endsWith("cleanup") || request.uri().contains("/jmx/")) {
            this.requestLog.debug(sb.toString());
        } else {
            this.requestLog.info(sb.toString());
        }
    }

    private void setISO8601Timestamps(HttpServerRequest request) {
        String nowAsISO = this.dfISO8601.print((ReadableInstant)Instant.now());
        if (!request.headers().contains(SERVER_ARRIVAL_TIMESTAMP_HEADER)) {
            request.headers().set(SERVER_ARRIVAL_TIMESTAMP_HEADER, nowAsISO);
        }
        request.headers().set(SERVER_TIMESTAMP_HEADER, nowAsISO);
        this.localizeTimestamp(request, "x-submit-timestamp");
        this.localizeTimestamp(request, "x-client-timestamp");
    }

    private void localizeTimestamp(HttpServerRequest request, String header) {
        String timestamp = request.headers().get(header);
        if (timestamp != null && timestamp.toUpperCase().endsWith("Z")) {
            try {
                DateTime dt = this.isoDateTimeParser.parseDateTime(timestamp);
                request.headers().set(header, this.dfISO8601.print((ReadableInstant)dt));
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Could not parse " + header + " : " + timestamp);
            }
        }
    }

    public static class RunConfigBuilder {
        private Vertx vertx;
        private RedisClient redisClient;
        private Class verticleClass;
        private Router router;
        private MonitoringHandler monitoringHandler;
        private QueueBrowser queueBrowser;
        private CORSHandler corsHandler;
        private SchedulerResourceManager schedulerResourceManager;
        private ValidationResourceManager validationResourceManager;
        private LoggingResourceManager loggingResourceManager;
        private ConfigurationResourceManager configurationResourceManager;
        private QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager;
        private EventBusHandler eventBusHandler;
        private ValidationHandler validationHandler;
        private HookHandler hookHandler;
        private UserProfileHandler userProfileHandler;
        private RoleProfileHandler roleProfileHandler;
        private ExpansionHandler expansionHandler;
        private DeltaHandler deltaHandler;
        private Authorizer authorizer;
        private CopyResourceHandler copyResourceHandler;
        private QoSHandler qosHandler;
        public PropertyHandler propertyHandler;
        private ZipExtractHandler zipExtractHandler;
        private DelegateHandler delegateHandler;
        private MergeHandler mergeHandler;

        public RunConfigBuilder corsHandler(CORSHandler corsHandler) {
            this.corsHandler = corsHandler;
            return this;
        }

        public RunConfigBuilder schedulerResourceManager(SchedulerResourceManager schedulerResourceManager) {
            this.schedulerResourceManager = schedulerResourceManager;
            return this;
        }

        public RunConfigBuilder validationResourceManager(ValidationResourceManager validationResourceManager) {
            this.validationResourceManager = validationResourceManager;
            return this;
        }

        public RunConfigBuilder loggingResourceManager(LoggingResourceManager loggingResourceManager) {
            this.loggingResourceManager = loggingResourceManager;
            return this;
        }

        public RunConfigBuilder configurationResourceManager(ConfigurationResourceManager configurationResourceManager) {
            this.configurationResourceManager = configurationResourceManager;
            return this;
        }

        public RunConfigBuilder queueCircuitBreakerConfigurationResourceManager(QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager) {
            this.queueCircuitBreakerConfigurationResourceManager = queueCircuitBreakerConfigurationResourceManager;
            return this;
        }

        public RunConfigBuilder eventBusHandler(EventBusHandler eventBusHandler) {
            this.eventBusHandler = eventBusHandler;
            return this;
        }

        public RunConfigBuilder validationHandler(ValidationHandler validationHandler) {
            this.validationHandler = validationHandler;
            return this;
        }

        public RunConfigBuilder hookHandler(HookHandler hookHandler) {
            this.hookHandler = hookHandler;
            return this;
        }

        public RunConfigBuilder userProfileHandler(UserProfileHandler userProfileHandler) {
            this.userProfileHandler = userProfileHandler;
            return this;
        }

        public RunConfigBuilder roleProfileHandler(RoleProfileHandler roleProfileHandler) {
            this.roleProfileHandler = roleProfileHandler;
            return this;
        }

        public RunConfigBuilder expansionHandler(ExpansionHandler expansionHandler) {
            this.expansionHandler = expansionHandler;
            return this;
        }

        public RunConfigBuilder deltaHandler(DeltaHandler deltaHandler) {
            this.deltaHandler = deltaHandler;
            return this;
        }

        public RunConfigBuilder authorizer(Authorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public RunConfigBuilder copyResourceHandler(CopyResourceHandler copyResourceHandler) {
            this.copyResourceHandler = copyResourceHandler;
            return this;
        }

        public RunConfigBuilder qosHandler(QoSHandler qosHandler) {
            this.qosHandler = qosHandler;
            return this;
        }

        public RunConfigBuilder propertyHandler(PropertyHandler propertyHandler) {
            this.propertyHandler = propertyHandler;
            return this;
        }

        public RunConfigBuilder zipExtractHandler(ZipExtractHandler zipExtractHandler) {
            this.zipExtractHandler = zipExtractHandler;
            return this;
        }

        public RunConfigBuilder delegateHandler(DelegateHandler delegateHandler) {
            this.delegateHandler = delegateHandler;
            return this;
        }

        public RunConfigBuilder mergeHandler(MergeHandler mergeHandler) {
            this.mergeHandler = mergeHandler;
            return this;
        }

        public RunConfig build(Vertx vertx, RedisClient redisClient, Class verticleClass, Router router, MonitoringHandler monitoringHandler, QueueBrowser queueBrowser) {
            this.vertx = vertx;
            this.redisClient = redisClient;
            this.verticleClass = verticleClass;
            this.router = router;
            this.monitoringHandler = monitoringHandler;
            this.queueBrowser = queueBrowser;
            return new RunConfig(this);
        }
    }
}

