/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.scheduler;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.redis.RedisClient;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.scheduler.Scheduler;
import org.swisspush.gateleen.scheduler.SchedulerFactory;
import org.swisspush.gateleen.validation.ValidationException;

public class SchedulerResourceManager
implements Refreshable,
LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.schedulers-updated";
    private String schedulersUri;
    private ResourceStorage storage;
    private Logger log = LoggerFactory.getLogger(SchedulerResourceManager.class);
    private Vertx vertx;
    private List<Scheduler> schedulers;
    private Map<String, Object> properties;
    private SchedulerFactory schedulerFactory;
    private String schedulersSchema;
    private boolean logConfigurationResourceChanges = false;

    public SchedulerResourceManager(Vertx vertx, RedisClient redisClient, ResourceStorage storage, MonitoringHandler monitoringHandler, String schedulersUri) {
        this(vertx, redisClient, storage, monitoringHandler, schedulersUri, null);
    }

    public SchedulerResourceManager(Vertx vertx, RedisClient redisClient, ResourceStorage storage, MonitoringHandler monitoringHandler, String schedulersUri, Map<String, Object> props) {
        this(vertx, redisClient, storage, monitoringHandler, schedulersUri, props, Address.redisquesAddress());
    }

    public SchedulerResourceManager(Vertx vertx, RedisClient redisClient, ResourceStorage storage, MonitoringHandler monitoringHandler, String schedulersUri, Map<String, Object> props, String redisquesAddress) {
        this.vertx = vertx;
        this.storage = storage;
        this.schedulersUri = schedulersUri;
        this.properties = props;
        this.schedulersSchema = ResourcesUtils.loadResource((String)"gateleen_scheduler_schema_schedulers", (boolean)true);
        this.schedulerFactory = new SchedulerFactory(this.properties, vertx, redisClient, monitoringHandler, this.schedulersSchema, redisquesAddress);
        this.updateSchedulers();
        vertx.eventBus().consumer(UPDATE_ADDRESS, event -> this.updateSchedulers());
    }

    private void updateSchedulers() {
        this.storage.get(this.schedulersUri, buffer -> {
            if (buffer != null) {
                this.updateSchedulers((Buffer)buffer);
            } else {
                this.log.info("No schedulers configured");
            }
        });
    }

    private void updateSchedulers(Buffer buffer) {
        this.stopSchedulers();
        try {
            this.schedulers = this.schedulerFactory.parseSchedulers(buffer);
        }
        catch (ValidationException validationException) {
            this.log.error("Could not parse schedulers: " + validationException.toString());
        }
        finally {
            this.vertx.setTimer(2000L, aLong -> this.startSchedulers());
        }
    }

    public boolean handleSchedulerResource(HttpServerRequest request) {
        if (request.uri().equals(this.schedulersUri) && HttpMethod.PUT == request.method()) {
            request.bodyHandler(buffer -> {
                try {
                    this.schedulerFactory.parseSchedulers((Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    this.log.warn("Could not parse schedulers: " + validationException.toString());
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                    if (validationException.getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(validationException.getValidationDetails().encode());
                    } else {
                        request.response().end(validationException.getMessage());
                    }
                    return;
                }
                this.storage.put(this.schedulersUri, buffer, status -> {
                    if (status == 200) {
                        if (this.logConfigurationResourceChanges) {
                            RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                        }
                        this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                    } else {
                        request.response().setStatusCode(status.intValue());
                    }
                    request.response().end();
                });
            });
            return true;
        }
        if (request.uri().equals(this.schedulersUri) && HttpMethod.DELETE == request.method()) {
            this.stopSchedulers();
        }
        return false;
    }

    private void startSchedulers() {
        if (this.schedulers != null) {
            this.schedulers.forEach(Scheduler::start);
        }
    }

    private void stopSchedulers() {
        if (this.schedulers != null) {
            this.schedulers.forEach(Scheduler::stop);
        }
    }

    protected List<Scheduler> getSchedulers() {
        return this.schedulers;
    }

    public void refresh() {
        this.updateSchedulers();
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logConfigurationResourceChanges = resourceLoggingEnabled;
    }
}

