/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.scheduler;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.redisques.util.RedisquesAPI;

public class Scheduler {
    private Vertx vertx;
    private RedisClient redisClient;
    private String name;
    private CronExpression cronExpression;
    private List<HttpRequest> requests;
    private long timer;
    private MonitoringHandler monitoringHandler;
    private Logger log;

    public Scheduler(Vertx vertx, RedisClient redisClient, String name, String cronExpression, List<HttpRequest> requests, MonitoringHandler monitoringHandler) throws ParseException {
        this.vertx = vertx;
        this.redisClient = redisClient;
        this.name = name;
        this.cronExpression = new CronExpression(cronExpression);
        this.requests = requests;
        this.log = LoggerFactory.getLogger((String)(Scheduler.class.getName() + ".scheduler-" + name));
        this.monitoringHandler = monitoringHandler;
    }

    public void start() {
        this.log.info("Starting scheduler [ " + this.cronExpression.getCronExpression() + " ]");
        this.timer = this.vertx.setPeriodic(5000L, timer -> this.redisClient.get("schedulers:" + this.name, reply -> {
            String stringValue = (String)reply.result();
            if (stringValue == null || Long.parseLong(stringValue) <= System.currentTimeMillis()) {
                long nextRunTime = this.nextRunTime();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Setting next run time to " + SimpleDateFormat.getDateTimeInstance().format(new Date(nextRunTime)));
                }
                this.redisClient.getset("schedulers:" + this.name, "" + nextRunTime, event -> {
                    String previousValue = (String)event.result();
                    if (stringValue != null && stringValue.equals(previousValue)) {
                        this.trigger();
                    }
                });
            }
        }));
    }

    public void stop() {
        this.log.info("Stopping scheduler [ " + this.cronExpression.getCronExpression() + " ] ");
        this.vertx.cancelTimer(this.timer);
        String key = "schedulers:" + this.name;
        this.redisClient.del(key, reply -> {
            if (reply.failed()) {
                this.log.error("Could not reset scheduler '" + key + "'");
            }
        });
    }

    private void trigger() {
        for (final HttpRequest request : this.requests) {
            this.monitoringHandler.updateEnqueue();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Triggering request " + request.toJsonObject().encodePrettily());
            }
            this.vertx.eventBus().send(Address.redisquesAddress(), (Object)RedisquesAPI.buildEnqueueOperation((String)("scheduler-" + this.name), (String)request.toJsonObject().encode()), (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                public void handle(AsyncResult<Message<JsonObject>> event) {
                    if (!"ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                        Scheduler.this.log.error("Could not enqueue request " + request.toJsonObject().encodePrettily());
                    }
                }
            });
        }
    }

    private long nextRunTime() {
        return this.cronExpression.getNextValidTimeAfter(new Date()).getTime();
    }
}

