/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.scheduler;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.scheduler.Scheduler;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class SchedulerFactory {
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String REQUESTS = "requests";
    private static final String SCHEDULERS = "schedulers";
    private static final String RANDOM_OFFSET = "randomOffset";
    private static final String EXECUTE_ON_STARTUP = "executeOnStartup";
    private static final String EXECUTE_ON_RELOAD = "executeOnReload";
    private final Map<String, Object> properties;
    private final JsonArray defaultRequestHeaders;
    private Vertx vertx;
    private RedisClient redisClient;
    private MonitoringHandler monitoringHandler;
    private String schedulersSchema;
    private String redisquesAddress;
    private Logger log = LoggerFactory.getLogger(SchedulerFactory.class);

    public SchedulerFactory(Map<String, Object> properties, Map<String, String> defaultRequestHeaders, Vertx vertx, RedisClient redisClient, MonitoringHandler monitoringHandler, String schedulersSchema, String redisquesAddress) {
        this.properties = properties;
        this.defaultRequestHeaders = this.defaultRequestHeadersAsJsonArray(defaultRequestHeaders);
        this.vertx = vertx;
        this.redisClient = redisClient;
        this.monitoringHandler = monitoringHandler;
        this.schedulersSchema = schedulersSchema;
        this.redisquesAddress = redisquesAddress;
    }

    private JsonArray defaultRequestHeadersAsJsonArray(Map<String, String> defaultRequestHeaders) {
        JsonArray headers = new JsonArray();
        if (defaultRequestHeaders == null) {
            return headers;
        }
        for (Map.Entry<String, String> entry : defaultRequestHeaders.entrySet()) {
            headers.add(new JsonArray().add(entry.getKey()).add(entry.getValue()));
        }
        return headers;
    }

    public List<Scheduler> parseSchedulers(Buffer buffer) throws ValidationException {
        String configString;
        ArrayList<Scheduler> result = new ArrayList<Scheduler>();
        try {
            configString = StringUtils.replaceWildcardConfigs((String)buffer.toString("UTF-8"), this.properties);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
        ValidationResult validationResult = Validator.validateStatic((Buffer)Buffer.buffer((String)configString), (String)this.schedulersSchema, (Logger)this.log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        JsonObject mainObject = new JsonObject(configString);
        for (Map.Entry entry : mainObject.getJsonObject(SCHEDULERS).getMap().entrySet()) {
            Map schedulerJson = (Map)entry.getValue();
            boolean executeOnStartup = false;
            boolean executeOnReload = false;
            if (schedulerJson.containsKey(EXECUTE_ON_STARTUP)) {
                executeOnReload = executeOnStartup = ((Boolean)schedulerJson.get(EXECUTE_ON_STARTUP)).booleanValue();
            }
            if (schedulerJson.containsKey(EXECUTE_ON_RELOAD)) {
                executeOnReload = (Boolean)schedulerJson.get(EXECUTE_ON_RELOAD);
            }
            int maxRandomOffset = 0;
            if (schedulerJson.containsKey(RANDOM_OFFSET)) {
                try {
                    maxRandomOffset = (Integer)schedulerJson.get(RANDOM_OFFSET);
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Could not parse randomOffset of scheduler '" + (String)entry.getKey() + "'", (Throwable)e);
                }
            }
            ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
            for (int i = 0; i < ((ArrayList)schedulerJson.get(REQUESTS)).size(); ++i) {
                try {
                    requests.add(new HttpRequest(this.prepare((JsonObject)mainObject.getJsonObject(SCHEDULERS).getJsonObject((String)entry.getKey()).getJsonArray(REQUESTS).getValue(i))));
                    continue;
                }
                catch (Exception e) {
                    throw new ValidationException("Could not parse request [" + i + "] of scheduler " + (String)entry.getKey(), (Throwable)e);
                }
            }
            try {
                result.add(new Scheduler(this.vertx, this.redisquesAddress, this.redisClient, (String)entry.getKey(), (String)schedulerJson.get("cronExpression"), requests, this.monitoringHandler, maxRandomOffset, executeOnStartup, executeOnReload));
            }
            catch (ParseException e) {
                throw new ValidationException("Could not parse cron expression of scheduler '" + (String)entry.getKey() + "'", (Throwable)e);
            }
        }
        return result;
    }

    private JsonObject prepare(JsonObject httpRequestJsonObject) {
        String payloadStr;
        try {
            payloadStr = httpRequestJsonObject.getString(PAYLOAD);
        }
        catch (ClassCastException e) {
            payloadStr = httpRequestJsonObject.getJsonObject(PAYLOAD).encode();
        }
        JsonArray headers = httpRequestJsonObject.getJsonArray(HEADERS);
        if (headers != null) {
            httpRequestJsonObject.put(HEADERS, headers.addAll(this.defaultRequestHeaders.copy()));
        } else {
            httpRequestJsonObject.put(HEADERS, this.defaultRequestHeaders.copy());
        }
        if (payloadStr != null) {
            byte[] payload = payloadStr.getBytes(Charset.forName("UTF-8"));
            httpRequestJsonObject.getJsonArray(HEADERS).add(new JsonArray(Arrays.asList("content-length", "" + payload.length)));
            httpRequestJsonObject.put(PAYLOAD, payload);
        }
        return httpRequestJsonObject;
    }
}

