/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.scheduler;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.expiry.ExpiryCheckHandler;
import org.swisspush.redisques.util.RedisquesAPI;

public class Scheduler {
    private Vertx vertx;
    private RedisAPI redisAPI;
    private String redisquesAddress;
    private String name;
    private CronExpression cronExpression;
    private List<HttpRequest> requests;
    private long timer;
    private MonitoringHandler monitoringHandler;
    private long randomOffset = 0L;
    private boolean executeOnStartup = false;
    private boolean executeOnReload = false;
    private boolean executed = false;
    private Logger log;

    public Scheduler(Vertx vertx, String redisquesAddress, RedisAPI redisAPI, String name, String cronExpression, List<HttpRequest> requests, MonitoringHandler monitoringHandler, int maxRandomOffset, boolean executeOnStartup, boolean executeOnReload) throws ParseException {
        this.vertx = vertx;
        this.redisquesAddress = redisquesAddress;
        this.redisAPI = redisAPI;
        this.name = name;
        this.cronExpression = new CronExpression(cronExpression);
        this.requests = requests;
        this.log = LoggerFactory.getLogger((String)(Scheduler.class.getName() + ".scheduler-" + name));
        this.monitoringHandler = monitoringHandler;
        this.calcRandomOffset(maxRandomOffset);
        this.executeOnStartup = executeOnStartup;
        this.executeOnReload = executeOnReload;
    }

    private void calcRandomOffset(int maxRandomOffset) {
        if (maxRandomOffset != 0) {
            this.randomOffset = (long)new Random().nextInt(maxRandomOffset + 1) * 1000L;
        }
    }

    public void start() {
        this.log.info("Starting scheduler [ " + this.cronExpression.getCronExpression() + " ]");
        this.timer = this.vertx.setPeriodic(5000L, timer -> this.redisAPI.get("schedulers:" + this.name, reply -> {
            String stringValue;
            String string = stringValue = reply.result() == null ? null : ((Response)reply.result()).toString();
            if (stringValue == null || Long.parseLong(stringValue) <= System.currentTimeMillis() - this.randomOffset) {
                long nextRunTime = this.nextRunTime();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Setting next run time to " + SimpleDateFormat.getDateTimeInstance().format(new Date(nextRunTime)));
                }
                this.redisAPI.getset("schedulers:" + this.name, "" + nextRunTime, event -> {
                    String previousValue;
                    String string = previousValue = event.result() == null ? null : ((Response)event.result()).toString();
                    if (stringValue != null && stringValue.equals(previousValue)) {
                        this.trigger();
                    }
                });
            }
        }));
        if (!this.executed && this.executeOnStartup || this.executeOnReload) {
            this.executed = true;
            this.trigger();
        }
    }

    public void stop() {
        this.log.info("Stopping scheduler [ " + this.cronExpression.getCronExpression() + " ] ");
        this.vertx.cancelTimer(this.timer);
        String key = "schedulers:" + this.name;
        this.redisAPI.del(Collections.singletonList(key), reply -> {
            if (reply.failed()) {
                this.log.error("Could not reset scheduler '" + key + "'");
            }
        });
    }

    private void trigger() {
        for (HttpRequest request : this.requests) {
            this.monitoringHandler.updateEnqueue();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Triggering request " + request.toJsonObject().encodePrettily());
            }
            if (request.getHeaders() != null) {
                request.getHeaders().remove("X-Server-Timestamp");
            }
            ExpiryCheckHandler.updateServerTimestampHeader((HttpRequest)request);
            this.vertx.eventBus().request(this.redisquesAddress, (Object)RedisquesAPI.buildEnqueueOperation((String)("scheduler-" + this.name), (String)request.toJsonObject().put("queueTimestamp", (Object)System.currentTimeMillis()).encode()), event -> {
                if (!"ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                    this.log.error("Could not enqueue request " + request.toJsonObject().encodePrettily());
                }
            });
        }
    }

    private long nextRunTime() {
        return this.cronExpression.getNextValidTimeAfter(new Date(System.currentTimeMillis() - this.randomOffset)).getTime();
    }

    protected String getName() {
        return this.name;
    }

    protected long getRandomOffset() {
        return this.randomOffset;
    }

    protected List<HttpRequest> requests() {
        return this.requests;
    }
}

