/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.RoleExtractor;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.security.authorization.AclFactory;
import org.swisspush.gateleen.security.authorization.PatternHolder;
import org.swisspush.gateleen.validation.ValidationException;

public class Authorizer
implements LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.authorization-updated";
    private Pattern userUriPattern;
    private String aclKey = "acls";
    private String aclRoot;
    private String adminRole = "admin";
    private String anonymousRole = "everyone";
    private String deviceHeader = "x-rp-deviceid";
    private String userHeader = "x-rp-usr";
    private String aclSchema;
    private AclFactory aclFactory;
    private PatternHolder aclUriPattern;
    private Vertx vertx;
    private EventBus eb;
    private boolean logACLChanges = false;
    private ResourceStorage storage;
    private RoleExtractor roleExtractor;
    private Map<PatternHolder, Map<String, Set<String>>> initialGrantedRoles;
    private Map<PatternHolder, Map<String, Set<String>>> grantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
    public static final Logger log = LoggerFactory.getLogger(Authorizer.class);
    private long updateTimerId = -1L;

    public Authorizer(Vertx vertx, ResourceStorage storage, String securityRoot, String rolePattern) {
        this.vertx = vertx;
        this.storage = storage;
        this.aclRoot = securityRoot + this.aclKey + "/";
        this.aclUriPattern = new PatternHolder(Pattern.compile("^" + this.aclRoot + "(?<role>.+)$"));
        this.userUriPattern = Pattern.compile(securityRoot + "user(\\?.*)?");
        this.roleExtractor = new RoleExtractor(rolePattern);
        this.aclSchema = ResourcesUtils.loadResource((String)"gateleen_security_schema_acl", (boolean)true);
        this.aclFactory = new AclFactory(this.aclSchema);
        this.eb = vertx.eventBus();
        this.initialGrantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
        this.initialGrantedRoles.put(this.aclUriPattern, new HashMap());
        this.initialGrantedRoles.get(this.aclUriPattern).put("PUT", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).put("GET", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).put("DELETE", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).get("PUT").add(this.adminRole);
        this.initialGrantedRoles.get(this.aclUriPattern).get("GET").add(this.adminRole);
        this.initialGrantedRoles.get(this.aclUriPattern).get("DELETE").add(this.adminRole);
        this.updateAllAcls();
        this.eb.consumer(UPDATE_ADDRESS, role -> this.updateAllAcls());
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logACLChanges = resourceLoggingEnabled;
    }

    public Future<Boolean> authorize(HttpServerRequest request) {
        Future future = Future.future();
        this.handleUserUriRequest(request, (Future<Boolean>)future);
        if (!future.isComplete()) {
            this.handleIsAuthorized(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            this.handleAclUriRequest(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            future.complete((Object)Boolean.TRUE);
        }
        return future;
    }

    public void authorize(HttpServerRequest request, Handler<Void> handler) {
        Future future = Future.future();
        this.handleUserUriRequest(request, (Future<Boolean>)future);
        if (!future.isComplete()) {
            this.handleIsAuthorized(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            this.handleAclUriRequest(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            handler.handle(null);
        }
    }

    private void handleUserUriRequest(HttpServerRequest request, Future<Boolean> future) {
        if (this.userUriPattern.matcher(request.uri()).matches()) {
            if (HttpMethod.GET == request.method()) {
                String userId = request.headers().get("x-rp-usr");
                JsonObject user = new JsonObject();
                request.response().headers().set("Content-Type", "application/json");
                String userName = request.headers().get("cas_name");
                if (userName != null) {
                    userId = userName;
                }
                user.put("userId", userId);
                Set roles = this.roleExtractor.extractRoles(request);
                if (roles != null) {
                    roles.add(this.anonymousRole);
                    user.put("roles", new JsonArray(new ArrayList(roles)));
                }
                request.response().end(user.toString());
            } else {
                request.response().setStatusCode(StatusCode.METHOD_NOT_ALLOWED.getStatusCode());
                request.response().setStatusMessage(StatusCode.METHOD_NOT_ALLOWED.getStatusMessage());
                request.response().end();
            }
            future.complete((Object)Boolean.FALSE);
        }
    }

    private void handleIsAuthorized(HttpServerRequest request, Future<Boolean> future) {
        if (!this.isAuthorized(request)) {
            RequestLoggerFactory.getLogger(Authorizer.class, (HttpServerRequest)request).info(StatusCode.FORBIDDEN.toString());
            request.response().setStatusCode(StatusCode.FORBIDDEN.getStatusCode());
            request.response().setStatusMessage(StatusCode.FORBIDDEN.getStatusMessage());
            request.response().end(StatusCode.FORBIDDEN.getStatusMessage());
            future.complete((Object)Boolean.FALSE);
        }
    }

    private void handleAclUriRequest(HttpServerRequest request, Future<Boolean> future) {
        Matcher matcher = this.aclUriPattern.getPattern().matcher(request.uri());
        if (matcher.matches()) {
            if (HttpMethod.PUT == request.method()) {
                request.bodyHandler(buffer -> {
                    try {
                        this.aclFactory.parseAcl((Buffer)buffer);
                    }
                    catch (ValidationException validationException) {
                        log.warn("Could not parse acl: " + validationException.toString());
                        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                        if (validationException.getValidationDetails() != null) {
                            request.response().headers().add("content-type", "application/json");
                            request.response().end(validationException.getValidationDetails().encode());
                        } else {
                            request.response().end(validationException.getMessage());
                        }
                        return;
                    }
                    this.storage.put(request.uri(), buffer, status -> {
                        if (status.intValue() == StatusCode.OK.getStatusCode()) {
                            if (this.logACLChanges) {
                                RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                            }
                            this.scheduleUpdate();
                        } else {
                            request.response().setStatusCode(status.intValue());
                        }
                        request.response().end();
                    });
                });
                future.complete((Object)Boolean.FALSE);
            } else if (HttpMethod.DELETE == request.method()) {
                this.storage.delete(request.uri(), status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        this.eb.publish(UPDATE_ADDRESS, (Object)"*");
                    } else {
                        log.warn("Could not delete '" + (request.uri() == null ? "<null>" : request.uri()) + "'. Error code is '" + (status == null ? "<null>" : status) + "'.");
                        request.response().setStatusCode(status.intValue());
                    }
                    request.response().end();
                });
                future.complete((Object)Boolean.FALSE);
            }
        }
    }

    private void scheduleUpdate() {
        this.vertx.cancelTimer(this.updateTimerId);
        this.updateTimerId = this.vertx.setTimer(3000L, id -> this.eb.publish(UPDATE_ADDRESS, (Object)"*"));
    }

    private void updateAllAcls() {
        this.storage.get(this.aclRoot, buffer -> {
            if (buffer != null) {
                this.grantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
                for (Object roleObject : new JsonObject(buffer.toString("UTF-8")).getJsonArray(this.aclKey)) {
                    String role = (String)roleObject;
                    this.updateAcl(role);
                }
            } else {
                log.warn("No ACLs in storage, using initial authorization.");
                this.grantedRoles = this.initialGrantedRoles;
            }
        });
    }

    private boolean isAuthorized(HttpServerRequest request) {
        Set roles = this.roleExtractor.extractRoles(request);
        if (roles != null) {
            roles.add(this.anonymousRole);
            RequestLoggerFactory.getLogger(Authorizer.class, (HttpServerRequest)request).debug("Roles: " + roles);
            return this.isAuthorized(roles, request);
        }
        return true;
    }

    private boolean isAuthorized(Set<String> roles, HttpServerRequest request) {
        for (Map.Entry<PatternHolder, Map<String, Set<String>>> entry : this.grantedRoles.entrySet()) {
            Set<String> methodRoles;
            Matcher matcher = entry.getKey().getPattern().matcher(request.uri());
            if (!matcher.matches() || (methodRoles = entry.getValue().get(request.method().name())) == null) continue;
            for (String role : methodRoles) {
                if (!this.checkRole(roles, request, matcher, role)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRole(Set<String> roles, HttpServerRequest request, Matcher matcher, String role) {
        if (roles.contains(role)) {
            boolean authorized = true;
            if (matcher.groupCount() > 0) {
                try {
                    String uriUser = matcher.group("user");
                    authorized &= uriUser != null && uriUser.equals(request.headers().get(this.userHeader));
                }
                catch (IllegalArgumentException uriUser) {
                    // empty catch block
                }
                try {
                    String uriDevice = matcher.group("device");
                    authorized &= uriDevice != null && uriDevice.equals(request.headers().get(this.deviceHeader));
                }
                catch (IllegalArgumentException uriDevice) {
                    // empty catch block
                }
                try {
                    String uriRole = matcher.group("role");
                    authorized &= uriRole != null && roles.contains(uriRole);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (authorized) {
                return true;
            }
        }
        return false;
    }

    private void updateAcl(String role) {
        this.storage.get(this.aclRoot + role, buffer -> {
            if (buffer != null) {
                try {
                    log.info("Applying acl for " + role);
                    this.mergeAcl(role, (Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    log.error("Could not parse acls: " + validationException.toString());
                }
            } else {
                log.error("No acl for role " + role + " found in storage");
            }
        });
    }

    private void mergeAcl(String role, Buffer buffer) throws ValidationException {
        Map<PatternHolder, Set<String>> permissions = this.aclFactory.parseAcl(buffer);
        for (Map.Entry<PatternHolder, Set<String>> entry : permissions.entrySet()) {
            PatternHolder holder = entry.getKey();
            Map<String, Set<String>> aclItem = this.grantedRoles.get(holder);
            if (aclItem == null) {
                aclItem = new HashMap<String, Set<String>>();
                this.grantedRoles.put(holder, aclItem);
            }
            for (String method : entry.getValue()) {
                Set<String> aclMethod = aclItem.get(method);
                if (aclMethod == null) {
                    aclMethod = new HashSet<String>();
                    aclItem.put(method, aclMethod);
                }
                aclMethod.add(role);
            }
        }
    }
}

