/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.buffer.Buffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.UriBuilder;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.security.authorization.ConfigurationResource;
import org.swisspush.gateleen.security.authorization.RoleMapperFactory;
import org.swisspush.gateleen.security.authorization.RoleMapperHolder;
import org.swisspush.gateleen.validation.ValidationException;

public class RoleMapper
implements ConfigurationResource {
    private ResourceStorage storage;
    private String roleMapper;
    private RoleMapperFactory roleMapperFactory;
    private List<RoleMapperHolder> roleMappers = null;
    public static final Logger log = LoggerFactory.getLogger(RoleMapper.class);
    public static final String ROLEMAPPER = "rolemapper";

    public RoleMapper(ResourceStorage storage, String securityRoot) {
        this.storage = storage;
        this.roleMapper = UriBuilder.concatUriSegments((String[])new String[]{securityRoot, ROLEMAPPER});
        this.roleMapperFactory = new RoleMapperFactory();
        this.configUpdate();
    }

    @Override
    public void checkConfigResource(Buffer buffer) throws ValidationException {
        this.roleMapperFactory.parseRoleMapper(buffer);
    }

    @Override
    public void configUpdate() {
        this.storage.get(this.roleMapper, buffer -> {
            if (buffer != null) {
                try {
                    this.roleMappers = this.roleMapperFactory.parseRoleMapper((Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    log.error("Could not parse acl for role mapper: " + validationException.toString());
                }
            } else {
                log.info("No RoleMappers found in storage");
                this.roleMappers = null;
            }
        });
    }

    public Set<String> mapRoles(Set<String> roles) {
        if (roles != null && this.roleMappers != null && !this.roleMappers.isEmpty()) {
            HashSet<String> mappedRoles = new HashSet<String>();
            for (String role : roles) {
                boolean keepOriginalRule = true;
                for (RoleMapperHolder mapper : this.roleMappers) {
                    if (!mapper.getPattern().matcher(role).matches()) continue;
                    mappedRoles.add(mapper.getRole());
                    keepOriginalRule = mapper.getKeepOriginal();
                    break;
                }
                if (!keepOriginalRule) continue;
                mappedRoles.add(role);
            }
            return mappedRoles;
        }
        return roles;
    }
}

