/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.security.authorization.RoleMapperHolder;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class RoleMapperFactory {
    private final String mapperSchema = ResourcesUtils.loadResource((String)"gateleen_security_schema_rolemapper", (boolean)true);
    private static Logger LOGGER = LoggerFactory.getLogger(RoleMapperFactory.class);
    private final Map<String, Object> properties;

    RoleMapperFactory(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<RoleMapperHolder> parseRoleMapper(Buffer buffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic((Buffer)buffer, (String)this.mapperSchema, (Logger)LOGGER);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        ArrayList<RoleMapperHolder> result = new ArrayList<RoleMapperHolder>();
        Mappings mappings = (Mappings)Json.decodeValue((Buffer)buffer, Mappings.class);
        for (Mapping mapping : mappings.mappings) {
            if (this.properties != null) {
                mapping.pattern = StringUtils.replaceWildcardConfigs((String)mapping.pattern, this.properties);
                mapping.role = StringUtils.replaceWildcardConfigs((String)mapping.role, this.properties);
            }
            result.add(new RoleMapperHolder(Pattern.compile(mapping.pattern), mapping.role, mapping.keepOriginal, mapping.continueMapping));
        }
        return result;
    }

    public static class Mapping {
        public String pattern;
        public String role;
        public boolean keepOriginal;
        public boolean continueMapping;
    }

    public static class Mappings {
        public Mapping[] mappings;
    }
}

