/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.content;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceConsumer;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.security.content.ContentTypeConstraint;
import org.swisspush.gateleen.security.content.ContentTypeConstraintFactory;
import org.swisspush.gateleen.security.content.ContentTypeConstraintRepository;

public class ContentTypeConstraintHandler
extends ConfigurationResourceConsumer {
    private final Logger log = LoggerFactory.getLogger(ContentTypeConstraintHandler.class);
    private final ContentTypeConstraintRepository repository;
    private boolean initialized = false;
    private final List<PatternHolder> alwaysAllowedContentTypes;
    private static final String CONTENT_TYPE_HEADER = "Content-Type";

    public ContentTypeConstraintHandler(ConfigurationResourceManager configurationResourceManager, ContentTypeConstraintRepository repository, String configResourceUri, List<PatternHolder> alwaysAllowedContentTypes) {
        super(configurationResourceManager, configResourceUri, "gateleen_security_contenttype_constraint_schema");
        this.repository = repository;
        this.alwaysAllowedContentTypes = alwaysAllowedContentTypes;
    }

    public ContentTypeConstraintHandler(ConfigurationResourceManager configurationResourceManager, ContentTypeConstraintRepository repository, String configResourceUri) {
        this(configurationResourceManager, repository, configResourceUri, new ArrayList<PatternHolder>());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Future<Void> initialize() {
        Future future = Future.future();
        this.configurationResourceManager().getRegisteredResource(this.configResourceUri()).setHandler(event -> {
            if (event.succeeded() && ((Optional)event.result()).isPresent()) {
                this.initializeConstraintConfiguration((Buffer)((Optional)event.result()).get());
                future.complete();
            } else {
                this.log.warn("No (valid) Content-Type constraint configuration resource with uri '{}' found. Unable to setup Content-Type constraint handler correctly", (Object)this.configResourceUri());
                future.complete();
            }
        });
        return future;
    }

    public boolean handle(HttpServerRequest request) {
        String contentTypeValue = request.headers().get(CONTENT_TYPE_HEADER);
        if (contentTypeValue == null) {
            return false;
        }
        contentTypeValue = StringUtils.substringBefore((String)contentTypeValue, (String)";");
        for (PatternHolder allowedContentType : this.alwaysAllowedContentTypes) {
            if (!allowedContentType.getPattern().matcher(contentTypeValue).matches()) continue;
            return false;
        }
        String finalContentTypeValue = contentTypeValue;
        return this.repository.findMatchingContentTypeConstraint(request.uri()).map(contentTypeConstraint -> {
            for (PatternHolder allowedTypePatternHolder : contentTypeConstraint.allowedTypes()) {
                if (!allowedTypePatternHolder.getPattern().matcher(finalContentTypeValue).matches()) continue;
                return false;
            }
            this.respondUnsupportedMediaType(request, finalContentTypeValue);
            return true;
        }).orElseGet(() -> {
            this.respondUnsupportedMediaType(request, finalContentTypeValue);
            return true;
        });
    }

    public void resourceChanged(String resourceUri, Buffer resource) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Content-Type constraint configuration resource " + resourceUri + " was updated. Going to initialize with new configuration");
            this.initializeConstraintConfiguration(resource);
        }
    }

    public void resourceRemoved(String resourceUri) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Content-Type constraint configuration resource " + resourceUri + " was removed.");
            this.repository.clearConstraints();
            this.initialized = false;
        }
    }

    private void initializeConstraintConfiguration(Buffer configuration) {
        List<ContentTypeConstraint> constraints = ContentTypeConstraintFactory.create(configuration);
        this.repository.setConstraints(constraints);
        this.initialized = true;
    }

    private void respondUnsupportedMediaType(HttpServerRequest request, String contentTypeValue) {
        RequestLoggerFactory.getLogger(ContentTypeConstraintHandler.class, (HttpServerRequest)request).info("Unsupported media type '{}' for request uri '{}' found", (Object)contentTypeValue, (Object)request.uri());
        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.UNSUPPORTED_MEDIA_TYPE, ContentTypeConstraintHandler.class);
        request.response().setStatusCode(StatusCode.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        request.response().setStatusMessage(StatusCode.UNSUPPORTED_MEDIA_TYPE.getStatusMessage());
        request.response().end();
    }
}

