/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.RoleExtractor;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.security.authorization.AclFactory;
import org.swisspush.gateleen.security.authorization.ConfigurationResource;
import org.swisspush.gateleen.security.authorization.RoleMapper;
import org.swisspush.gateleen.validation.ValidationException;

public class RoleAuthorizer
implements ConfigurationResource {
    private String aclRoot;
    private String aclKey = "acls";
    private String adminRole = "admin";
    private String anonymousRole = "everyone";
    private String deviceHeader = "x-rp-deviceid";
    private String userHeader = "x-rp-usr";
    private final String rolePrefix;
    private AclFactory aclFactory;
    private RoleMapper roleMapper;
    private PatternHolder aclUriPattern;
    private ResourceStorage storage;
    private RoleExtractor roleExtractor;
    private Map<PatternHolder, Map<String, Set<String>>> initialGrantedRoles;
    private final boolean grantAccessWithoutRoles;
    private Map<PatternHolder, Map<String, Set<String>>> grantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
    public static final Logger log = LoggerFactory.getLogger(RoleAuthorizer.class);

    RoleAuthorizer(ResourceStorage storage, String securityRoot, String rolePattern, String rolePrefix, RoleMapper roleMapper, boolean grantAccessWithoutRoles) {
        this.storage = storage;
        this.roleMapper = roleMapper;
        this.grantAccessWithoutRoles = grantAccessWithoutRoles;
        this.aclRoot = securityRoot + this.aclKey + "/";
        this.aclUriPattern = new PatternHolder("^" + this.aclRoot + "(?<role>.+)$");
        this.roleExtractor = new RoleExtractor(rolePattern);
        this.aclFactory = new AclFactory();
        this.rolePrefix = rolePrefix != null ? rolePrefix : "";
        this.initialGrantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
        this.initialGrantedRoles.put(this.aclUriPattern, new HashMap());
        this.initialGrantedRoles.get(this.aclUriPattern).put("PUT", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).put("GET", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).put("DELETE", new HashSet());
        this.initialGrantedRoles.get(this.aclUriPattern).get("PUT").add(this.adminRole);
        this.initialGrantedRoles.get(this.aclUriPattern).get("GET").add(this.adminRole);
        this.initialGrantedRoles.get(this.aclUriPattern).get("DELETE").add(this.adminRole);
        this.configUpdate();
    }

    public void handleIsAuthorized(HttpServerRequest request, Future<Boolean> future) {
        if (!this.isAuthorized(request)) {
            ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.FORBIDDEN, RoleAuthorizer.class);
            request.response().setStatusCode(StatusCode.FORBIDDEN.getStatusCode());
            request.response().setStatusMessage(StatusCode.FORBIDDEN.getStatusMessage());
            request.response().end(StatusCode.FORBIDDEN.getStatusMessage());
            future.complete((Object)Boolean.FALSE);
        }
    }

    @Override
    public void checkConfigResource(Buffer buffer) throws ValidationException {
        this.aclFactory.parseAcl(buffer);
    }

    @Override
    public void configUpdate() {
        this.storage.get(this.aclRoot, buffer -> {
            if (buffer != null) {
                this.grantedRoles = new HashMap<PatternHolder, Map<String, Set<String>>>();
                for (Object roleObject : new JsonObject(buffer).getJsonArray(this.aclKey)) {
                    String role = (String)roleObject;
                    this.updateAcl(role);
                }
            } else {
                log.warn("No ACLs in storage, using initial authorization.");
                this.grantedRoles = this.initialGrantedRoles;
            }
        });
    }

    private boolean isAuthorized(HttpServerRequest request) {
        Set roles = this.roleExtractor.extractRoles(request);
        if (roles != null) {
            roles.add(this.anonymousRole);
            RequestLoggerFactory.getLogger(RoleAuthorizer.class, (HttpServerRequest)request).debug("Roles: " + roles);
            return this.isAuthorized(roles, request);
        }
        return this.grantAccessWithoutRoles;
    }

    private boolean isAuthorized(Set<String> roles, HttpServerRequest request) {
        Map<String, RoleMapper.MappedRole> mappedRoles = this.roleMapper.mapRoles(roles);
        for (Map.Entry<PatternHolder, Map<String, Set<String>>> entry : this.grantedRoles.entrySet()) {
            Set<String> methodRoles;
            Matcher matcher = entry.getKey().getPattern(request.headers()).matcher(request.uri());
            if (!matcher.matches() || (methodRoles = entry.getValue().get(request.method().name())) == null) continue;
            for (String role : methodRoles) {
                if (!this.checkRole(mappedRoles, request, matcher, role)) continue;
                this.fillInNewRoleHeader(request, mappedRoles);
                return true;
            }
        }
        return false;
    }

    private void fillInNewRoleHeader(HttpServerRequest request, Map<String, RoleMapper.MappedRole> mappedRoles) {
        StringJoiner joiner = new StringJoiner(",");
        for (RoleMapper.MappedRole mappedRole : mappedRoles.values()) {
            if (!mappedRole.forward) continue;
            joiner.add(this.rolePrefix + mappedRole.role.toLowerCase());
        }
        request.headers().set("x-rp-grp", joiner.toString());
    }

    private boolean checkRole(Map<String, RoleMapper.MappedRole> roles, HttpServerRequest request, Matcher matcher, String role) {
        boolean authorized = false;
        if (roles.containsKey(role)) {
            authorized = true;
            if (matcher.groupCount() > 0) {
                try {
                    String uriUser = matcher.group("user");
                    authorized &= uriUser != null && uriUser.equals(request.headers().get(this.userHeader));
                }
                catch (IllegalArgumentException uriUser) {
                    // empty catch block
                }
                try {
                    String uriDevice = matcher.group("device");
                    authorized &= uriDevice != null && uriDevice.equals(request.headers().get(this.deviceHeader));
                }
                catch (IllegalArgumentException uriDevice) {
                    // empty catch block
                }
                try {
                    String uriRole = matcher.group("role");
                    authorized &= uriRole != null && roles.containsKey(uriRole);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return authorized;
    }

    private void updateAcl(String role) {
        this.storage.get(this.aclRoot + role, buffer -> {
            if (buffer != null) {
                try {
                    log.info("Applying acl for " + role);
                    this.mergeAcl(role, (Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    log.error("Could not parse acls: " + validationException.toString());
                }
            } else {
                log.error("No acl for role " + role + " found in storage");
            }
        });
    }

    private void mergeAcl(String role, Buffer buffer) throws ValidationException {
        Map<PatternHolder, Set<String>> permissions = this.aclFactory.parseAcl(buffer);
        for (Map.Entry<PatternHolder, Set<String>> entry : permissions.entrySet()) {
            PatternHolder holder = entry.getKey();
            Map<String, Set<String>> aclItem = this.grantedRoles.get(holder);
            if (aclItem == null) {
                aclItem = new HashMap<String, Set<String>>();
                this.grantedRoles.put(holder, aclItem);
            }
            for (String method : entry.getValue()) {
                Set<String> aclMethod = aclItem.get(method);
                if (aclMethod == null) {
                    aclMethod = new HashSet<String>();
                    aclItem.put(method, aclMethod);
                }
                aclMethod.add(role);
            }
        }
    }
}

