/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class AclFactory {
    private String aclSchema;
    private Logger log = LoggerFactory.getLogger(AclFactory.class);

    public AclFactory() {
        this.aclSchema = ResourcesUtils.loadResource((String)"gateleen_security_schema_acl", (boolean)true);
    }

    public Map<PatternHolder, Set<String>> parseAcl(Buffer buffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic((Buffer)buffer, (String)this.aclSchema, (Logger)this.log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        HashMap<PatternHolder, Set<String>> result = new HashMap<PatternHolder, Set<String>>();
        JsonObject aclItems = new JsonObject(buffer.toString("UTF-8"));
        for (String id : aclItems.fieldNames()) {
            Object aclItemToTest = aclItems.getValue(id);
            if (!(aclItemToTest instanceof JsonObject)) {
                throw new ValidationException("acl item must be a map: " + id);
            }
            JsonObject aclItem = aclItems.getJsonObject(id);
            aclItems.getValue("debug.read");
            String path = aclItem.getString("path");
            JsonArray methods = aclItem.getJsonArray("methods");
            this.checkPropertiesValid(path, methods, id);
            if (path == null) continue;
            PatternHolder holder = new PatternHolder(path);
            HashSet<String> methodSet = (HashSet<String>)result.get(holder);
            if (methodSet == null) {
                methodSet = new HashSet<String>();
                result.put(holder, methodSet);
            }
            if (methods == null) continue;
            for (Object methodObj : methods) {
                String method = (String)methodObj;
                methodSet.add(method);
            }
        }
        return result;
    }

    private void checkPropertiesValid(String path, JsonArray methods, String id) throws ValidationException {
        if (path == null && methods != null) {
            throw new ValidationException("Missing path for defined method list permission " + id);
        }
    }
}

