/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.UriBuilder;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.RoleExtractor;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.security.authorization.ConfigurationResource;
import org.swisspush.gateleen.security.authorization.RoleAuthorizer;
import org.swisspush.gateleen.security.authorization.RoleMapper;
import org.swisspush.gateleen.validation.ValidationException;

public class Authorizer
implements LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.authorization-updated";
    private Pattern userUriPattern;
    private String aclKey = "acls";
    private String anonymousRole = "everyone";
    private RoleMapper roleMapper;
    private RoleAuthorizer roleAuthorizer;
    private PatternHolder aclUriPattern;
    private PatternHolder roleMapperUriPattern;
    private Vertx vertx;
    private EventBus eb;
    private boolean logACLChanges = false;
    private ResourceStorage storage;
    private RoleExtractor roleExtractor;
    public static final Logger log = LoggerFactory.getLogger(Authorizer.class);
    private long updateTimerId = -1L;

    public Authorizer(Vertx vertx, ResourceStorage storage, String securityRoot, String rolePattern) {
        this(vertx, storage, securityRoot, rolePattern, null, null);
    }

    public Authorizer(Vertx vertx, ResourceStorage storage, String securityRoot, String rolePattern, String rolePrefix, Map<String, Object> properties) {
        this(vertx, storage, securityRoot, rolePattern, rolePrefix, properties, true);
    }

    public Authorizer(Vertx vertx, ResourceStorage storage, String securityRoot, String rolePattern, String rolePrefix, Map<String, Object> properties, boolean grantAccessWithoutRoles) {
        this.vertx = vertx;
        this.storage = storage;
        String aclRoot = UriBuilder.concatUriSegments((String[])new String[]{securityRoot, this.aclKey, "/"});
        this.aclUriPattern = new PatternHolder("^" + aclRoot + "(?<role>.+)$");
        this.userUriPattern = Pattern.compile(securityRoot + "user(\\?.*)?");
        this.roleMapperUriPattern = new PatternHolder("^" + UriBuilder.concatUriSegments((String[])new String[]{securityRoot, "rolemapper"}));
        this.roleExtractor = new RoleExtractor(rolePattern);
        this.roleMapper = new RoleMapper(storage, securityRoot, properties);
        this.roleAuthorizer = new RoleAuthorizer(storage, securityRoot, rolePattern, rolePrefix, this.roleMapper, grantAccessWithoutRoles);
        this.eb = vertx.eventBus();
        this.eb.consumer(UPDATE_ADDRESS, role -> this.updateAllConfigs());
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logACLChanges = resourceLoggingEnabled;
    }

    public Future<Boolean> authorize(HttpServerRequest request) {
        Future future = Future.future();
        this.handleUserUriRequest(request, (Future<Boolean>)future);
        if (!future.isComplete()) {
            this.roleAuthorizer.handleIsAuthorized(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            this.handleConfigurationUriRequest(request, (Future<Boolean>)future, this.aclUriPattern, this.roleAuthorizer);
        }
        if (!future.isComplete()) {
            this.handleConfigurationUriRequest(request, (Future<Boolean>)future, this.roleMapperUriPattern, this.roleMapper);
        }
        if (!future.isComplete()) {
            future.complete((Object)Boolean.TRUE);
        }
        return future;
    }

    public void authorize(HttpServerRequest request, Handler<Void> handler) {
        Future future = Future.future();
        this.handleUserUriRequest(request, (Future<Boolean>)future);
        if (!future.isComplete()) {
            this.roleAuthorizer.handleIsAuthorized(request, (Future<Boolean>)future);
        }
        if (!future.isComplete()) {
            this.handleConfigurationUriRequest(request, (Future<Boolean>)future, this.aclUriPattern, this.roleAuthorizer);
        }
        if (!future.isComplete()) {
            this.handleConfigurationUriRequest(request, (Future<Boolean>)future, this.roleMapperUriPattern, this.roleMapper);
        }
        if (!future.isComplete()) {
            handler.handle(null);
        }
    }

    private void handleUserUriRequest(HttpServerRequest request, Future<Boolean> future) {
        if (this.userUriPattern.matcher(request.uri()).matches()) {
            if (HttpMethod.GET == request.method()) {
                String userId = request.headers().get("x-rp-usr");
                JsonObject user = new JsonObject();
                request.response().headers().set("Content-Type", "application/json");
                String userName = request.headers().get("cas_name");
                if (userName != null) {
                    userId = userName;
                }
                user.put("userId", userId);
                Set roles = this.roleExtractor.extractRoles(request);
                if (roles != null) {
                    roles.add(this.anonymousRole);
                    user.put("roles", new JsonArray(new ArrayList(roles)));
                }
                ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.OK, Authorizer.class);
                request.response().end(user.toString());
            } else {
                ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.METHOD_NOT_ALLOWED, Authorizer.class);
                request.response().setStatusCode(StatusCode.METHOD_NOT_ALLOWED.getStatusCode());
                request.response().setStatusMessage(StatusCode.METHOD_NOT_ALLOWED.getStatusMessage());
                request.response().end();
            }
            future.complete((Object)Boolean.FALSE);
        }
    }

    private void handleConfigurationUriRequest(HttpServerRequest request, Future<Boolean> future, PatternHolder patternHolder, ConfigurationResource checker) {
        Matcher aclMatcher = patternHolder.getPattern(request.headers()).matcher(request.uri());
        if (aclMatcher.matches()) {
            if (HttpMethod.PUT == request.method()) {
                request.bodyHandler(buffer -> {
                    try {
                        checker.checkConfigResource((Buffer)buffer);
                    }
                    catch (ValidationException validationException) {
                        log.warn("Could not parse acl: {}", (Object)validationException.toString());
                        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, Authorizer.class);
                        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                        if (validationException.getValidationDetails() != null) {
                            request.response().headers().add("content-type", "application/json");
                            request.response().end(validationException.getValidationDetails().encode());
                        } else {
                            request.response().end(validationException.getMessage());
                        }
                        return;
                    }
                    this.storage.put(request.uri(), buffer, status -> {
                        if (status.intValue() == StatusCode.OK.getStatusCode()) {
                            if (this.logACLChanges) {
                                RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                            }
                            this.scheduleUpdate();
                        } else {
                            request.response().setStatusCode(status.intValue());
                        }
                        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), Authorizer.class);
                        request.response().end();
                    });
                });
                future.complete((Object)Boolean.FALSE);
            } else if (HttpMethod.DELETE == request.method()) {
                this.storage.delete(request.uri(), status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        this.eb.publish(UPDATE_ADDRESS, (Object)"*");
                    } else {
                        log.warn("Could not delete '{}'. Error code is '{}'.", (Object)(request.uri() == null ? "<null>" : request.uri()), status == null ? "<null>" : status);
                        request.response().setStatusCode(status.intValue());
                    }
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), Authorizer.class);
                    request.response().end();
                });
                future.complete((Object)Boolean.FALSE);
            }
        }
    }

    private void updateAllConfigs() {
        this.roleAuthorizer.configUpdate();
        this.roleMapper.configUpdate();
    }

    private void scheduleUpdate() {
        this.vertx.cancelTimer(this.updateTimerId);
        this.updateTimerId = this.vertx.setTimer(3000L, id -> this.eb.publish(UPDATE_ADDRESS, (Object)"*"));
    }
}

