/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.authorization;

import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.UriBuilder;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.security.authorization.ConfigurationResource;
import org.swisspush.gateleen.security.authorization.RoleMapperFactory;
import org.swisspush.gateleen.security.authorization.RoleMapperHolder;
import org.swisspush.gateleen.validation.ValidationException;

public class RoleMapper
implements ConfigurationResource {
    private ResourceStorage storage;
    private String roleMapper;
    private RoleMapperFactory roleMapperFactory;
    private List<RoleMapperHolder> roleMappers = null;
    public static final Logger log = LoggerFactory.getLogger(RoleMapper.class);
    public static final String ROLEMAPPER = "rolemapper";

    public RoleMapper(ResourceStorage storage, String securityRoot, Map<String, Object> properties) {
        this.storage = storage;
        this.roleMapper = UriBuilder.concatUriSegments((String[])new String[]{securityRoot, ROLEMAPPER});
        this.roleMapperFactory = new RoleMapperFactory(properties);
        this.configUpdate();
    }

    @Override
    public void checkConfigResource(Buffer buffer) throws ValidationException {
        this.roleMapperFactory.parseRoleMapper(buffer);
    }

    @Override
    public void configUpdate() {
        this.storage.get(this.roleMapper, buffer -> {
            if (buffer != null) {
                try {
                    this.roleMappers = this.roleMapperFactory.parseRoleMapper((Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    log.error("Could not parse acl for role mapper: {}", (Object)validationException.toString());
                }
            } else {
                log.info("No RoleMappers found in storage");
                this.roleMappers = null;
            }
        });
    }

    public Map<String, MappedRole> mapRoles(Set<String> roles) {
        HashMap<String, MappedRole> mappedRoles = new HashMap<String, MappedRole>();
        if (roles != null) {
            Iterator<String> iterator = roles.iterator();
            while (iterator.hasNext()) {
                String role;
                String originalRole = role = iterator.next();
                if (this.roleMappers != null && !this.roleMappers.isEmpty()) {
                    for (RoleMapperHolder mapper : this.roleMappers) {
                        Matcher matcher = mapper.getPattern().matcher(role);
                        if (!matcher.matches()) continue;
                        String matchedRole = matcher.replaceAll(mapper.getRole());
                        mappedRoles.put(originalRole, new MappedRole(originalRole, mapper.getKeepOriginalRole()));
                        if (mapper.getContinueMapping()) {
                            originalRole = matchedRole;
                            continue;
                        }
                        originalRole = null;
                        mappedRoles.put(matchedRole, new MappedRole(matchedRole, mapper.getKeepResultingRole()));
                        break;
                    }
                    if (originalRole == null) continue;
                    mappedRoles.put(originalRole, new MappedRole(originalRole, true));
                    continue;
                }
                mappedRoles.put(originalRole, new MappedRole(originalRole, true));
            }
        }
        return mappedRoles;
    }

    public class MappedRole {
        public final String role;
        public final boolean forward;

        public MappedRole(String role, boolean forward) {
            this.role = role;
            this.forward = forward;
        }
    }
}

