/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.security.content.ContentTypeConstraint;

public class ContentTypeConstraintRepository {
    private final Logger log = LoggerFactory.getLogger(ContentTypeConstraintRepository.class);
    private final List<ContentTypeConstraint> constraints = new ArrayList<ContentTypeConstraint>();

    void clearConstraints() {
        this.log.info("About to clear Content-Type constraints");
        this.constraints.clear();
    }

    void setConstraints(List<ContentTypeConstraint> constraints) {
        this.clearConstraints();
        if (constraints != null) {
            this.log.info("About to set {} Content-Type constraints", (Object)constraints.size());
            this.constraints.addAll(constraints);
        }
    }

    Optional<ContentTypeConstraint> findMatchingContentTypeConstraint(String requestUri) {
        for (ContentTypeConstraint constraint : this.constraints) {
            if (!constraint.urlPattern().getPattern().matcher(requestUri).matches()) continue;
            return Optional.of(constraint);
        }
        return Optional.empty();
    }
}

