/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security.content;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.security.content.ContentTypeConstraint;

class ContentTypeConstraintFactory {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeConstraintFactory.class);
    private static final String ALLOWED_TYPES = "allowedTypes";

    ContentTypeConstraintFactory() {
    }

    static List<ContentTypeConstraint> create(Buffer constraintResourceBuffer) {
        ArrayList<ContentTypeConstraint> constraints = new ArrayList<ContentTypeConstraint>();
        JsonObject config = constraintResourceBuffer.toJsonObject();
        for (String urlPattern : config.fieldNames()) {
            try {
                Pattern pattern = Pattern.compile(urlPattern);
                List<PatternHolder> allowedTypes = ContentTypeConstraintFactory.extractAllowedTypes(config.getJsonObject(urlPattern));
                if (!allowedTypes.isEmpty()) {
                    constraints.add(new ContentTypeConstraint(new PatternHolder(pattern.pattern()), allowedTypes));
                    log.info("Constraint '{}' successfully parsed and added to constraint configuration list", (Object)urlPattern);
                    continue;
                }
                log.warn("Constraint configuration '{}' has no valid 'allowedTypes' regex pattern. Discarding this constraint", (Object)urlPattern);
            }
            catch (PatternSyntaxException patternException) {
                log.warn("Constraint '{}' is not a valid regex pattern. Discarding this constraint", (Object)urlPattern);
            }
        }
        return constraints;
    }

    private static List<PatternHolder> extractAllowedTypes(JsonObject constraintObj) {
        ArrayList<PatternHolder> allowedTypes = new ArrayList<PatternHolder>();
        JsonArray allowedTypesArray = constraintObj.getJsonArray(ALLOWED_TYPES);
        if (allowedTypesArray == null) {
            log.warn("No '{}' array found in configuration", (Object)ALLOWED_TYPES);
            return allowedTypes;
        }
        for (Object allowedType : allowedTypesArray) {
            String allowedTypeStr = (String)allowedType;
            if (StringUtils.isNotEmptyTrimmed((String)allowedTypeStr)) {
                try {
                    allowedTypes.add(new PatternHolder(Pattern.compile(allowedTypeStr).pattern()));
                }
                catch (PatternSyntaxException patternException) {
                    log.warn("Content-Type constraint '{}' is not a valid regex pattern. Discarding this constraint", (Object)allowedTypeStr);
                }
                continue;
            }
            log.warn("Content-Type constraint '{}' is not allowed to be empty. Discarding this constraint", (Object)allowedTypeStr);
        }
        return allowedTypes;
    }
}

