/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.security;

import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternHolder {
    private Pattern pattern;
    private String patternStr;
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[<](.+?)[>]");
    private static final MultiMap EMPTY_HEADERS = MultiMap.caseInsensitiveMultiMap();

    public PatternHolder(String patternStr) {
        if (this.containsWildcards(patternStr)) {
            this.patternStr = patternStr;
        } else {
            this.pattern = Pattern.compile(patternStr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternHolder that = (PatternHolder)o;
        if (this.pattern != null && that.pattern != null) {
            return this.pattern.pattern().equals(that.pattern.pattern());
        }
        if (this.pattern == null && that.pattern != null) {
            return false;
        }
        if (this.pattern != null) {
            return false;
        }
        return this.patternStr != null ? this.patternStr.equals(that.patternStr) : that.patternStr == null;
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.pattern().hashCode() : 0;
        result = 31 * result + (this.patternStr != null ? this.patternStr.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PatternHolder{pattern=" + String.valueOf(this.pattern) + ", patternStr='" + this.patternStr + "'}";
    }

    public Pattern getPattern(MultiMap headers) {
        if (this.patternStr != null) {
            String replacedWildcards = this.replaceWildcards(this.patternStr, headers);
            return Pattern.compile(replacedWildcards);
        }
        return this.pattern;
    }

    public Pattern getPattern() {
        return this.getPattern(EMPTY_HEADERS);
    }

    private boolean containsWildcards(String patternStr) {
        return !this.wildcards(patternStr).isEmpty();
    }

    private List<String> wildcards(String patternStr) {
        ArrayList<String> wildcards = new ArrayList<String>();
        Matcher matcher = WILDCARD_PATTERN.matcher(patternStr);
        while (matcher.find()) {
            String wildcard = matcher.group(1);
            wildcards.add(wildcard);
        }
        return wildcards;
    }

    private String replaceWildcards(String patternStr, MultiMap headers) {
        List<String> wildcards = this.wildcards(patternStr);
        String replacePattern = patternStr;
        for (String wildcard : wildcards) {
            if (headers.get(wildcard) == null) continue;
            replacePattern = replacePattern.replaceAll(Pattern.quote("<" + wildcard + ">"), headers.get(wildcard));
        }
        return replacePattern;
    }
}

