/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.user;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.RoleExtractor;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.logging.LoggingHandler;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.user.UserProfileConfiguration;
import org.swisspush.gateleen.user.UserProfileManipulater;

public class UserProfileHandler {
    private Vertx vertx;
    private ResourceStorage storage;
    private LoggingResourceManager loggingResourceManager;
    private String roleProfileKey = "profile";
    private UserProfileConfiguration userProfileConfiguration;
    private UserProfileManipulater userProfileManipulater;
    private Logger log = LoggerFactory.getLogger(UserProfileHandler.class);
    private Map<String, JsonObject> roleProfiles = new HashMap<String, JsonObject>();
    private RoleExtractor roleExtractor;

    public UserProfileHandler(Vertx vertx, ResourceStorage storage, LoggingResourceManager loggingResourceManager, UserProfileConfiguration userProfileConfiguration) {
        this.vertx = vertx;
        this.storage = storage;
        this.userProfileConfiguration = userProfileConfiguration;
        this.userProfileManipulater = new UserProfileManipulater(this.log);
        this.roleExtractor = new RoleExtractor(userProfileConfiguration.getRolePattern());
        this.loggingResourceManager = loggingResourceManager;
        this.updateRoleProfiles();
        EventBus eb = vertx.eventBus();
        eb.consumer("gateleen.roleprofiles-updated", role -> this.updateRoleProfiles());
    }

    public boolean isUserProfileRequest(HttpServerRequest request) {
        return this.userProfileConfiguration.doesUrlMatchTheProfileUriPattern(request.path());
    }

    public void handle(HttpServerRequest request) {
        switch (request.method()) {
            case GET: {
                this.storage.get(request.path(), buffer -> {
                    request.response().headers().set("Content-Type", "application/json");
                    String userId = this.userProfileConfiguration.extractUserIdFromProfileUri(request.path());
                    if (buffer != null) {
                        request.response().setStatusCode(StatusCode.OK.getStatusCode());
                        JsonObject profile = new JsonObject(buffer.toString());
                        int enrichUpdateCount = this.userProfileManipulater.enrichProfile(request.headers(), profile, userId, this.userProfileConfiguration.getProfileProperties().values());
                        JsonObject mergedProfile = this.mergeUserProfileWithRoleProfile(request, profile);
                        this.logPayload(request, StatusCode.OK.getStatusCode(), Buffer.buffer((String)mergedProfile.encode()), request.response().headers());
                        if (enrichUpdateCount == 0) {
                            request.response().end(mergedProfile.encode());
                        } else {
                            this.log.debug("Updated the profile in a GET request (special case). Request path is " + request.path() + ".");
                            this.storage.put(request.path(), Buffer.buffer((String)profile.encode()), status -> request.response().end(mergedProfile.encode()));
                        }
                    } else {
                        request.response().setStatusCode(StatusCode.OK.getStatusCode());
                        JsonObject profile = this.userProfileManipulater.createInitialProfile(request.headers(), userId, this.userProfileConfiguration.getProfileProperties().values());
                        JsonObject mergedProfile = this.mergeUserProfileWithRoleProfile(request, profile);
                        this.storage.put(request.path(), Buffer.buffer((String)profile.encode()), status -> {
                            this.logPayload(request, (Integer)status, Buffer.buffer((String)mergedProfile.encode()), request.response().headers());
                            request.response().end(mergedProfile.encode());
                        });
                    }
                });
                break;
            }
            case PUT: {
                request.pause();
                this.storage.get(request.path(), existingBuffer -> {
                    if (existingBuffer != null) {
                        request.resume();
                    } else {
                        this.log.debug("Tried to put (merge) a profile, path is '" + (request.path() == null || request == null ? "<null>" : request.path()) + "', but profile was not found. Create a new profile.");
                        JsonObject profile = this.userProfileManipulater.createProfileWithLanguage(request.headers());
                        this.cleanupUserProfile(profile, (Handler<JsonObject>)((Handler)updatedProfile -> this.storage.put(request.path() + "?merge=true", Buffer.buffer((String)updatedProfile.encode()), status -> request.resume())));
                    }
                });
                request.bodyHandler(newBuffer -> {
                    JsonObject profile = null;
                    try {
                        profile = new JsonObject(newBuffer.toString());
                    }
                    catch (DecodeException ex) {
                        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                        request.response().end(StatusCode.BAD_REQUEST.getStatusMessage());
                        return;
                    }
                    this.cleanupUserProfile(profile, (Handler<JsonObject>)((Handler)updatedProfile -> this.storage.put(request.uri() + "?merge=true", Buffer.buffer((String)updatedProfile.encode()), status -> {
                        this.logPayload(request, (Integer)status, Buffer.buffer((String)updatedProfile.encode()), (MultiMap)new CaseInsensitiveHeaders());
                        request.response().setStatusCode(status.intValue());
                        request.response().end();
                    })));
                });
                break;
            }
            case DELETE: {
                this.storage.delete(request.path(), status -> {
                    request.response().setStatusCode(status.intValue());
                    request.response().end();
                });
                break;
            }
            default: {
                request.response().setStatusCode(StatusCode.METHOD_NOT_ALLOWED.getStatusCode());
                request.response().end(StatusCode.METHOD_NOT_ALLOWED.getStatusMessage());
            }
        }
    }

    protected void cleanupUserProfile(JsonObject profile, Handler<JsonObject> profileCallback) {
        this.log.debug("About to remove 'not allowed' properties from user profile");
        JsonObject profileCopy = profile.copy();
        Set profileFieldNames = profileCopy.fieldNames();
        profileFieldNames.stream().filter(fieldName -> !this.userProfileConfiguration.isAllowedProfileProperty((String)fieldName)).forEach(fieldName -> {
            this.log.debug("Removing property '" + fieldName + "' from user profile");
            profile.remove(fieldName);
        });
        profileCallback.handle((Object)profile);
    }

    private JsonObject mergeUserProfileWithRoleProfile(HttpServerRequest request, JsonObject userProfile) {
        Set roles = this.roleExtractor.extractRoles(request);
        JsonObject roleProfileAccumulated = new JsonObject();
        if (roles != null) {
            for (String role : roles) {
                JsonObject roleProfile = this.roleProfiles.get(role);
                if (roleProfile == null) continue;
                roleProfileAccumulated.mergeIn(roleProfile);
            }
        }
        return roleProfileAccumulated.mergeIn(userProfile);
    }

    private void updateRoleProfiles() {
        this.storage.get(this.userProfileConfiguration.getRoleProfilesRoot(), buffer -> {
            if (buffer != null) {
                this.roleProfiles = new HashMap<String, JsonObject>();
                for (Object profileObject : new JsonObject(buffer.toString()).getJsonArray("v1")) {
                    String role = (String)profileObject;
                    role = role.replaceAll("/$", "");
                    role = role.replaceAll("^/", "");
                    this.updateRoleProfile(role);
                }
            } else {
                this.log.debug("No Role Profiles in storage, remove all roles");
                this.roleProfiles.clear();
            }
        });
    }

    private void updateRoleProfile(String role) {
        this.storage.get(this.userProfileConfiguration.getRoleProfilesRoot() + role + "/" + this.roleProfileKey, buffer -> {
            if (buffer != null) {
                try {
                    this.log.debug("Applying role profile for " + role);
                    this.mergeRole(role, (Buffer)buffer);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Could not reconfigure routing", (Throwable)e);
                }
            } else {
                this.log.error("No profile for role " + role + " found in storage");
            }
        });
    }

    private void mergeRole(String role, Buffer buffer) {
        JsonObject roleProfile = new JsonObject(buffer.toString());
        this.roleProfiles.put(role, roleProfile);
    }

    private void logPayload(HttpServerRequest request, Integer status, Buffer data, MultiMap responseHeaders) {
        LoggingHandler loggingHandler = new LoggingHandler(this.loggingResourceManager, request);
        if (HttpMethod.PUT == request.method()) {
            loggingHandler.appendRequestPayload(data);
        } else if (HttpMethod.GET == request.method()) {
            loggingHandler.appendResponsePayload(data, responseHeaders);
        }
        StatusCode statusCode = StatusCode.fromCode((int)status);
        String statusMessage = statusCode != null ? statusCode.getStatusMessage() : "";
        this.vertx.runOnContext(event -> loggingHandler.log(request.uri(), request.method(), status.intValue(), statusMessage, request.headers(), responseHeaders));
    }
}

