/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.user;

import com.google.common.base.Objects;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import java.util.Collection;
import org.slf4j.Logger;
import org.swisspush.gateleen.user.UserProfileConfiguration;

public class UserProfileManipulater {
    private Logger log;

    public UserProfileManipulater(Logger log) {
        this.log = log;
    }

    public JsonObject createInitialProfile(MultiMap headers, String userId, Collection<UserProfileConfiguration.ProfileProperty> profileProperties) {
        JsonObject profile = this.createProfileWithLanguage(headers);
        this.enrichProfile(headers, profile, userId, profileProperties);
        return profile;
    }

    protected int enrichProfile(MultiMap headers, JsonObject profile, String userId, Collection<UserProfileConfiguration.ProfileProperty> profileProperties) {
        int updateCount = 0;
        for (UserProfileConfiguration.ProfileProperty profileProperty : profileProperties) {
            if (!this.updateField(userId, headers, profile, profileProperty)) continue;
            ++updateCount;
        }
        return updateCount;
    }

    public boolean updateField(String userId, MultiMap headers, JsonObject profile, UserProfileConfiguration.ProfileProperty profileProperty) {
        boolean hasRealChange;
        String valueToUse;
        boolean xRpUsrMatch;
        String valueInHeader = headers.contains(profileProperty.getHeaderName()) ? headers.get(profileProperty.getHeaderName()) : null;
        boolean isValidValueInHeader = profileProperty.isValid(valueInHeader);
        String valueInProfile = profile.containsKey(profileProperty.getProfileName()) ? profile.getString(profileProperty.getProfileName()) : null;
        boolean isValidValueInProfile = profileProperty.isValid(valueInProfile);
        boolean bl = xRpUsrMatch = userId != null && headers.contains("x-rp-usr") && userId.equals(headers.get("x-rp-usr"));
        if (!isValidValueInHeader && valueInHeader != null) {
            this.log.error("UserProfileManipulator - got the header attribute [" + profileProperty.getHeaderName() + "," + headers.get(profileProperty.getHeaderName()) + "], " + "according the validation regex " + "[" + profileProperty.getValidationRegex() + "] " + "this is not a valid value, we don't set it into the profile");
        }
        if (xRpUsrMatch) {
            if (isValidValueInHeader) {
                if (isValidValueInProfile) {
                    switch (profileProperty.getUpdateStrategy()) {
                        case UPDATE_ALWAYS: {
                            valueToUse = valueInHeader;
                            break;
                        }
                        case UPDATE_ONLY_IF_PROFILE_VALUE_IS_INVALID: {
                            valueToUse = valueInProfile;
                            break;
                        }
                        default: {
                            this.log.error("Invalid update strategy: " + (Object)((Object)profileProperty.getUpdateStrategy()) + ". Assume UPDATE_ALWAYS.");
                            valueToUse = valueInHeader;
                            break;
                        }
                    }
                } else {
                    valueToUse = valueInHeader;
                }
            } else {
                valueToUse = isValidValueInProfile ? valueInProfile : profileProperty.getValueToUseIfNoOtherValidValue();
            }
        } else {
            valueToUse = isValidValueInProfile ? valueInProfile : profileProperty.getValueToUseIfNoOtherValidValue();
        }
        boolean bl2 = hasRealChange = !Objects.equal((Object)valueToUse, (Object)valueInProfile);
        if (hasRealChange) {
            if (valueToUse != null) {
                profile.put(profileProperty.getProfileName(), valueToUse);
            } else {
                profile.remove(profileProperty.getProfileName());
            }
            return true;
        }
        return false;
    }

    protected JsonObject createProfileWithLanguage(MultiMap headers) {
        String accepted;
        String lang = headers.contains("x-rp-lang") ? UserProfileManipulater.getLang(headers) : (headers.contains("Accept-Language") ? ((accepted = headers.get("Accept-Language").split(",")[0].split(";")[0].split("-")[0].toLowerCase()).equals("de") || accepted.equals("fr") || accepted.equals("it") || accepted.equals("en") ? accepted : "de") : "de");
        JsonObject profile = new JsonObject();
        profile.put("lang", lang);
        return profile;
    }

    public static String getLang(MultiMap headers) {
        String lang;
        switch (headers.get("x-rp-lang")) {
            case "D": {
                lang = "de";
                break;
            }
            case "F": {
                lang = "fr";
                break;
            }
            case "I": {
                lang = "it";
                break;
            }
            case "E": {
                lang = "en";
                break;
            }
            default: {
                lang = "de";
            }
        }
        return lang;
    }
}

