/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.user;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.json.JsonUtil;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;

public class RoleProfileHandler
implements LoggableResource {
    public static final String UPDATE_ADDRESS = "gateleen.roleprofiles-updated";
    private ResourceStorage storage;
    private Logger log = LoggerFactory.getLogger(RoleProfileHandler.class);
    private boolean logRoleProfileChanges = false;
    private Pattern uriPattern;
    private Vertx vertx;
    private EventBus eb;
    private long updateTimerId = -1L;

    public RoleProfileHandler(Vertx vertx, ResourceStorage storage, String roleProfileUriPattern) {
        this.storage = storage;
        this.vertx = vertx;
        this.uriPattern = Pattern.compile(roleProfileUriPattern);
        this.eb = vertx.eventBus();
    }

    public boolean isRoleProfileRequest(HttpServerRequest request) {
        return this.uriPattern.matcher(request.path()).matches();
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logRoleProfileChanges = resourceLoggingEnabled;
    }

    public void handle(HttpServerRequest request) {
        RequestLoggerFactory.getLogger(RoleProfileHandler.class, (HttpServerRequest)request).info("handling " + request.method() + " " + request.path());
        switch (request.method()) {
            case GET: {
                this.storage.get(request.path(), buffer -> {
                    request.response().headers().set("Content-Type", "application/json");
                    if (buffer != null) {
                        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.OK, RoleProfileHandler.class);
                        request.response().setStatusCode(StatusCode.OK.getStatusCode());
                        request.response().end(buffer);
                    } else {
                        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.NOT_FOUND, RoleProfileHandler.class);
                        request.response().setStatusCode(StatusCode.NOT_FOUND.getStatusCode());
                        request.response().end();
                    }
                });
                break;
            }
            case PUT: {
                request.bodyHandler(newBuffer -> {
                    JsonObject roleProfileProperties = new JsonObject(newBuffer.toString("UTF-8"));
                    if (JsonUtil.containsNoNestedProperties((JsonObject)roleProfileProperties)) {
                        this.storage.put(request.uri() + "?merge=true", newBuffer, status -> {
                            if (status.intValue() == StatusCode.OK.getStatusCode()) {
                                if (this.logRoleProfileChanges) {
                                    RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)newBuffer);
                                }
                                this.scheduleUpdate();
                            } else {
                                request.response().setStatusCode(status.intValue());
                            }
                            ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), RoleProfileHandler.class);
                            request.response().end();
                        });
                    } else {
                        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, RoleProfileHandler.class);
                        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                        request.response().end("role profiles can't take nested property values");
                    }
                });
                break;
            }
            case DELETE: {
                this.storage.delete(request.path(), status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        this.eb.publish(UPDATE_ADDRESS, (Object)"*");
                    } else {
                        this.log.warn("Could not delete '" + (request.uri() == null ? "<null>" : request.uri()) + "'. Error code is '" + (status == null ? "<null>" : status) + "'.");
                        request.response().setStatusCode(status.intValue());
                    }
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), RoleProfileHandler.class);
                    request.response().end();
                });
                break;
            }
            default: {
                ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.METHOD_NOT_ALLOWED, RoleProfileHandler.class);
                request.response().setStatusCode(StatusCode.METHOD_NOT_ALLOWED.getStatusCode());
                request.response().end(StatusCode.METHOD_NOT_ALLOWED.getStatusMessage());
            }
        }
    }

    private void scheduleUpdate() {
        this.vertx.cancelTimer(this.updateTimerId);
        this.updateTimerId = this.vertx.setTimer(3000L, id -> this.eb.publish(UPDATE_ADDRESS, (Object)"*"));
    }
}

