/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class UserProfileConfiguration {
    private Map<String, ProfileProperty> profileProperties = new HashMap<String, ProfileProperty>();
    private List<String> allowedProfileProperties = new ArrayList<String>();
    private boolean removeNotAllowedProfileProperties = false;
    private Pattern userProfileUriPattern;
    private final String roleProfilesRoot;
    private final String rolePattern;

    private UserProfileConfiguration(UserProfileConfigurationBuilder arguments) {
        this.allowedProfileProperties = arguments.allowedProfileProperties;
        this.removeNotAllowedProfileProperties = arguments.removeNotAllowedProfileProperties;
        this.profileProperties = arguments.profileProperties;
        if (arguments.userProfileUriPattern != null) {
            this.userProfileUriPattern = Pattern.compile(arguments.userProfileUriPattern);
        }
        this.roleProfilesRoot = arguments.roleProfilesRoot;
        this.rolePattern = arguments.rolePattern;
    }

    public static UserProfileConfigurationBuilder create() {
        return new UserProfileConfigurationBuilder();
    }

    public Map<String, ProfileProperty> getProfileProperties() {
        return this.profileProperties;
    }

    public boolean isAllowedProfileProperty(String fieldName) {
        return this.allowedProfileProperties.contains(fieldName);
    }

    public boolean isRemoveNotAllowedProfileProperties() {
        return this.removeNotAllowedProfileProperties;
    }

    public boolean doesUrlMatchTheProfileUriPattern(String url) {
        return this.userProfileUriPattern.matcher(url).matches();
    }

    public String extractUserIdFromProfileUri(String url) {
        Matcher matcher = this.userProfileUriPattern.matcher(url);
        matcher.matches();
        try {
            return matcher.group(1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRoleProfilesRoot() {
        return this.roleProfilesRoot;
    }

    public String getRolePattern() {
        return this.rolePattern;
    }

    public static class UserProfileConfigurationBuilder {
        private List<String> allowedProfileProperties = new ArrayList<String>();
        private boolean removeNotAllowedProfileProperties = false;
        private Map<String, ProfileProperty> profileProperties = new HashMap<String, ProfileProperty>();
        private String userProfileUriPattern;
        private String roleProfilesRoot;
        private String rolePattern;

        public UserProfileConfigurationBuilder addAllowedProfileProperties(String ... allowedProfileProperties) {
            if (allowedProfileProperties != null) {
                this.allowedProfileProperties = Arrays.asList(allowedProfileProperties);
            }
            return this;
        }

        public UserProfileConfigurationBuilder removeNotAllowedProfileProperties(boolean removeNotAllowedProfileProperties) {
            this.removeNotAllowedProfileProperties = removeNotAllowedProfileProperties;
            return this;
        }

        public UserProfileConfigurationBuilder addProfileProperty(ProfileProperty profileProperty) {
            this.profileProperties.put(profileProperty.getHeaderName(), profileProperty);
            return this;
        }

        public UserProfileConfigurationBuilder userProfileUriPattern(String userProfileUriPattern) {
            this.userProfileUriPattern = userProfileUriPattern;
            return this;
        }

        public UserProfileConfigurationBuilder roleProfilesRoot(String roleProfilesRoot) {
            this.roleProfilesRoot = roleProfilesRoot;
            return this;
        }

        public UserProfileConfigurationBuilder rolePattern(String rolePattern) {
            this.rolePattern = rolePattern;
            return this;
        }

        public UserProfileConfiguration build() {
            return new UserProfileConfiguration(this);
        }
    }

    public static class ProfileProperty {
        private final String headerName;
        private final String profileName;
        private final String validationRegex;
        private Pattern validationRegexPattern;
        private final boolean optional;
        private final UpdateStrategy updateStrategy;
        private final String valueToUseIfNoOtherValidValue;

        private ProfileProperty(ProfilePropertyBuilder arguments) {
            this.headerName = arguments.headerName;
            this.profileName = arguments.profileName;
            this.validationRegex = arguments.validationRegex;
            this.optional = arguments.optional;
            this.updateStrategy = arguments.updateStrategy;
            this.valueToUseIfNoOtherValidValue = arguments.valueToUseIfNoOtherValidValue;
        }

        public static ProfilePropertyBuilder with(String headerName, String profileName) {
            return new ProfilePropertyBuilder(headerName, profileName);
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public String getProfileName() {
            return this.profileName;
        }

        public String getValueToUseIfNoOtherValidValue() {
            return this.valueToUseIfNoOtherValidValue;
        }

        public String getValidationRegex() {
            return this.validationRegex;
        }

        public UpdateStrategy getUpdateStrategy() {
            return this.updateStrategy;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isValid(String value) {
            if (value == null) {
                return this.isOptional();
            }
            if (this.validationRegexPattern == null) {
                return true;
            }
            return this.validationRegexPattern.matcher(value).matches();
        }

        protected void compileRegex() {
            if (this.validationRegex == null) {
                return;
            }
            try {
                this.validationRegexPattern = Pattern.compile(this.validationRegex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalStateException("UserProfile - the validation regex for the profile attribute: " + this.profileName + " is not valid: " + this.validationRegex);
            }
        }

        public static class ProfilePropertyBuilder {
            public boolean optional;
            public UpdateStrategy updateStrategy = UpdateStrategy.UPDATE_ALWAYS;
            public String valueToUseIfNoOtherValidValue;
            private final String headerName;
            private final String profileName;
            private String validationRegex;

            protected ProfilePropertyBuilder(String headerName, String profileName) {
                this.headerName = headerName;
                this.profileName = profileName;
            }

            public ProfilePropertyBuilder validationRegex(String validationRegex) {
                this.validationRegex = validationRegex;
                return this;
            }

            public ProfilePropertyBuilder setUpdateStrategy(UpdateStrategy updateStrategy) {
                this.updateStrategy = updateStrategy;
                return this;
            }

            public ProfilePropertyBuilder setOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            public ProfilePropertyBuilder setValueToUseIfNoOtherValidValue(String valueToUseIfNoOtherValidValue) {
                this.valueToUseIfNoOtherValidValue = valueToUseIfNoOtherValidValue;
                return this;
            }

            public ProfileProperty build() {
                ProfileProperty profileProperty = new ProfileProperty(this);
                profileProperty.compileRegex();
                return profileProperty;
            }
        }
    }

    public static enum UpdateStrategy {
        UPDATE_ONLY_IF_PROFILE_VALUE_IS_INVALID,
        UPDATE_ALWAYS;

    }
}

