/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.validation;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpServerRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.validation.ValidationResourceManager;
import org.swisspush.gateleen.validation.Validator;

public class ValidationHandler {
    public static final String HOOKS_LISTENERS_URI_PART = "/_hooks/listeners/";
    public static final String HOOKS_ROUTE_URI_PART = "/_hooks/route";
    public static final String ACCEPT = "accept";
    private HttpClient httpClient;
    private List<String> supportedMethods = Arrays.asList("PUT", "GET", "POST");
    private List<String> outMethods = Arrays.asList("GET", "POST");
    private List<String> inMethods = Arrays.asList("PUT", "POST");
    private static final String VALID_HEADER = "X-Valid";
    private static final String EXPAND_PARAM = "expand";
    private static final int TIMEOUT = 120000;
    private static final Pattern noExtension = Pattern.compile(".*/[^/\\.]*$");
    private Validator validator;
    private ValidationResourceManager validationResourceManager;
    private boolean failOnError = true;

    public ValidationHandler(ValidationResourceManager validationResourceManager, ResourceStorage storage, HttpClient httpClient, String schemaRoot) {
        this.validationResourceManager = validationResourceManager;
        this.httpClient = httpClient;
        this.validator = new Validator(storage, schemaRoot);
    }

    public boolean isToValidate(HttpServerRequest request) {
        boolean doValidate;
        Logger log = RequestLoggerFactory.getLogger(ValidationHandler.class, (HttpServerRequest)request);
        boolean bl = doValidate = this.supportedMethods.contains(request.method().name()) && this.isJsonRequest(request) && !request.headers().names().contains(VALID_HEADER) && !request.params().names().contains(EXPAND_PARAM);
        if (!doValidate) {
            return false;
        }
        if (request.uri().contains(HOOKS_ROUTE_URI_PART) || request.uri().contains(HOOKS_LISTENERS_URI_PART)) {
            return false;
        }
        List<Map<String, String>> validationResources = this.validationResourceManager.getValidationResource().getResources();
        try {
            for (Map<String, String> validationResource : validationResources) {
                if (!this.doesRequestValueMatch(request.method().name(), validationResource.get("method")) || !this.doesRequestValueMatch(request.uri(), validationResource.get("url"))) continue;
                return true;
            }
        }
        catch (PatternSyntaxException patternException) {
            log.error(patternException.getMessage() + " " + patternException.getPattern());
        }
        return false;
    }

    private boolean doesRequestValueMatch(String value, String valuePattern) {
        Pattern pattern = Pattern.compile(valuePattern);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }

    private boolean isJsonRequest(HttpServerRequest request) {
        boolean jsonRequest = request.headers().get(ACCEPT) != null && request.headers().get(ACCEPT).contains("application/json");
        jsonRequest |= request.headers().get(ACCEPT) != null && request.headers().get(ACCEPT).contains("text/plain");
        jsonRequest |= request.headers().get("content-type") != null && request.headers().get("content-type").contains("application/json");
        return jsonRequest |= noExtension.matcher(request.path()).matches();
    }

    private void handleValidation(HttpServerRequest req) {
        Logger log = RequestLoggerFactory.getLogger(ValidationHandler.class, (HttpServerRequest)req);
        HttpClientRequest cReq = this.httpClient.request(req.method(), req.uri(), cRes -> {
            ResponseStatusCodeLogUtil.info((HttpServerRequest)req, (StatusCode)StatusCode.fromCode((int)cRes.statusCode()), ValidationHandler.class);
            req.response().setStatusCode(cRes.statusCode());
            req.response().setStatusMessage(cRes.statusMessage());
            req.response().headers().setAll(cRes.headers());
            cRes.bodyHandler(data -> {
                if (req.response().getStatusCode() == StatusCode.OK.getStatusCode() && this.outMethods.contains(req.method().name()) && data.length() > 0) {
                    this.validator.validate(req, req.method() + "/out", (Buffer)data, (Handler<ValidationResult>)((Handler)event -> {
                        if (event.isSuccess()) {
                            req.response().end(data);
                        } else if (this.isFailOnError()) {
                            req.response().headers().clear();
                            req.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                            req.response().setStatusMessage(event.getMessage());
                            req.response().end();
                        } else {
                            log.warn(event.getMessage());
                            req.response().end(data);
                        }
                    }));
                } else {
                    req.response().end(data);
                }
            });
            cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)req, (String)req.uri(), ValidationHandler.class));
        });
        cReq.setTimeout(120000L);
        cReq.headers().setAll(req.headers());
        cReq.headers().set(VALID_HEADER, "0");
        req.bodyHandler(data -> {
            if (this.inMethods.contains(req.method().name())) {
                this.validator.validate(req, req.method() + "/in", (Buffer)data, (Handler<ValidationResult>)((Handler)event -> {
                    if (event.isSuccess()) {
                        cReq.end(data);
                    } else if (this.isFailOnError()) {
                        req.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                        req.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                        if (event.getValidationDetails() != null) {
                            req.response().headers().add("content-type", "application/json");
                            req.response().end(event.getValidationDetails().encode());
                        } else {
                            req.response().end(event.getMessage());
                        }
                    } else {
                        log.warn(event.getMessage());
                        cReq.end(data);
                    }
                }));
            } else {
                cReq.end(data);
            }
        });
        cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)req.uri(), ValidationHandler.class));
    }

    public void handle(HttpServerRequest request) {
        this.handleValidation(request);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

