/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.validation;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.ValidationResource;
import org.swisspush.gateleen.validation.Validator;

public class ValidationResourceManager
implements LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.validation-updated";
    private final String validationUri;
    private final ResourceStorage storage;
    private final Logger log = LoggerFactory.getLogger(ValidationResourceManager.class);
    private final Vertx vertx;
    private ValidationResource validationResource;
    private String validationResourceSchema;
    private boolean logConfigurationResourceChanges = false;

    public ValidationResource getValidationResource() {
        if (this.validationResource == null) {
            this.validationResource = new ValidationResource();
        }
        return this.validationResource;
    }

    public ValidationResourceManager(Vertx vertx, ResourceStorage storage, String validationUri) {
        this.storage = storage;
        this.vertx = vertx;
        this.validationUri = validationUri;
        this.validationResourceSchema = ResourcesUtils.loadResource((String)"gateleen_validation_schema_validation", (boolean)true);
        this.updateValidationResource();
        vertx.eventBus().consumer(UPDATE_ADDRESS, event -> this.updateValidationResource());
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logConfigurationResourceChanges = resourceLoggingEnabled;
    }

    private void updateValidationResource() {
        this.storage.get(this.validationUri, buffer -> {
            if (buffer != null) {
                try {
                    this.updateValidationResource((Buffer)buffer);
                }
                catch (ValidationException e) {
                    this.log.warn("Could not reconfigure validation resource", (Throwable)e);
                }
            } else {
                this.log.warn("Could not get URL '" + (this.validationUri == null ? "<null>" : this.validationUri) + "'.");
            }
        });
    }

    private void updateValidationResource(Buffer buffer) throws ValidationException {
        this.extractValidationValues(buffer);
        for (Map<String, String> resourceToValidate : this.getValidationResource().getResources()) {
            this.log.info("Applying validation for resource: " + resourceToValidate);
        }
        if (this.getValidationResource().getResources().isEmpty()) {
            this.log.info("No validation rules to apply!");
        }
    }

    public boolean handleValidationResource(HttpServerRequest request) {
        if (request.uri().equals(this.validationUri) && HttpMethod.PUT == request.method()) {
            request.bodyHandler(validationResourceBuffer -> {
                try {
                    this.extractValidationValues((Buffer)validationResourceBuffer);
                }
                catch (ValidationException validationException) {
                    this.updateValidationResource();
                    this.log.error("Could not parse validation resource: " + validationException.toString());
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, ValidationResourceManager.class);
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                    if (validationException.getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(validationException.getValidationDetails().encode());
                    } else {
                        request.response().end(validationException.getMessage());
                    }
                    return;
                }
                this.storage.put(this.validationUri, validationResourceBuffer, status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        if (this.logConfigurationResourceChanges) {
                            RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)validationResourceBuffer);
                        }
                        this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                    } else {
                        request.response().setStatusCode(status.intValue());
                    }
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), ValidationResourceManager.class);
                    request.response().end();
                });
            });
            return true;
        }
        if (request.uri().equals(this.validationUri) && HttpMethod.DELETE == request.method()) {
            this.getValidationResource().reset();
            this.log.info("Reset ValidationResource");
        }
        return false;
    }

    private void extractValidationValues(Buffer validationResourceBuffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic(validationResourceBuffer, this.validationResourceSchema, this.log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        try {
            JsonObject validationRes = new JsonObject(validationResourceBuffer.toString("UTF-8"));
            this.getValidationResource().reset();
            JsonArray resourcesArray = validationRes.getJsonArray("resources");
            for (Object resourceEntry : resourcesArray) {
                JsonObject resJSO = (JsonObject)resourceEntry;
                HashMap<String, String> resProperties = new HashMap<String, String>();
                String url = resJSO.getString("url");
                resProperties.put("url", url);
                String method = resJSO.getString("method");
                if (!StringUtils.isEmpty((CharSequence)method)) {
                    resProperties.put("method", method);
                } else {
                    resProperties.put("method", "PUT");
                }
                JsonObject schemaObj = resJSO.getJsonObject("schema");
                if (schemaObj != null) {
                    Integer keepInMemory;
                    String schemaLocation = schemaObj.getString("location");
                    if (!StringUtils.isEmpty((CharSequence)schemaLocation)) {
                        resProperties.put("location", schemaLocation);
                    }
                    if ((keepInMemory = schemaObj.getInteger("keepInMemory")) != null) {
                        resProperties.put("keepInMemory", keepInMemory.toString());
                    }
                }
                this.getValidationResource().addResource(resProperties);
            }
        }
        catch (Exception ex) {
            this.getValidationResource().reset();
            throw new ValidationException(ex);
        }
    }
}

