/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.validation;

import io.vertx.core.http.HttpServerRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.swisspush.gateleen.validation.SchemaLocation;
import org.swisspush.gateleen.validation.ValidationResource;

public final class ValidationUtil {
    private ValidationUtil() {
    }

    public static Map<String, String> matchingValidationResourceEntry(ValidationResource validationResource, HttpServerRequest request, Logger log) {
        List<Map<String, String>> validationResources = validationResource.getResources();
        try {
            for (Map<String, String> entry : validationResources) {
                if (!ValidationUtil.doesRequestValueMatch(request.method().name(), entry.get("method")) || !ValidationUtil.doesRequestValueMatch(request.uri(), entry.get("url"))) continue;
                return entry;
            }
        }
        catch (PatternSyntaxException patternException) {
            log.error("{} {}", (Object)patternException.getMessage(), (Object)patternException.getPattern());
        }
        return null;
    }

    public static Optional<SchemaLocation> matchingSchemaLocation(ValidationResource validationResource, HttpServerRequest request, Logger log) {
        Map<String, String> entry = ValidationUtil.matchingValidationResourceEntry(validationResource, request, log);
        if (entry != null) {
            String location = entry.get("location");
            if (location == null) {
                return Optional.empty();
            }
            String keepInMemoryStr = entry.get("keepInMemory");
            Integer keepInMemory = null;
            if (keepInMemoryStr != null) {
                try {
                    keepInMemory = Integer.parseInt(keepInMemoryStr);
                }
                catch (NumberFormatException ex) {
                    log.warn("Property 'keepInMemory' is not a number but " + keepInMemoryStr, (Throwable)ex);
                }
            }
            return Optional.of(new SchemaLocation(location, keepInMemory));
        }
        return Optional.empty();
    }

    private static boolean doesRequestValueMatch(String value, String valuePattern) {
        Pattern pattern = Pattern.compile(valuePattern);
        Matcher matcher = pattern.matcher(value);
        return matcher.matches();
    }
}

