/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.validation;

import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.ClientRequestCreator;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.validation.SchemaLocation;
import org.swisspush.gateleen.validation.ValidationSchemaProvider;

public class DefaultValidationSchemaProvider
implements ValidationSchemaProvider {
    private final ClientRequestCreator clientRequestCreator;
    private final Logger log = LoggerFactory.getLogger(DefaultValidationSchemaProvider.class);
    private final Map<String, SchemaEntry> cachedSchemas;
    private final HeadersMultiMap defaultRequestHeaders;
    private static final int TIMEOUT_MS = 30000;
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String SELF_REQUEST_HEADER = "x-self-request";

    public DefaultValidationSchemaProvider(Vertx vertx, ClientRequestCreator clientRequestCreator, Duration cacheCleanupInterval) {
        this(vertx, clientRequestCreator, cacheCleanupInterval, new HashMap<String, String>());
    }

    public DefaultValidationSchemaProvider(Vertx vertx, ClientRequestCreator clientRequestCreator, Duration cacheCleanupInterval, Map<String, String> defaultRequestHeaders) {
        this.clientRequestCreator = clientRequestCreator;
        this.cachedSchemas = new HashMap<String, SchemaEntry>();
        this.defaultRequestHeaders = new HeadersMultiMap();
        this.defaultRequestHeaders.addAll(defaultRequestHeaders);
        vertx.setPeriodic(cacheCleanupInterval.toMillis(), event -> this.cleanupCachedSchemas());
    }

    private void cleanupCachedSchemas() {
        this.log.debug("About to clear cached schemas");
        this.cachedSchemas.entrySet().removeIf(entry -> ((SchemaEntry)entry.getValue()).expiration().isBefore(Instant.now()));
    }

    private HeadersMultiMap defaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    @Override
    public Future<Optional<JsonSchema>> schemaFromLocation(SchemaLocation schemaLocation) {
        Promise promise = Promise.promise();
        SchemaEntry schemaEntry = this.cachedSchemas.get(schemaLocation.schemaLocation());
        if (schemaEntry != null) {
            if (schemaEntry.expiration.isAfter(Instant.now())) {
                promise.complete(Optional.of(schemaEntry.jsonSchema()));
                return promise.future();
            }
            this.cachedSchemas.remove(schemaLocation.schemaLocation());
        }
        HeadersMultiMap headers = this.defaultRequestHeaders();
        headers.add("Accept", CONTENT_TYPE_JSON);
        headers.add(SELF_REQUEST_HEADER, "true");
        this.clientRequestCreator.createClientRequest(HttpMethod.GET, schemaLocation.schemaLocation(), headers, 30000L, event -> {
            this.log.warn("Got an error while fetching schema", event);
            promise.complete(Optional.empty());
        }).onComplete(asyncResult -> {
            HttpClientRequest fetchSchemaRequest = (HttpClientRequest)asyncResult.result();
            fetchSchemaRequest.setChunked(true);
            fetchSchemaRequest.send(responseAsyncResult -> {
                HttpClientResponse cRes = (HttpClientResponse)responseAsyncResult.result();
                cRes.bodyHandler(data -> {
                    if (StatusCode.OK.getStatusCode() == cRes.statusCode()) {
                        String contentType = cRes.getHeader(CONTENT_TYPE_HEADER);
                        if (contentType != null && !contentType.contains(CONTENT_TYPE_JSON)) {
                            this.log.warn("Content-Type {} is not supported", (Object)contentType);
                            promise.complete(Optional.empty());
                            return;
                        }
                        promise.complete(this.parseSchema(schemaLocation, (Buffer)data));
                    } else {
                        StatusCode statusCode = StatusCode.fromCode((int)cRes.statusCode());
                        if (statusCode != null) {
                            this.log.warn("Got status code {} while fetching schema", (Object)cRes.statusCode());
                        } else {
                            this.log.warn("Got unknown status code while fetching schema");
                        }
                        promise.complete(Optional.empty());
                    }
                });
            });
        });
        return promise.future();
    }

    private Optional<JsonSchema> parseSchema(SchemaLocation schemaLocation, Buffer data) {
        JsonSchema schema = null;
        try {
            schema = JsonSchemaFactory.getInstance().getSchema(data.toString());
            if (schemaLocation.keepInMemory() != null) {
                this.cachedSchemas.put(schemaLocation.schemaLocation(), new SchemaEntry(schema, Instant.now().plusSeconds(schemaLocation.keepInMemory().intValue())));
            }
        }
        catch (RuntimeException e) {
            this.log.warn("Error while parsing schema", (Throwable)e);
        }
        return Optional.ofNullable(schema);
    }

    private static class SchemaEntry {
        private final JsonSchema jsonSchema;
        private final Instant expiration;

        public SchemaEntry(JsonSchema jsonSchema, Instant expiration) {
            this.jsonSchema = jsonSchema;
            this.expiration = expiration;
        }

        public JsonSchema jsonSchema() {
            return this.jsonSchema;
        }

        public Instant expiration() {
            return this.expiration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaEntry that = (SchemaEntry)o;
            if (!this.jsonSchema.equals(that.jsonSchema)) {
                return false;
            }
            return this.expiration.equals(that.expiration);
        }

        public int hashCode() {
            int result = this.jsonSchema.hashCode();
            result = 31 * result + this.expiration.hashCode();
            return result;
        }
    }
}

