/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.validation;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpServerRequest;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.validation.ValidationResourceManager;
import org.swisspush.gateleen.validation.ValidationSchemaProvider;
import org.swisspush.gateleen.validation.ValidationUtil;
import org.swisspush.gateleen.validation.Validator;

public class ValidationHandler {
    public static final String HOOKS_LISTENERS_URI_PART = "/_hooks/listeners/";
    public static final String HOOKS_ROUTE_URI_PART = "/_hooks/route";
    public static final String ACCEPT = "accept";
    private HttpClient httpClient;
    private List<String> supportedMethods = Arrays.asList("PUT", "GET", "POST");
    private List<String> outMethods = Arrays.asList("GET", "POST");
    private List<String> inMethods = Arrays.asList("PUT", "POST");
    private static final String VALID_HEADER = "X-Valid";
    private static final String EXPAND_PARAM = "expand";
    private static final int TIMEOUT = 120000;
    private static final Pattern noExtension = Pattern.compile(".*/[^/\\.]*$");
    private Validator validator;
    private ValidationResourceManager validationResourceManager;
    private boolean failOnError = true;

    public ValidationHandler(ValidationResourceManager validationResourceManager, ValidationSchemaProvider validationSchemaProvider, ResourceStorage storage, HttpClient httpClient, String schemaRoot) {
        this.validationResourceManager = validationResourceManager;
        this.httpClient = httpClient;
        this.validator = new Validator(storage, schemaRoot, validationSchemaProvider);
    }

    public ValidationHandler(ValidationResourceManager validationResourceManager, HttpClient httpClient, Validator validator) {
        this.validationResourceManager = validationResourceManager;
        this.httpClient = httpClient;
        this.validator = validator;
    }

    public boolean isToValidate(HttpServerRequest request) {
        boolean doValidate;
        Logger log = RequestLoggerFactory.getLogger(ValidationHandler.class, (HttpServerRequest)request);
        boolean bl = doValidate = this.supportedMethods.contains(request.method().name()) && this.isJsonRequest(request) && !request.headers().names().contains(VALID_HEADER) && !request.params().names().contains(EXPAND_PARAM);
        if (!doValidate) {
            return false;
        }
        if (request.uri().contains(HOOKS_ROUTE_URI_PART) || request.uri().contains(HOOKS_LISTENERS_URI_PART)) {
            return false;
        }
        return ValidationUtil.matchingValidationResourceEntry(this.validationResourceManager.getValidationResource(), request, log) != null;
    }

    private boolean isJsonRequest(HttpServerRequest request) {
        boolean jsonRequest = request.headers().get(ACCEPT) != null && request.headers().get(ACCEPT).contains("application/json");
        jsonRequest |= request.headers().get(ACCEPT) != null && request.headers().get(ACCEPT).contains("text/plain");
        jsonRequest |= request.headers().get("content-type") != null && request.headers().get("content-type").contains("application/json");
        return jsonRequest |= noExtension.matcher(request.path()).matches();
    }

    private void handleValidation(HttpServerRequest req) {
        Logger log = RequestLoggerFactory.getLogger(ValidationHandler.class, (HttpServerRequest)req);
        this.httpClient.request(req.method(), req.uri()).onComplete(asyncReqResult -> {
            if (asyncReqResult.failed()) {
                log.warn("Failed request to {}: {}", (Object)req.uri(), (Object)asyncReqResult.cause());
                return;
            }
            HttpClientRequest cReq = (HttpClientRequest)asyncReqResult.result();
            cReq.idleTimeout(120000L);
            cReq.headers().setAll(req.headers());
            cReq.headers().set(VALID_HEADER, "0");
            Handler resultHandler = asyncResult -> {
                HttpClientResponse cRes = (HttpClientResponse)asyncResult.result();
                ResponseStatusCodeLogUtil.info((HttpServerRequest)req, (StatusCode)StatusCode.fromCode((int)cRes.statusCode()), ValidationHandler.class);
                req.response().setStatusCode(cRes.statusCode());
                req.response().setStatusMessage(cRes.statusMessage());
                req.response().headers().setAll(cRes.headers());
                cRes.bodyHandler(data -> {
                    if (req.response().getStatusCode() == StatusCode.OK.getStatusCode() && this.outMethods.contains(req.method().name()) && data.length() > 0) {
                        this.validator.validate(req, req.method() + "/out", (Buffer)data, ValidationUtil.matchingSchemaLocation(this.validationResourceManager.getValidationResource(), req, log).orElse(null), (Handler<ValidationResult>)((Handler)event -> {
                            if (event.isSuccess()) {
                                req.response().end(data);
                            } else {
                                if (this.isFailOnError()) {
                                    req.response().headers().clear();
                                    req.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                                    req.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                                    req.response().end();
                                } else {
                                    req.response().end(data);
                                }
                                log.warn(event.getMessage());
                            }
                        }));
                    } else {
                        req.response().end(data);
                    }
                });
                cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)req, (String)req.uri(), ValidationHandler.class));
            };
            req.bodyHandler(data -> {
                if (this.inMethods.contains(req.method().name())) {
                    this.validator.validate(req, req.method() + "/in", (Buffer)data, ValidationUtil.matchingSchemaLocation(this.validationResourceManager.getValidationResource(), req, log).orElse(null), (Handler<ValidationResult>)((Handler)event -> {
                        if (event.isSuccess()) {
                            cReq.end(data);
                        } else if (this.isFailOnError()) {
                            req.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                            req.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                            if (event.getValidationDetails() != null) {
                                req.response().headers().add("content-type", "application/json");
                                req.response().end(event.getValidationDetails().encode());
                            } else {
                                req.response().end(event.getMessage());
                            }
                        } else {
                            log.warn(event.getMessage());
                            cReq.end(data);
                        }
                    }));
                } else {
                    cReq.end(data);
                }
            });
            cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)req.uri(), ValidationHandler.class));
        });
    }

    public void handle(HttpServerRequest request) {
        this.handleValidation(request);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

