package org.swisspush.kobuka.client.base;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AbstractCommonClientConfigBuilder<T extends AbstractCommonClientConfigBuilder<T>> implements CommonClientConfigFields<T> {
  Map<String, Object> configs = new HashMap<>();

  public T bootstrapServers(List<String> value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T bootstrapServers(String value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T clientId(String value) {
    configs.put("client.id", value);
    return self();
  }

  public T metadataMaxAgeMs(Long value) {
    configs.put("metadata.max.age.ms", value);
    return self();
  }

  public T sendBufferBytes(Integer value) {
    configs.put("send.buffer.bytes", value);
    return self();
  }

  public T receiveBufferBytes(Integer value) {
    configs.put("receive.buffer.bytes", value);
    return self();
  }

  public T reconnectBackoffMs(Long value) {
    configs.put("reconnect.backoff.ms", value);
    return self();
  }

  public T reconnectBackoffMaxMs(Long value) {
    configs.put("reconnect.backoff.max.ms", value);
    return self();
  }

  public T retryBackoffMs(Long value) {
    configs.put("retry.backoff.ms", value);
    return self();
  }

  public T requestTimeoutMs(Integer value) {
    configs.put("request.timeout.ms", value);
    return self();
  }

  public T connectionsMaxIdleMs(Long value) {
    configs.put("connections.max.idle.ms", value);
    return self();
  }

  public T metricsSampleWindowMs(Long value) {
    configs.put("metrics.sample.window.ms", value);
    return self();
  }

  public T metricsNumSamples(Integer value) {
    configs.put("metrics.num.samples", value);
    return self();
  }

  public T metricReporters(List<String> value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T metricReporters(String value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T metricsRecordingLevel(String value) {
    configs.put("metrics.recording.level", value);
    return self();
  }

  public T securityProtocol(String value) {
    configs.put("security.protocol", value);
    return self();
  }
}
