package org.swisspush.kobuka.client.base;

import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AbstractStreamsConfigBuilder<T extends AbstractStreamsConfigBuilder<T>> implements StreamsConfigFields<T> {
  Map<String, Object> configs = new HashMap<>();

  public T applicationId(String value) {
    configs.put("application.id", value);
    return self();
  }

  public T bootstrapServers(List<String> value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T bootstrapServers(String value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T numStandbyReplicas(Integer value) {
    configs.put("num.standby.replicas", value);
    return self();
  }

  public T stateDir(String value) {
    configs.put("state.dir", value);
    return self();
  }

  public T acceptableRecoveryLag(Long value) {
    configs.put("acceptable.recovery.lag", value);
    return self();
  }

  public T cacheMaxBytesBuffering(Long value) {
    configs.put("cache.max.bytes.buffering", value);
    return self();
  }

  public T clientId(String value) {
    configs.put("client.id", value);
    return self();
  }

  public T defaultDeserializationExceptionHandler(Class value) {
    configs.put("default.deserialization.exception.handler", value);
    return self();
  }

  public T defaultKeySerde(Class value) {
    configs.put("default.key.serde", value);
    return self();
  }

  public T defaultListKeySerdeInner(Class value) {
    configs.put("default.list.key.serde.inner", value);
    return self();
  }

  public T defaultListValueSerdeInner(Class value) {
    configs.put("default.list.value.serde.inner", value);
    return self();
  }

  public T defaultListKeySerdeType(Class value) {
    configs.put("default.list.key.serde.type", value);
    return self();
  }

  public T defaultListValueSerdeType(Class value) {
    configs.put("default.list.value.serde.type", value);
    return self();
  }

  public T defaultProductionExceptionHandler(Class value) {
    configs.put("default.production.exception.handler", value);
    return self();
  }

  public T defaultTimestampExtractor(Class value) {
    configs.put("default.timestamp.extractor", value);
    return self();
  }

  public T defaultValueSerde(Class value) {
    configs.put("default.value.serde", value);
    return self();
  }

  public T maxTaskIdleMs(Long value) {
    configs.put("max.task.idle.ms", value);
    return self();
  }

  public T maxWarmupReplicas(Integer value) {
    configs.put("max.warmup.replicas", value);
    return self();
  }

  public T numStreamThreads(Integer value) {
    configs.put("num.stream.threads", value);
    return self();
  }

  public T processingGuarantee(String value) {
    configs.put("processing.guarantee", value);
    return self();
  }

  public T rackAwareAssignmentTags(List<String> value) {
    configs.put("rack.aware.assignment.tags", value);
    return self();
  }

  public T rackAwareAssignmentTags(String value) {
    configs.put("rack.aware.assignment.tags", value);
    return self();
  }

  public T replicationFactor(Integer value) {
    configs.put("replication.factor", value);
    return self();
  }

  public T securityProtocol(String value) {
    configs.put("security.protocol", value);
    return self();
  }

  public T taskTimeoutMs(Long value) {
    configs.put("task.timeout.ms", value);
    return self();
  }

  public T topologyOptimization(String value) {
    configs.put("topology.optimization", value);
    return self();
  }

  public T applicationServer(String value) {
    configs.put("application.server", value);
    return self();
  }

  public T bufferedRecordsPerPartition(Integer value) {
    configs.put("buffered.records.per.partition", value);
    return self();
  }

  public T builtInMetricsVersion(String value) {
    configs.put("built.in.metrics.version", value);
    return self();
  }

  public T commitIntervalMs(Long value) {
    configs.put("commit.interval.ms", value);
    return self();
  }

  public T repartitionPurgeIntervalMs(Long value) {
    configs.put("repartition.purge.interval.ms", value);
    return self();
  }

  public T connectionsMaxIdleMs(Long value) {
    configs.put("connections.max.idle.ms", value);
    return self();
  }

  public T defaultDslStore(String value) {
    configs.put("default.dsl.store", value);
    return self();
  }

  public T metadataMaxAgeMs(Long value) {
    configs.put("metadata.max.age.ms", value);
    return self();
  }

  public T metricsNumSamples(Integer value) {
    configs.put("metrics.num.samples", value);
    return self();
  }

  public T metricReporters(List<String> value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T metricReporters(String value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T metricsRecordingLevel(String value) {
    configs.put("metrics.recording.level", value);
    return self();
  }

  public T metricsSampleWindowMs(Long value) {
    configs.put("metrics.sample.window.ms", value);
    return self();
  }

  public T pollMs(Long value) {
    configs.put("poll.ms", value);
    return self();
  }

  public T probingRebalanceIntervalMs(Long value) {
    configs.put("probing.rebalance.interval.ms", value);
    return self();
  }

  public T receiveBufferBytes(Integer value) {
    configs.put("receive.buffer.bytes", value);
    return self();
  }

  public T reconnectBackoffMs(Long value) {
    configs.put("reconnect.backoff.ms", value);
    return self();
  }

  public T reconnectBackoffMaxMs(Long value) {
    configs.put("reconnect.backoff.max.ms", value);
    return self();
  }

  public T retries(Integer value) {
    configs.put("retries", value);
    return self();
  }

  public T retryBackoffMs(Long value) {
    configs.put("retry.backoff.ms", value);
    return self();
  }

  public T requestTimeoutMs(Integer value) {
    configs.put("request.timeout.ms", value);
    return self();
  }

  public T rocksdbConfigSetter(Class value) {
    configs.put("rocksdb.config.setter", value);
    return self();
  }

  public T sendBufferBytes(Integer value) {
    configs.put("send.buffer.bytes", value);
    return self();
  }

  public T stateCleanupDelayMs(Long value) {
    configs.put("state.cleanup.delay.ms", value);
    return self();
  }

  public T upgradeFrom(String value) {
    configs.put("upgrade.from", value);
    return self();
  }

  public T windowedInnerClassSerde(String value) {
    configs.put("windowed.inner.class.serde", value);
    return self();
  }

  public T windowstoreChangelogAdditionalRetentionMs(Long value) {
    configs.put("windowstore.changelog.additional.retention.ms", value);
    return self();
  }

  public T windowSizeMs(Long value) {
    configs.put("window.size.ms", value);
    return self();
  }
}
