package org.swisspush.kobuka.client.base;

import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.util.List;

public interface CommonClientConfigFields<T extends CommonClientConfigFields<T>> {
  /**
   * <b>bootstrap.servers</b><p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<p>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<p>This list should be in the form <code>host1:port1,host2:port2,...</code>.<p>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> 
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> high
   */
  T bootstrapServers(List<String> value);

  /**
   * <b>bootstrap.servers</b><p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<p>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<p>This list should be in the form <code>host1:port1,host2:port2,...</code>.<p>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> 
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> high
   */
  T bootstrapServers(String value);

  /**
   * <b>client.id</b><p>
   * An id string to pass to the server when making requests.<p>The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.
   * <p><b>Default:</b> ""
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> medium
   */
  T clientId(String value);

  /**
   * <b>metadata.max.age.ms</b><p>
   * The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.
   * <p><b>Default:</b> 300000 (5 minutes)
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> low
   */
  T metadataMaxAgeMs(Long value);

  /**
   * <b>send.buffer.bytes</b><p>
   * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.<p>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 131072 (128 kibibytes)
   * <p><b>Valid Values:</b> [-1,...]
   * <p><b>Importance:</b> medium
   */
  T sendBufferBytes(Integer value);

  /**
   * <b>receive.buffer.bytes</b><p>
   * The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.<p>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 65536 (64 kibibytes)
   * <p><b>Valid Values:</b> [-1,...]
   * <p><b>Importance:</b> medium
   */
  T receiveBufferBytes(Integer value);

  /**
   * <b>reconnect.backoff.ms</b><p>
   * The base amount of time to wait before attempting to reconnect to a given host.<p>This avoids repeatedly connecting to a host in a tight loop.<p>This backoff applies to all connection attempts by the client to a broker.
   * <p><b>Default:</b> 50
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> low
   */
  T reconnectBackoffMs(Long value);

  /**
   * <b>reconnect.backoff.max.ms</b><p>
   * The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect.<p>If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum.<p>After calculating the backoff increase, 20% random jitter is added to avoid connection storms.
   * <p><b>Default:</b> 1000 (1 second)
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> low
   */
  T reconnectBackoffMaxMs(Long value);

  /**
   * <b>retry.backoff.ms</b><p>
   * The amount of time to wait before attempting to retry a failed request.<p>This avoids repeatedly sending requests in a tight loop under some failure scenarios.
   * <p><b>Default:</b> 100
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> low
   */
  T retryBackoffMs(Long value);

  /**
   * <b>request.timeout.ms</b><p>
   * The configuration controls the maximum amount of time the client will wait for the response of a request.<p>If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.
   * <p><b>Default:</b> 30000 (30 seconds)
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> medium
   */
  T requestTimeoutMs(Integer value);

  /**
   * <b>connections.max.idle.ms</b><p>
   * Close idle connections after the number of milliseconds specified by this config.
   * <p><b>Default:</b> 300000 (5 minutes)
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> medium
   */
  T connectionsMaxIdleMs(Long value);

  /**
   * <b>metrics.sample.window.ms</b><p>
   * The window of time a metrics sample is computed over.
   * <p><b>Default:</b> 30000 (30 seconds)
   * <p><b>Valid Values:</b> [0,...]
   * <p><b>Importance:</b> low
   */
  T metricsSampleWindowMs(Long value);

  /**
   * <b>metrics.num.samples</b><p>
   * The number of samples maintained to compute metrics.
   * <p><b>Default:</b> 2
   * <p><b>Valid Values:</b> [1,...]
   * <p><b>Importance:</b> low
   */
  T metricsNumSamples(Integer value);

  /**
   * <b>metric.reporters</b><p>
   * A list of classes to use as metrics reporters.<p>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<p>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> low
   */
  T metricReporters(List<String> value);

  /**
   * <b>metric.reporters</b><p>
   * A list of classes to use as metrics reporters.<p>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<p>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> low
   */
  T metricReporters(String value);

  /**
   * <b>metrics.recording.level</b><p>
   * The highest recording level for metrics.
   * <p><b>Default:</b> INFO
   * <p><b>Valid Values:</b> [INFO, DEBUG, TRACE]
   * <p><b>Importance:</b> low
   */
  T metricsRecordingLevel(String value);

  /**
   * <b>security.protocol</b><p>
   * Protocol used to communicate with brokers.<p>Valid values are: PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
   * <p><b>Default:</b> PLAINTEXT
   * <p><b>Valid Values:</b> 
   * <p><b>Importance:</b> medium
   */
  T securityProtocol(String value);

  default T self() {
    return (T)this;
  }
}
