package org.swisspush.kobuka.client.base;

import java.lang.Boolean;
import java.lang.Class;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Short;
import java.lang.String;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.types.Password;

class AbstractProducerConfigBuilder<T extends AbstractProducerConfigBuilder<T>> implements ProducerConfigFields<T> {
  Map<String, Object> configs = new HashMap<>();

  public T bootstrapServers(List<String> value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T bootstrapServers(String value) {
    configs.put("bootstrap.servers", value);
    return self();
  }

  public T clientDnsLookup(String value) {
    configs.put("client.dns.lookup", value);
    return self();
  }

  public T bufferMemory(Long value) {
    configs.put("buffer.memory", value);
    return self();
  }

  public T retries(Integer value) {
    configs.put("retries", value);
    return self();
  }

  public T acks(String value) {
    configs.put("acks", value);
    return self();
  }

  public T compressionType(String value) {
    configs.put("compression.type", value);
    return self();
  }

  public T batchSize(Integer value) {
    configs.put("batch.size", value);
    return self();
  }

  public T partitionerAdaptivePartitioningEnable(Boolean value) {
    configs.put("partitioner.adaptive.partitioning.enable", value);
    return self();
  }

  public T partitionerAvailabilityTimeoutMs(Long value) {
    configs.put("partitioner.availability.timeout.ms", value);
    return self();
  }

  public T partitionerIgnoreKeys(Boolean value) {
    configs.put("partitioner.ignore.keys", value);
    return self();
  }

  public T lingerMs(Long value) {
    configs.put("linger.ms", value);
    return self();
  }

  public T deliveryTimeoutMs(Integer value) {
    configs.put("delivery.timeout.ms", value);
    return self();
  }

  public T clientId(String value) {
    configs.put("client.id", value);
    return self();
  }

  public T sendBufferBytes(Integer value) {
    configs.put("send.buffer.bytes", value);
    return self();
  }

  public T receiveBufferBytes(Integer value) {
    configs.put("receive.buffer.bytes", value);
    return self();
  }

  public T maxRequestSize(Integer value) {
    configs.put("max.request.size", value);
    return self();
  }

  public T reconnectBackoffMs(Long value) {
    configs.put("reconnect.backoff.ms", value);
    return self();
  }

  public T reconnectBackoffMaxMs(Long value) {
    configs.put("reconnect.backoff.max.ms", value);
    return self();
  }

  public T retryBackoffMs(Long value) {
    configs.put("retry.backoff.ms", value);
    return self();
  }

  public T maxBlockMs(Long value) {
    configs.put("max.block.ms", value);
    return self();
  }

  public T requestTimeoutMs(Integer value) {
    configs.put("request.timeout.ms", value);
    return self();
  }

  public T metadataMaxAgeMs(Long value) {
    configs.put("metadata.max.age.ms", value);
    return self();
  }

  public T metadataMaxIdleMs(Long value) {
    configs.put("metadata.max.idle.ms", value);
    return self();
  }

  public T metricsSampleWindowMs(Long value) {
    configs.put("metrics.sample.window.ms", value);
    return self();
  }

  public T metricsNumSamples(Integer value) {
    configs.put("metrics.num.samples", value);
    return self();
  }

  public T metricsRecordingLevel(String value) {
    configs.put("metrics.recording.level", value);
    return self();
  }

  public T metricReporters(List<String> value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T metricReporters(String value) {
    configs.put("metric.reporters", value);
    return self();
  }

  public T maxInFlightRequestsPerConnection(Integer value) {
    configs.put("max.in.flight.requests.per.connection", value);
    return self();
  }

  public T keySerializer(Class value) {
    configs.put("key.serializer", value);
    return self();
  }

  public T valueSerializer(Class value) {
    configs.put("value.serializer", value);
    return self();
  }

  public T socketConnectionSetupTimeoutMs(Long value) {
    configs.put("socket.connection.setup.timeout.ms", value);
    return self();
  }

  public T socketConnectionSetupTimeoutMaxMs(Long value) {
    configs.put("socket.connection.setup.timeout.max.ms", value);
    return self();
  }

  public T connectionsMaxIdleMs(Long value) {
    configs.put("connections.max.idle.ms", value);
    return self();
  }

  public T partitionerClass(Class value) {
    configs.put("partitioner.class", value);
    return self();
  }

  public T interceptorClasses(List<String> value) {
    configs.put("interceptor.classes", value);
    return self();
  }

  public T interceptorClasses(String value) {
    configs.put("interceptor.classes", value);
    return self();
  }

  public T securityProtocol(String value) {
    configs.put("security.protocol", value);
    return self();
  }

  public T securityProviders(String value) {
    configs.put("security.providers", value);
    return self();
  }

  public T sslProtocol(String value) {
    configs.put("ssl.protocol", value);
    return self();
  }

  public T sslProvider(String value) {
    configs.put("ssl.provider", value);
    return self();
  }

  public T sslCipherSuites(List<String> value) {
    configs.put("ssl.cipher.suites", value);
    return self();
  }

  public T sslCipherSuites(String value) {
    configs.put("ssl.cipher.suites", value);
    return self();
  }

  public T sslEnabledProtocols(List<String> value) {
    configs.put("ssl.enabled.protocols", value);
    return self();
  }

  public T sslEnabledProtocols(String value) {
    configs.put("ssl.enabled.protocols", value);
    return self();
  }

  public T sslKeystoreType(String value) {
    configs.put("ssl.keystore.type", value);
    return self();
  }

  public T sslKeystoreLocation(String value) {
    configs.put("ssl.keystore.location", value);
    return self();
  }

  public T sslKeystorePassword(Password value) {
    configs.put("ssl.keystore.password", value);
    return self();
  }

  public T sslKeystorePassword(String value) {
    configs.put("ssl.keystore.password", value);
    return self();
  }

  public T sslKeyPassword(Password value) {
    configs.put("ssl.key.password", value);
    return self();
  }

  public T sslKeyPassword(String value) {
    configs.put("ssl.key.password", value);
    return self();
  }

  public T sslKeystoreKey(Password value) {
    configs.put("ssl.keystore.key", value);
    return self();
  }

  public T sslKeystoreKey(String value) {
    configs.put("ssl.keystore.key", value);
    return self();
  }

  public T sslKeystoreCertificateChain(Password value) {
    configs.put("ssl.keystore.certificate.chain", value);
    return self();
  }

  public T sslKeystoreCertificateChain(String value) {
    configs.put("ssl.keystore.certificate.chain", value);
    return self();
  }

  public T sslTruststoreCertificates(Password value) {
    configs.put("ssl.truststore.certificates", value);
    return self();
  }

  public T sslTruststoreCertificates(String value) {
    configs.put("ssl.truststore.certificates", value);
    return self();
  }

  public T sslTruststoreType(String value) {
    configs.put("ssl.truststore.type", value);
    return self();
  }

  public T sslTruststoreLocation(String value) {
    configs.put("ssl.truststore.location", value);
    return self();
  }

  public T sslTruststorePassword(Password value) {
    configs.put("ssl.truststore.password", value);
    return self();
  }

  public T sslTruststorePassword(String value) {
    configs.put("ssl.truststore.password", value);
    return self();
  }

  public T sslKeymanagerAlgorithm(String value) {
    configs.put("ssl.keymanager.algorithm", value);
    return self();
  }

  public T sslTrustmanagerAlgorithm(String value) {
    configs.put("ssl.trustmanager.algorithm", value);
    return self();
  }

  public T sslEndpointIdentificationAlgorithm(String value) {
    configs.put("ssl.endpoint.identification.algorithm", value);
    return self();
  }

  public T sslSecureRandomImplementation(String value) {
    configs.put("ssl.secure.random.implementation", value);
    return self();
  }

  public T sslEngineFactoryClass(Class value) {
    configs.put("ssl.engine.factory.class", value);
    return self();
  }

  public T saslKerberosServiceName(String value) {
    configs.put("sasl.kerberos.service.name", value);
    return self();
  }

  public T saslKerberosKinitCmd(String value) {
    configs.put("sasl.kerberos.kinit.cmd", value);
    return self();
  }

  public T saslKerberosTicketRenewWindowFactor(Double value) {
    configs.put("sasl.kerberos.ticket.renew.window.factor", value);
    return self();
  }

  public T saslKerberosTicketRenewJitter(Double value) {
    configs.put("sasl.kerberos.ticket.renew.jitter", value);
    return self();
  }

  public T saslKerberosMinTimeBeforeRelogin(Long value) {
    configs.put("sasl.kerberos.min.time.before.relogin", value);
    return self();
  }

  public T saslLoginRefreshWindowFactor(Double value) {
    configs.put("sasl.login.refresh.window.factor", value);
    return self();
  }

  public T saslLoginRefreshWindowJitter(Double value) {
    configs.put("sasl.login.refresh.window.jitter", value);
    return self();
  }

  public T saslLoginRefreshMinPeriodSeconds(Short value) {
    configs.put("sasl.login.refresh.min.period.seconds", value);
    return self();
  }

  public T saslLoginRefreshBufferSeconds(Short value) {
    configs.put("sasl.login.refresh.buffer.seconds", value);
    return self();
  }

  public T saslMechanism(String value) {
    configs.put("sasl.mechanism", value);
    return self();
  }

  public T saslJaasConfig(Password value) {
    configs.put("sasl.jaas.config", value);
    return self();
  }

  public T saslJaasConfig(String value) {
    configs.put("sasl.jaas.config", value);
    return self();
  }

  public T saslClientCallbackHandlerClass(Class value) {
    configs.put("sasl.client.callback.handler.class", value);
    return self();
  }

  public T saslLoginCallbackHandlerClass(Class value) {
    configs.put("sasl.login.callback.handler.class", value);
    return self();
  }

  public T saslLoginClass(Class value) {
    configs.put("sasl.login.class", value);
    return self();
  }

  public T saslLoginConnectTimeoutMs(Integer value) {
    configs.put("sasl.login.connect.timeout.ms", value);
    return self();
  }

  public T saslLoginReadTimeoutMs(Integer value) {
    configs.put("sasl.login.read.timeout.ms", value);
    return self();
  }

  public T saslLoginRetryBackoffMaxMs(Long value) {
    configs.put("sasl.login.retry.backoff.max.ms", value);
    return self();
  }

  public T saslLoginRetryBackoffMs(Long value) {
    configs.put("sasl.login.retry.backoff.ms", value);
    return self();
  }

  public T saslOauthbearerScopeClaimName(String value) {
    configs.put("sasl.oauthbearer.scope.claim.name", value);
    return self();
  }

  public T saslOauthbearerSubClaimName(String value) {
    configs.put("sasl.oauthbearer.sub.claim.name", value);
    return self();
  }

  public T saslOauthbearerTokenEndpointUrl(String value) {
    configs.put("sasl.oauthbearer.token.endpoint.url", value);
    return self();
  }

  public T saslOauthbearerJwksEndpointUrl(String value) {
    configs.put("sasl.oauthbearer.jwks.endpoint.url", value);
    return self();
  }

  public T saslOauthbearerJwksEndpointRefreshMs(Long value) {
    configs.put("sasl.oauthbearer.jwks.endpoint.refresh.ms", value);
    return self();
  }

  public T saslOauthbearerJwksEndpointRetryBackoffMaxMs(Long value) {
    configs.put("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms", value);
    return self();
  }

  public T saslOauthbearerJwksEndpointRetryBackoffMs(Long value) {
    configs.put("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms", value);
    return self();
  }

  public T saslOauthbearerClockSkewSeconds(Integer value) {
    configs.put("sasl.oauthbearer.clock.skew.seconds", value);
    return self();
  }

  public T saslOauthbearerExpectedAudience(List<String> value) {
    configs.put("sasl.oauthbearer.expected.audience", value);
    return self();
  }

  public T saslOauthbearerExpectedAudience(String value) {
    configs.put("sasl.oauthbearer.expected.audience", value);
    return self();
  }

  public T saslOauthbearerExpectedIssuer(String value) {
    configs.put("sasl.oauthbearer.expected.issuer", value);
    return self();
  }

  public T enableIdempotence(Boolean value) {
    configs.put("enable.idempotence", value);
    return self();
  }

  public T transactionTimeoutMs(Integer value) {
    configs.put("transaction.timeout.ms", value);
    return self();
  }

  public T transactionalId(String value) {
    configs.put("transactional.id", value);
    return self();
  }
}
