package org.swisspush.kobuka.client.base;

import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.util.List;

public interface CommonClientConfigFields<T extends CommonClientConfigFields<T>> {
  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(List<String> value);

  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(String value);

  /**
   * <p><b>client.id</b></p>
   * An id string to pass to the server when making requests.<br>The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T clientId(String value);

  /**
   * <p><b>metadata.max.age.ms</b></p>
   * The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metadataMaxAgeMs(Long value);

  /**
   * <p><b>send.buffer.bytes</b></p>
   * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 131072 (128 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T sendBufferBytes(Integer value);

  /**
   * <p><b>receive.buffer.bytes</b></p>
   * The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 65536 (64 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T receiveBufferBytes(Integer value);

  /**
   * <p><b>reconnect.backoff.ms</b></p>
   * The base amount of time to wait before attempting to reconnect to a given host.<br>This avoids repeatedly connecting to a host in a tight loop.<br>This backoff applies to all connection attempts by the client to a broker.
   * <p><b>Default:</b> 50</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMs(Long value);

  /**
   * <p><b>reconnect.backoff.max.ms</b></p>
   * The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect.<br>If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum.<br>After calculating the backoff increase, 20% random jitter is added to avoid connection storms.
   * <p><b>Default:</b> 1000 (1 second)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMaxMs(Long value);

  /**
   * <p><b>retry.backoff.ms</b></p>
   * The amount of time to wait before attempting to retry a failed request.<br>This avoids repeatedly sending requests in a tight loop under some failure scenarios.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T retryBackoffMs(Long value);

  /**
   * <p><b>request.timeout.ms</b></p>
   * The configuration controls the maximum amount of time the client will wait for the response of a request.<br>If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T requestTimeoutMs(Integer value);

  /**
   * <p><b>connections.max.idle.ms</b></p>
   * Close idle connections after the number of milliseconds specified by this config.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T connectionsMaxIdleMs(Long value);

  /**
   * <p><b>metrics.sample.window.ms</b></p>
   * The window of time a metrics sample is computed over.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsSampleWindowMs(Long value);

  /**
   * <p><b>metrics.num.samples</b></p>
   * The number of samples maintained to compute metrics.
   * <p><b>Default:</b> 2</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsNumSamples(Integer value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(List<String> value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(String value);

  /**
   * <p><b>metrics.recording.level</b></p>
   * The highest recording level for metrics.
   * <p><b>Default:</b> INFO</p>
   * <p><b>Valid Values:</b> [INFO, DEBUG, TRACE]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsRecordingLevel(String value);

  /**
   * <p><b>security.protocol</b></p>
   * Protocol used to communicate with brokers.<br>Valid values are: PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
   * <p><b>Default:</b> PLAINTEXT</p>
   * <p><b>Valid Values:</b> [PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T securityProtocol(String value);

  default T self() {
    return (T)this;
  }
}
