package org.swisspush.kobuka.client.base;

import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.util.List;

public interface StreamsConfigFields<T extends StreamsConfigFields<T>> {
  /**
   * <p><b>application.id</b></p>
   * An identifier for the stream processing application.<br>Must be unique within the Kafka cluster.<br>It is used as 1) the default client-id prefix, 2) the group-id for membership management, 3) the changelog topic prefix.
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T applicationId(String value);

  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(List<String> value);

  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(String value);

  /**
   * <p><b>num.standby.replicas</b></p>
   * The number of standby replicas for each task.
   * <p><b>Default:</b> 0</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T numStandbyReplicas(Integer value);

  /**
   * <p><b>state.dir</b></p>
   * Directory location for state store.<br>This path must be unique for each streams instance sharing the same underlying filesystem.
   * <p><b>Default:</b> /tmp/kafka-streams</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T stateDir(String value);

  /**
   * <p><b>acceptable.recovery.lag</b></p>
   * The maximum acceptable lag (number of offsets to catch up) for a client to be considered caught-up enough to receive an active task assignment.<br>Upon assignment, it will still restore the rest of the changelog before processing.<br>To avoid a pause in processing during rebalances, this config should correspond to a recovery time of well under a minute for a given workload.<br>Must be at least 0.
   * <p><b>Default:</b> 10000</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T acceptableRecoveryLag(Long value);

  /**
   * <p><b>cache.max.bytes.buffering</b></p>
   * Maximum number of memory bytes to be used for buffering across all threads
   * <p><b>Default:</b> 10485760</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T cacheMaxBytesBuffering(Long value);

  /**
   * <p><b>client.id</b></p>
   * An ID prefix string used for the client IDs of internal consumer, producer and restore-consumer, with pattern '<client.id>-StreamThread-<threadSequenceNumber>-<consumer|producer|restore-consumer>'.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T clientId(String value);

  /**
   * <p><b>default.deserialization.exception.handler</b></p>
   * Exception handling class that implements the <code>org.apache.kafka.streams.errors.DeserializationExceptionHandler</code> interface.
   * <p><b>Default:</b> org.apache.kafka.streams.errors.LogAndFailExceptionHandler</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultDeserializationExceptionHandler(Class value);

  /**
   * <p><b>default.key.serde</b></p>
   *  Default serializer / deserializer class for key that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface.<br>Note when windowed serde class is used, one needs to set the inner serde class that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface via 'default.windowed.key.serde.inner' or 'default.windowed.value.serde.inner' as well
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultKeySerde(Class value);

  /**
   * <p><b>default.list.key.serde.inner</b></p>
   * Default inner class of list serde for key that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface.<br>This configuration will be read if and only if <code>default.key.serde</code> configuration is set to <code>org.apache.kafka.common.serialization.Serdes.ListSerde</code>
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultListKeySerdeInner(Class value);

  /**
   * <p><b>default.list.value.serde.inner</b></p>
   * Default inner class of list serde for value that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface.<br>This configuration will be read if and only if <code>default.value.serde</code> configuration is set to <code>org.apache.kafka.common.serialization.Serdes.ListSerde</code>
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultListValueSerdeInner(Class value);

  /**
   * <p><b>default.list.key.serde.type</b></p>
   * Default class for key that implements the <code>java.util.List</code> interface.<br>This configuration will be read if and only if <code>default.key.serde</code> configuration is set to <code>org.apache.kafka.common.serialization.Serdes.ListSerde</code> Note when list serde class is used, one needs to set the inner serde class that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface via 'default.list.key.serde.inner'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultListKeySerdeType(Class value);

  /**
   * <p><b>default.list.value.serde.type</b></p>
   * Default class for value that implements the <code>java.util.List</code> interface.<br>This configuration will be read if and only if <code>default.value.serde</code> configuration is set to <code>org.apache.kafka.common.serialization.Serdes.ListSerde</code> Note when list serde class is used, one needs to set the inner serde class that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface via 'default.list.value.serde.inner'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultListValueSerdeType(Class value);

  /**
   * <p><b>default.production.exception.handler</b></p>
   * Exception handling class that implements the <code>org.apache.kafka.streams.errors.ProductionExceptionHandler</code> interface.
   * <p><b>Default:</b> org.apache.kafka.streams.errors.DefaultProductionExceptionHandler</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultProductionExceptionHandler(Class value);

  /**
   * <p><b>default.timestamp.extractor</b></p>
   * Default timestamp extractor class that implements the <code>org.apache.kafka.streams.processor.TimestampExtractor</code> interface.
   * <p><b>Default:</b> org.apache.kafka.streams.processor.FailOnInvalidTimestamp</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultTimestampExtractor(Class value);

  /**
   * <p><b>default.value.serde</b></p>
   * Default serializer / deserializer class for value that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface.<br>Note when windowed serde class is used, one needs to set the inner serde class that implements the <code>org.apache.kafka.common.serialization.Serde</code> interface via 'default.windowed.key.serde.inner' or 'default.windowed.value.serde.inner' as well
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T defaultValueSerde(Class value);

  /**
   * <p><b>max.task.idle.ms</b></p>
   * This config controls whether joins and merges may produce out-of-order results.<br>The config value is the maximum amount of time in milliseconds a stream task will stay idle when it is fully caught up on some (but not all) input partitions to wait for producers to send additional records and avoid potential out-of-order record processing across multiple input streams.<br>The default (zero) does not wait for producers to send more records, but it does wait to fetch data that is already present on the brokers.<br>This default means that for records that are already present on the brokers, Streams will process them in timestamp order.<br>Set to -1 to disable idling entirely and process any locally available data, even though doing so may produce out-of-order processing.
   * <p><b>Default:</b> 0</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T maxTaskIdleMs(Long value);

  /**
   * <p><b>max.warmup.replicas</b></p>
   * The maximum number of warmup replicas (extra standbys beyond the configured num.standbys) that can be assigned at once for the purpose of keeping  the task available on one instance while it is warming up on another instance it has been reassigned to.<br>Used to throttle how much extra broker  traffic and cluster state can be used for high availability.<br>Must be at least 1.
   * <p><b>Default:</b> 2</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T maxWarmupReplicas(Integer value);

  /**
   * <p><b>num.stream.threads</b></p>
   * The number of threads to execute stream processing.
   * <p><b>Default:</b> 1</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T numStreamThreads(Integer value);

  /**
   * <p><b>processing.guarantee</b></p>
   * The processing guarantee that should be used.<br>Possible values are <code>at_least_once</code> (default) and <code>exactly_once_v2</code> (requires brokers version 2.5 or higher).<br>Deprecated options are <code>exactly_once</code> (requires brokers version 0.11.0 or higher) and <code>exactly_once_beta</code> (requires brokers version 2.5 or higher).<br>Note that exactly-once processing requires a cluster of at least three brokers by default what is the recommended setting for production; for development you can change this, by adjusting broker setting <code>transaction.state.log.replication.factor</code> and <code>transaction.state.log.min.isr</code>.
   * <p><b>Default:</b> at_least_once</p>
   * <p><b>Valid Values:</b> [at_least_once, exactly_once, exactly_once_beta, exactly_once_v2]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T processingGuarantee(String value);

  /**
   * <p><b>rack.aware.assignment.tags</b></p>
   * List of client tag keys used to distribute standby replicas across Kafka Streams instances.<br>When configured, Kafka Streams will make a best-effort to distribute the standby tasks over each client tag dimension.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> List containing maximum of 5 elements</p>
   * <p><b>Importance:</b> medium</p>
   */
  T rackAwareAssignmentTags(List<String> value);

  /**
   * <p><b>rack.aware.assignment.tags</b></p>
   * List of client tag keys used to distribute standby replicas across Kafka Streams instances.<br>When configured, Kafka Streams will make a best-effort to distribute the standby tasks over each client tag dimension.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> List containing maximum of 5 elements</p>
   * <p><b>Importance:</b> medium</p>
   */
  T rackAwareAssignmentTags(String value);

  /**
   * <p><b>replication.factor</b></p>
   * The replication factor for change log topics and repartition topics created by the stream processing application.<br>The default of <code>-1</code> (meaning: use broker default replication factor) requires broker version 2.4 or newer
   * <p><b>Default:</b> -1</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T replicationFactor(Integer value);

  /**
   * <p><b>security.protocol</b></p>
   * Protocol used to communicate with brokers.<br>Valid values are: PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
   * <p><b>Default:</b> PLAINTEXT</p>
   * <p><b>Valid Values:</b> [PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T securityProtocol(String value);

  /**
   * <p><b>task.timeout.ms</b></p>
   * The maximum amount of time in milliseconds a task might stall due to internal errors and retries until an error is raised.<br>For a timeout of 0ms, a task would raise an error for the first internal error.<br>For any timeout larger than 0ms, a task will retry at least once before an error is raised.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T taskTimeoutMs(Long value);

  /**
   * <p><b>topology.optimization</b></p>
   * A configuration telling Kafka Streams if it should optimize the topology, disabled by default
   * <p><b>Default:</b> none</p>
   * <p><b>Valid Values:</b> [none, all]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T topologyOptimization(String value);

  /**
   * <p><b>application.server</b></p>
   * A host:port pair pointing to a user-defined endpoint that can be used for state store discovery and interactive queries on this KafkaStreams instance.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T applicationServer(String value);

  /**
   * <p><b>buffered.records.per.partition</b></p>
   * Maximum number of records to buffer per partition.
   * <p><b>Default:</b> 1000</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T bufferedRecordsPerPartition(Integer value);

  /**
   * <p><b>built.in.metrics.version</b></p>
   * Version of the built-in metrics to use.
   * <p><b>Default:</b> latest</p>
   * <p><b>Valid Values:</b> [latest]</p>
   * <p><b>Importance:</b> low</p>
   */
  T builtInMetricsVersion(String value);

  /**
   * <p><b>commit.interval.ms</b></p>
   * The frequency in milliseconds with which to commit processing progress.<br>For at-least-once processing, committing means to save the position (ie, offsets) of the processor.<br>For exactly-once processing, it means to commit the transaction which includes to save the position and to make the committed data in the output topic visible to consumers with isolation level read_committed.<br>(Note, if <code>processing.guarantee</code> is set to <code>exactly_once_v2</code>, <code>exactly_once</code>,the default value is <code>100</code>, otherwise the default value is <code>30000</code>.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T commitIntervalMs(Long value);

  /**
   * <p><b>repartition.purge.interval.ms</b></p>
   * The frequency in milliseconds with which to delete fully consumed records from repartition topics.<br>Purging will occur after at least this value since the last purge, but may be delayed until later.<br>(Note, unlike <code>commit.interval.ms</code>, the default for this value remains unchanged when <code>processing.guarantee</code> is set to <code>exactly_once_v2</code>).
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T repartitionPurgeIntervalMs(Long value);

  /**
   * <p><b>connections.max.idle.ms</b></p>
   * Close idle connections after the number of milliseconds specified by this config.
   * <p><b>Default:</b> 540000 (9 minutes)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T connectionsMaxIdleMs(Long value);

  /**
   * <p><b>default.dsl.store</b></p>
   * The default state store type used by DSL operators.
   * <p><b>Default:</b> rocksDB</p>
   * <p><b>Valid Values:</b> [rocksDB, in_memory]</p>
   * <p><b>Importance:</b> low</p>
   */
  T defaultDslStore(String value);

  /**
   * <p><b>metadata.max.age.ms</b></p>
   * The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metadataMaxAgeMs(Long value);

  /**
   * <p><b>metrics.num.samples</b></p>
   * The number of samples maintained to compute metrics.
   * <p><b>Default:</b> 2</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsNumSamples(Integer value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(List<String> value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(String value);

  /**
   * <p><b>metrics.recording.level</b></p>
   * The highest recording level for metrics.
   * <p><b>Default:</b> INFO</p>
   * <p><b>Valid Values:</b> [INFO, DEBUG, TRACE]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsRecordingLevel(String value);

  /**
   * <p><b>metrics.sample.window.ms</b></p>
   * The window of time a metrics sample is computed over.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsSampleWindowMs(Long value);

  /**
   * <p><b>poll.ms</b></p>
   * The amount of time in milliseconds to block waiting for input.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T pollMs(Long value);

  /**
   * <p><b>probing.rebalance.interval.ms</b></p>
   * The maximum time in milliseconds to wait before triggering a rebalance to probe for warmup replicas that have finished warming up and are ready to become active.<br>Probing rebalances will continue to be triggered until the assignment is balanced.<br>Must be at least 1 minute.
   * <p><b>Default:</b> 600000 (10 minutes)</p>
   * <p><b>Valid Values:</b> [60000,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T probingRebalanceIntervalMs(Long value);

  /**
   * <p><b>receive.buffer.bytes</b></p>
   * The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 32768 (32 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T receiveBufferBytes(Integer value);

  /**
   * <p><b>reconnect.backoff.ms</b></p>
   * The base amount of time to wait before attempting to reconnect to a given host.<br>This avoids repeatedly connecting to a host in a tight loop.<br>This backoff applies to all connection attempts by the client to a broker.
   * <p><b>Default:</b> 50</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMs(Long value);

  /**
   * <p><b>reconnect.backoff.max.ms</b></p>
   * The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect.<br>If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum.<br>After calculating the backoff increase, 20% random jitter is added to avoid connection storms.
   * <p><b>Default:</b> 1000 (1 second)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMaxMs(Long value);

  /**
   * <p><b>retries</b></p>
   * Setting a value greater than zero will cause the client to resend any request that fails with a potentially transient error.<br>It is recommended to set the value to either zero or `MAX_VALUE` and use corresponding timeout parameters to control how long a client should retry a request.
   * <p><b>Default:</b> 0</p>
   * <p><b>Valid Values:</b> [0,...,2147483647]</p>
   * <p><b>Importance:</b> low</p>
   */
  T retries(Integer value);

  /**
   * <p><b>retry.backoff.ms</b></p>
   * The amount of time to wait before attempting to retry a failed request to a given topic partition.<br>This avoids repeatedly sending requests in a tight loop under some failure scenarios.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T retryBackoffMs(Long value);

  /**
   * <p><b>request.timeout.ms</b></p>
   * The configuration controls the maximum amount of time the client will wait for the response of a request.<br>If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.
   * <p><b>Default:</b> 40000 (40 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T requestTimeoutMs(Integer value);

  /**
   * <p><b>rocksdb.config.setter</b></p>
   * A Rocks DB config setter class or class name that implements the <code>org.apache.kafka.streams.state.RocksDBConfigSetter</code> interface
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T rocksdbConfigSetter(Class value);

  /**
   * <p><b>send.buffer.bytes</b></p>
   * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 131072 (128 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T sendBufferBytes(Integer value);

  /**
   * <p><b>state.cleanup.delay.ms</b></p>
   * The amount of time in milliseconds to wait before deleting state when a partition has migrated.<br>Only state directories that have not been modified for at least <code>state.cleanup.delay.ms</code> will be removed
   * <p><b>Default:</b> 600000 (10 minutes)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T stateCleanupDelayMs(Long value);

  /**
   * <p><b>upgrade.from</b></p>
   * Allows upgrading in a backward compatible way.<br>This is needed when upgrading from [0.10.0, 1.1] to 2.0+, or when upgrading from [2.0, 2.3] to 2.4+.<br>When upgrading from 3.3 to a newer version it is not required to specify this config.<br>Default is `null`.<br>Accepted values are "0.10.0", "0.10.1", "0.10.2", "0.11.0", "1.0", "1.1", "2.0", "2.1", "2.2", "2.3", "2.4", "2.5", "2.6", "2.7", "2.8", "3.0", "3.1", "3.2" (for upgrading from the corresponding old version).
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> [null, 0.10.0, 0.10.1, 0.10.2, 0.11.0, 1.0, 1.1, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 3.0, 3.1, 3.2]</p>
   * <p><b>Importance:</b> low</p>
   */
  T upgradeFrom(String value);

  /**
   * <p><b>windowed.inner.class.serde</b></p>
   *  Default serializer / deserializer for the inner class of a windowed record.<br>Must implement the <code>org.apache.kafka.common.serialization.Serde</code> interface.<br>Note that setting this config in KafkaStreams application would result in an error as it is meant to be used only from Plain consumer client.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T windowedInnerClassSerde(String value);

  /**
   * <p><b>windowstore.changelog.additional.retention.ms</b></p>
   * Added to a windows maintainMs to ensure data is not deleted from the log prematurely.<br>Allows for clock drift.<br>Default is 1 day
   * <p><b>Default:</b> 86400000 (1 day)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T windowstoreChangelogAdditionalRetentionMs(Long value);

  /**
   * <p><b>window.size.ms</b></p>
   * Sets window size for the deserializer in order to calculate window end times.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T windowSizeMs(Long value);

  default T self() {
    return (T)this;
  }
}
