package org.swisspush.kobuka.client.base;

import java.lang.Class;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Short;
import java.lang.String;
import java.util.List;
import org.apache.kafka.common.config.types.Password;

public interface CommonClientConfigFields<T extends CommonClientConfigFields<T>> {
  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(List<String> value);

  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(String value);

  /**
   * <p><b>client.id</b></p>
   * An id string to pass to the server when making requests.<br>The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T clientId(String value);

  /**
   * <p><b>metadata.max.age.ms</b></p>
   * The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metadataMaxAgeMs(Long value);

  /**
   * <p><b>send.buffer.bytes</b></p>
   * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 131072 (128 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T sendBufferBytes(Integer value);

  /**
   * <p><b>receive.buffer.bytes</b></p>
   * The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 65536 (64 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T receiveBufferBytes(Integer value);

  /**
   * <p><b>reconnect.backoff.ms</b></p>
   * The base amount of time to wait before attempting to reconnect to a given host.<br>This avoids repeatedly connecting to a host in a tight loop.<br>This backoff applies to all connection attempts by the client to a broker.
   * <p><b>Default:</b> 50</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMs(Long value);

  /**
   * <p><b>reconnect.backoff.max.ms</b></p>
   * The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect.<br>If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum.<br>After calculating the backoff increase, 20% random jitter is added to avoid connection storms.
   * <p><b>Default:</b> 1000 (1 second)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMaxMs(Long value);

  /**
   * <p><b>retry.backoff.ms</b></p>
   * The amount of time to wait before attempting to retry a failed request.<br>This avoids repeatedly sending requests in a tight loop under some failure scenarios.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T retryBackoffMs(Long value);

  /**
   * <p><b>request.timeout.ms</b></p>
   * The configuration controls the maximum amount of time the client will wait for the response of a request.<br>If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T requestTimeoutMs(Integer value);

  /**
   * <p><b>connections.max.idle.ms</b></p>
   * Close idle connections after the number of milliseconds specified by this config.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T connectionsMaxIdleMs(Long value);

  /**
   * <p><b>metrics.sample.window.ms</b></p>
   * The window of time a metrics sample is computed over.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsSampleWindowMs(Long value);

  /**
   * <p><b>metrics.num.samples</b></p>
   * The number of samples maintained to compute metrics.
   * <p><b>Default:</b> 2</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsNumSamples(Integer value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(List<String> value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(String value);

  /**
   * <p><b>metrics.recording.level</b></p>
   * The highest recording level for metrics.
   * <p><b>Default:</b> INFO</p>
   * <p><b>Valid Values:</b> [INFO, DEBUG, TRACE]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsRecordingLevel(String value);

  /**
   * <p><b>security.protocol</b></p>
   * Protocol used to communicate with brokers.<br>Valid values are: PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
   * <p><b>Default:</b> PLAINTEXT</p>
   * <p><b>Valid Values:</b> [PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T securityProtocol(String value);

  /**
   * <p><b>ssl.protocol</b></p>
   * The SSL protocol used to generate the SSLContext.<br>The default is 'TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>This value should be fine for most use cases.<br>Allowed values in recent JVMs are 'TLSv1.2' and 'TLSv1.3'.<br>'TLS', 'TLSv1.1', 'SSL', 'SSLv2' and 'SSLv3' may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.<br>With the default value for this config and 'ssl.enabled.protocols', clients will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'.<br>If this config is set to 'TLSv1.2', clients will not use 'TLSv1.3' even if it is one of the values in ssl.enabled.protocols and the server only supports 'TLSv1.3'.
   * <p><b>Default:</b> TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslProtocol(String value);

  /**
   * <p><b>ssl.provider</b></p>
   * The name of the security provider used for SSL connections.<br>Default value is the default security provider of the JVM.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslProvider(String value);

  /**
   * <p><b>ssl.cipher.suites</b></p>
   * A list of cipher suites.<br>This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.<br>By default all the available cipher suites are supported.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslCipherSuites(List<String> value);

  /**
   * <p><b>ssl.cipher.suites</b></p>
   * A list of cipher suites.<br>This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.<br>By default all the available cipher suites are supported.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslCipherSuites(String value);

  /**
   * <p><b>ssl.enabled.protocols</b></p>
   * The list of protocols enabled for SSL connections.<br>The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2).<br>This default should be fine for most cases.<br>Also see the config documentation for `ssl.protocol`.
   * <p><b>Default:</b> TLSv1.2,TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslEnabledProtocols(List<String> value);

  /**
   * <p><b>ssl.enabled.protocols</b></p>
   * The list of protocols enabled for SSL connections.<br>The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2).<br>This default should be fine for most cases.<br>Also see the config documentation for `ssl.protocol`.
   * <p><b>Default:</b> TLSv1.2,TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslEnabledProtocols(String value);

  /**
   * <p><b>ssl.keystore.type</b></p>
   * The file format of the key store file.<br>This is optional for client.<br>The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].
   * <p><b>Default:</b> JKS</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslKeystoreType(String value);

  /**
   * <p><b>ssl.keystore.location</b></p>
   * The location of the key store file.<br>This is optional for client and can be used for two-way authentication for client.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreLocation(String value);

  /**
   * <p><b>ssl.keystore.password</b></p>
   * The store password for the key store file.<br>This is optional for client and only needed if 'ssl.keystore.location' is configured.<br>Key store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystorePassword(Password value);

  /**
   * <p><b>ssl.keystore.password</b></p>
   * The store password for the key store file.<br>This is optional for client and only needed if 'ssl.keystore.location' is configured.<br>Key store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystorePassword(String value);

  /**
   * <p><b>ssl.key.password</b></p>
   * The password of the private key in the key store file or the PEM key specified in `ssl.keystore.key'.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeyPassword(Password value);

  /**
   * <p><b>ssl.key.password</b></p>
   * The password of the private key in the key store file or the PEM key specified in `ssl.keystore.key'.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeyPassword(String value);

  /**
   * <p><b>ssl.keystore.key</b></p>
   * Private key in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with PKCS#8 keys.<br>If the key is encrypted, key password must be specified using 'ssl.key.password'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreKey(Password value);

  /**
   * <p><b>ssl.keystore.key</b></p>
   * Private key in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with PKCS#8 keys.<br>If the key is encrypted, key password must be specified using 'ssl.key.password'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreKey(String value);

  /**
   * <p><b>ssl.keystore.certificate.chain</b></p>
   * Certificate chain in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with a list of X.509 certificates
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreCertificateChain(Password value);

  /**
   * <p><b>ssl.keystore.certificate.chain</b></p>
   * Certificate chain in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with a list of X.509 certificates
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreCertificateChain(String value);

  /**
   * <p><b>ssl.truststore.certificates</b></p>
   * Trusted certificates in the format specified by 'ssl.truststore.type'.<br>Default SSL engine factory supports only PEM format with X.509 certificates.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreCertificates(Password value);

  /**
   * <p><b>ssl.truststore.certificates</b></p>
   * Trusted certificates in the format specified by 'ssl.truststore.type'.<br>Default SSL engine factory supports only PEM format with X.509 certificates.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreCertificates(String value);

  /**
   * <p><b>ssl.truststore.type</b></p>
   * The file format of the trust store file.<br>The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].
   * <p><b>Default:</b> JKS</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslTruststoreType(String value);

  /**
   * <p><b>ssl.truststore.location</b></p>
   * The location of the trust store file.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreLocation(String value);

  /**
   * <p><b>ssl.truststore.password</b></p>
   * The password for the trust store file.<br>If a password is not set, trust store file configured will still be used, but integrity checking is disabled.<br>Trust store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststorePassword(Password value);

  /**
   * <p><b>ssl.truststore.password</b></p>
   * The password for the trust store file.<br>If a password is not set, trust store file configured will still be used, but integrity checking is disabled.<br>Trust store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststorePassword(String value);

  /**
   * <p><b>ssl.keymanager.algorithm</b></p>
   * The algorithm used by key manager factory for SSL connections.<br>Default value is the key manager factory algorithm configured for the Java Virtual Machine.
   * <p><b>Default:</b> SunX509</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslKeymanagerAlgorithm(String value);

  /**
   * <p><b>ssl.trustmanager.algorithm</b></p>
   * The algorithm used by trust manager factory for SSL connections.<br>Default value is the trust manager factory algorithm configured for the Java Virtual Machine.
   * <p><b>Default:</b> PKIX</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslTrustmanagerAlgorithm(String value);

  /**
   * <p><b>ssl.endpoint.identification.algorithm</b></p>
   * The endpoint identification algorithm to validate server hostname using server certificate.<br>
   * <p><b>Default:</b> https</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslEndpointIdentificationAlgorithm(String value);

  /**
   * <p><b>ssl.secure.random.implementation</b></p>
   * The SecureRandom PRNG implementation to use for SSL cryptography operations.<br>
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslSecureRandomImplementation(String value);

  /**
   * <p><b>ssl.engine.factory.class</b></p>
   * The class of type org.apache.kafka.common.security.auth.SslEngineFactory to provide SSLEngine objects.<br>Default value is org.apache.kafka.common.security.ssl.DefaultSslEngineFactory
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslEngineFactoryClass(Class value);

  /**
   * <p><b>sasl.kerberos.service.name</b></p>
   * The Kerberos principal name that Kafka runs as.<br>This can be defined either in Kafka's JAAS config or in Kafka's config.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslKerberosServiceName(String value);

  /**
   * <p><b>sasl.kerberos.kinit.cmd</b></p>
   * Kerberos kinit command path.
   * <p><b>Default:</b> /usr/bin/kinit</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosKinitCmd(String value);

  /**
   * <p><b>sasl.kerberos.ticket.renew.window.factor</b></p>
   * Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.
   * <p><b>Default:</b> 0.8</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosTicketRenewWindowFactor(Double value);

  /**
   * <p><b>sasl.kerberos.ticket.renew.jitter</b></p>
   * Percentage of random jitter added to the renewal time.
   * <p><b>Default:</b> 0.05</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosTicketRenewJitter(Double value);

  /**
   * <p><b>sasl.kerberos.min.time.before.relogin</b></p>
   * Login thread sleep time between refresh attempts.
   * <p><b>Default:</b> 60000</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosMinTimeBeforeRelogin(Long value);

  /**
   * <p><b>sasl.login.refresh.window.factor</b></p>
   * Login refresh thread will sleep until the specified window factor relative to the credential's lifetime has been reached, at which time it will try to refresh the credential.<br>Legal values are between 0.5 (50%) and 1.0 (100%) inclusive; a default value of 0.8 (80%) is used if no value is specified.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 0.8</p>
   * <p><b>Valid Values:</b> [0.5,...,1.0]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshWindowFactor(Double value);

  /**
   * <p><b>sasl.login.refresh.window.jitter</b></p>
   * The maximum amount of random jitter relative to the credential's lifetime that is added to the login refresh thread's sleep time.<br>Legal values are between 0 and 0.25 (25%) inclusive; a default value of 0.05 (5%) is used if no value is specified.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 0.05</p>
   * <p><b>Valid Values:</b> [0.0,...,0.25]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshWindowJitter(Double value);

  /**
   * <p><b>sasl.login.refresh.min.period.seconds</b></p>
   * The desired minimum time for the login refresh thread to wait before refreshing a credential, in seconds.<br>Legal values are between 0 and 900 (15 minutes); a default value of 60 (1 minute) is used if no value is specified.<br> This value and  sasl.login.refresh.buffer.seconds are both ignored if their sum exceeds the remaining lifetime of a credential.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 60</p>
   * <p><b>Valid Values:</b> [0,...,900]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshMinPeriodSeconds(Short value);

  /**
   * <p><b>sasl.login.refresh.buffer.seconds</b></p>
   * The amount of buffer time before credential expiration to maintain when refreshing a credential, in seconds.<br>If a refresh would otherwise occur closer to expiration than the number of buffer seconds then the refresh will be moved up to maintain as much of the buffer time as possible.<br>Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified.<br>This value and sasl.login.refresh.min.period.seconds are both ignored if their sum exceeds the remaining lifetime of a credential.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 300</p>
   * <p><b>Valid Values:</b> [0,...,3600]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshBufferSeconds(Short value);

  /**
   * <p><b>sasl.mechanism</b></p>
   * SASL mechanism used for client connections.<br>This may be any mechanism for which a security provider is available.<br>GSSAPI is the default mechanism.
   * <p><b>Default:</b> GSSAPI</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslMechanism(String value);

  /**
   * <p><b>sasl.jaas.config</b></p>
   * JAAS login context parameters for SASL connections in the format used by JAAS configuration files.<br>JAAS configuration file format is described <a href="http://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html">here</a>.<br>The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>.<br>For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslJaasConfig(Password value);

  /**
   * <p><b>sasl.jaas.config</b></p>
   * JAAS login context parameters for SASL connections in the format used by JAAS configuration files.<br>JAAS configuration file format is described <a href="http://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html">here</a>.<br>The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>.<br>For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslJaasConfig(String value);

  /**
   * <p><b>sasl.client.callback.handler.class</b></p>
   * The fully qualified name of a SASL client callback handler class that implements the AuthenticateCallbackHandler interface.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslClientCallbackHandlerClass(Class value);

  /**
   * <p><b>sasl.login.callback.handler.class</b></p>
   * The fully qualified name of a SASL login callback handler class that implements the AuthenticateCallbackHandler interface.<br>For brokers, login callback handler config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.callback.handler.class=com.example.CustomScramLoginCallbackHandler
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslLoginCallbackHandlerClass(Class value);

  /**
   * <p><b>sasl.login.class</b></p>
   * The fully qualified name of a class that implements the Login interface.<br>For brokers, login config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.class=com.example.CustomScramLogin
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslLoginClass(Class value);

  /**
   * <p><b>sasl.login.connect.timeout.ms</b></p>
   * The (optional) value in milliseconds for the external authentication provider connection timeout.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginConnectTimeoutMs(Integer value);

  /**
   * <p><b>sasl.login.read.timeout.ms</b></p>
   * The (optional) value in milliseconds for the external authentication provider read timeout.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginReadTimeoutMs(Integer value);

  /**
   * <p><b>sasl.login.retry.backoff.max.ms</b></p>
   * The (optional) value in milliseconds for the maximum wait between login attempts to the external authentication provider.<br>Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 10000 (10 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRetryBackoffMaxMs(Long value);

  /**
   * <p><b>sasl.login.retry.backoff.ms</b></p>
   * The (optional) value in milliseconds for the initial wait between login attempts to the external authentication provider.<br>Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRetryBackoffMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.scope.claim.name</b></p>
   * The OAuth claim for the scope is often named "scope", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.
   * <p><b>Default:</b> scope</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerScopeClaimName(String value);

  /**
   * <p><b>sasl.oauthbearer.sub.claim.name</b></p>
   * The OAuth claim for the subject is often named "sub", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.
   * <p><b>Default:</b> sub</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerSubClaimName(String value);

  /**
   * <p><b>sasl.oauthbearer.token.endpoint.url</b></p>
   * The URL for the OAuth/OIDC identity provider.<br>If the URL is HTTP(S)-based, it is the issuer's token endpoint URL to which requests will be made to login based on the configuration in sasl.jaas.config.<br>If the URL is file-based, it specifies a file containing an access token (in JWT serialized form) issued by the OAuth/OIDC identity provider to use for authorization.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslOauthbearerTokenEndpointUrl(String value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.url</b></p>
   * The OAuth/OIDC provider URL from which the provider's <a href="https://datatracker.ietf.org/doc/html/rfc7517#section-5">JWKS (JSON Web Key Set)</a> can be retrieved.<br>The URL can be HTTP(S)-based or file-based.<br>If the URL is HTTP(S)-based, the JWKS data will be retrieved from the OAuth/OIDC provider via the configured URL on broker startup.<br>All then-current keys will be cached on the broker for incoming requests.<br>If an authentication request is received for a JWT that includes a "kid" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.<br>However, the broker polls the URL every sasl.oauthbearer.jwks.endpoint.refresh.ms milliseconds to refresh the cache with any forthcoming keys before any JWT requests that include them are received.<br>If the URL is file-based, the broker will load the JWKS file from a configured location on startup.<br>In the event that the JWT includes a "kid" header value that isn't in the JWKS file, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslOauthbearerJwksEndpointUrl(String value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.refresh.ms</b></p>
   * The (optional) value in milliseconds for the broker to wait between refreshing its JWKS (JSON Web Key Set) cache that contains the keys to verify the signature of the JWT.
   * <p><b>Default:</b> 3600000 (1 hour)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRefreshMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms</b></p>
   * The (optional) value in milliseconds for the maximum wait between attempts to retrieve the JWKS (JSON Web Key Set) from the external authentication provider.<br>JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.
   * <p><b>Default:</b> 10000 (10 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRetryBackoffMaxMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.retry.backoff.ms</b></p>
   * The (optional) value in milliseconds for the initial wait between JWKS (JSON Web Key Set) retrieval attempts from the external authentication provider.<br>JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRetryBackoffMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.clock.skew.seconds</b></p>
   * The (optional) value in seconds to allow for differences between the time of the OAuth/OIDC identity provider and the broker.
   * <p><b>Default:</b> 30</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerClockSkewSeconds(Integer value);

  /**
   * <p><b>sasl.oauthbearer.expected.audience</b></p>
   * The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences.<br>The JWT will be inspected for the standard OAuth "aud" claim and if this value is set, the broker will match the value from JWT's "aud" claim  to see if there is an exact match.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedAudience(List<String> value);

  /**
   * <p><b>sasl.oauthbearer.expected.audience</b></p>
   * The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences.<br>The JWT will be inspected for the standard OAuth "aud" claim and if this value is set, the broker will match the value from JWT's "aud" claim  to see if there is an exact match.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedAudience(String value);

  /**
   * <p><b>sasl.oauthbearer.expected.issuer</b></p>
   * The (optional) setting for the broker to use to verify that the JWT was created by the expected issuer.<br>The JWT will be inspected for the standard OAuth "iss" claim and if this value is set, the broker will match it exactly against what is in the JWT's "iss" claim.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedIssuer(String value);

  default T self() {
    return (T)this;
  }
}
