package org.swisspush.kobuka.client.base;

import java.lang.Boolean;
import java.lang.Class;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Short;
import java.lang.String;
import java.util.List;
import org.apache.kafka.common.config.types.Password;

public interface ProducerConfigFields<T extends ProducerConfigFields<T>> {
  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(List<String> value);

  /**
   * <p><b>bootstrap.servers</b></p>
   * A list of host/port pairs to use for establishing the initial connection to the Kafka cluster.<br>The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers.<br>This list should be in the form <code>host1:port1,host2:port2,...</code>.<br>Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> high</p>
   */
  T bootstrapServers(String value);

  /**
   * <p><b>client.dns.lookup</b></p>
   * Controls how the client uses DNS lookups.<br>If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established.<br>After a disconnection, the next IP is used.<br>Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however).<br>If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names.<br>After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.
   * <p><b>Default:</b> use_all_dns_ips</p>
   * <p><b>Valid Values:</b> [use_all_dns_ips, resolve_canonical_bootstrap_servers_only]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T clientDnsLookup(String value);

  /**
   * <p><b>buffer.memory</b></p>
   * The total bytes of memory the producer can use to buffer records waiting to be sent to the server.<br>If records are sent faster than they can be delivered to the server the producer will block for <code>max.block.ms</code> after which it will throw an exception.<p>This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering.<br>Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.
   * <p><b>Default:</b> 33554432</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> high</p>
   */
  T bufferMemory(Long value);

  /**
   * <p><b>retries</b></p>
   * Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error.<br>Note that this retry is no different than if the client resent the record upon receiving the error.<br>Produce requests will be failed before the number of retries has been exhausted if the timeout configured by <code>delivery.timeout.ms</code> expires first before successful acknowledgement.<br>Users should generally prefer to leave this config unset and instead use <code>delivery.timeout.ms</code> to control retry behavior.<p>Enabling idempotence requires this config value to be greater than 0.<br>If conflicting configurations are set and idempotence is not explicitly enabled, idempotence is disabled.<p>Allowing retries while setting <code>enable.idempotence</code> to <code>false</code> and <code>max.in.flight.requests.per.connection</code> to 1 will potentially change the ordering of records because if two batches are sent to a single partition, and the first fails and is retried but the second succeeds, then the records in the second batch may appear first.
   * <p><b>Default:</b> 2147483647</p>
   * <p><b>Valid Values:</b> [0,...,2147483647]</p>
   * <p><b>Importance:</b> high</p>
   */
  T retries(Integer value);

  /**
   * <p><b>acks</b></p>
   * The number of acknowledgments the producer requires the leader to have received before considering a request complete.<br>This controls the  durability of records that are sent.<br>The following settings are allowed:  <ul> <li><code>acks=0</code> If set to zero then the producer will not wait for any acknowledgment from the server at all.<br>The record will be immediately added to the socket buffer and considered sent.<br>No guarantee can be made that the server has received the record in this case, and the <code>retries</code> configuration will not take effect (as the client won't generally know of any failures).<br>The offset given back for each record will always be set to <code>-1</code>.<br><li><code>acks=1</code> This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers.<br>In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost.<br><li><code>acks=all</code> This means the leader will wait for the full set of in-sync replicas to acknowledge the record.<br>This guarantees that the record will not be lost as long as at least one in-sync replica remains alive.<br>This is the strongest available guarantee.<br>This is equivalent to the acks=-1 setting.</ul><p>Note that enabling idempotence requires this config value to be 'all'.<br>If conflicting configurations are set and idempotence is not explicitly enabled, idempotence is disabled.
   * <p><b>Default:</b> all</p>
   * <p><b>Valid Values:</b> [all, -1, 0, 1]</p>
   * <p><b>Importance:</b> low</p>
   */
  T acks(String value);

  /**
   * <p><b>compression.type</b></p>
   * The compression type for all data generated by the producer.<br>The default is none (i.e.<br>no compression).<br>Valid  values are <code>none</code>, <code>gzip</code>, <code>snappy</code>, <code>lz4</code>, or <code>zstd</code>.<br>Compression is of full batches of data, so the efficacy of batching will also impact the compression ratio (more batching means better compression).
   * <p><b>Default:</b> none</p>
   * <p><b>Valid Values:</b> [none, gzip, snappy, lz4, zstd]</p>
   * <p><b>Importance:</b> high</p>
   */
  T compressionType(String value);

  /**
   * <p><b>batch.size</b></p>
   * The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition.<br>This helps performance on both the client and the server.<br>This configuration controls the default batch size in bytes.<br><p>No attempt will be made to batch records larger than this size.<br><p>Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent.<br><p>A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely).<br>A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.<p>Note: This setting gives the upper bound of the batch size to be sent.<br>If we have fewer than this many bytes accumulated for this partition, we will 'linger' for the <code>linger.ms</code> time waiting for more records to show up.<br>This <code>linger.ms</code> setting defaults to 0, which means we'll immediately send out a record even the accumulated batch size is under this <code>batch.size</code> setting.
   * <p><b>Default:</b> 16384</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T batchSize(Integer value);

  /**
   * <p><b>partitioner.adaptive.partitioning.enable</b></p>
   * When set to 'true', the producer will try to adapt to broker performance and produce more messages to partitions hosted on faster brokers.<br>If 'false', producer will try to distribute messages uniformly.<br>Note: this setting has no effect if a custom partitioner is used
   * <p><b>Default:</b> true</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T partitionerAdaptivePartitioningEnable(Boolean value);

  /**
   * <p><b>partitioner.availability.timeout.ms</b></p>
   * If a broker cannot process produce requests from a partition for <code>partitioner.availability.timeout.ms</code> time, the partitioner treats that partition as not available.<br> If the value is 0, this logic is disabled.<br>Note: this setting has no effect if a custom partitioner is used or <code>partitioner.adaptive.partitioning.enable<code/> is set to 'false'
   * <p><b>Default:</b> 0</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T partitionerAvailabilityTimeoutMs(Long value);

  /**
   * <p><b>partitioner.ignore.keys</b></p>
   * When set to 'true' the producer won't use record keys to choose a partition.<br>If 'false', producer would choose a partition based on a hash of the key when a key is present.<br>Note: this setting has no effect if a custom partitioner is used.
   * <p><b>Default:</b> false</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T partitionerIgnoreKeys(Boolean value);

  /**
   * <p><b>linger.ms</b></p>
   * The producer groups together any records that arrive in between request transmissions into a single batched request.<br>Normally this occurs only under load when records arrive faster than they can be sent out.<br>However in some circumstances the client may want to reduce the number of requests even under moderate load.<br>This setting accomplishes this by adding a small amount of artificial delay&mdash;that is, rather than immediately sending out a record, the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together.<br>This can be thought of as analogous to Nagle's algorithm in TCP.<br>This setting gives the upper bound on the delay for batching: once we get <code>batch.size</code> worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up.<br>This setting defaults to 0 (i.e.<br>no delay).<br>Setting <code>linger.ms=5</code>, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absence of load.
   * <p><b>Default:</b> 0</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T lingerMs(Long value);

  /**
   * <p><b>delivery.timeout.ms</b></p>
   * An upper bound on the time to report success or failure after a call to <code>send()</code> returns.<br>This limits the total time that a record will be delayed prior to sending, the time to await acknowledgement from the broker (if expected), and the time allowed for retriable send failures.<br>The producer may report failure to send a record earlier than this config if either an unrecoverable error is encountered, the retries have been exhausted, or the record is added to a batch which reached an earlier delivery expiration deadline.<br>The value of this config should be greater than or equal to the sum of <code>request.timeout.ms</code> and <code>linger.ms</code>.
   * <p><b>Default:</b> 120000 (2 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T deliveryTimeoutMs(Integer value);

  /**
   * <p><b>client.id</b></p>
   * An id string to pass to the server when making requests.<br>The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T clientId(String value);

  /**
   * <p><b>send.buffer.bytes</b></p>
   * The size of the TCP send buffer (SO_SNDBUF) to use when sending data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 131072 (128 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T sendBufferBytes(Integer value);

  /**
   * <p><b>receive.buffer.bytes</b></p>
   * The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.<br>If the value is -1, the OS default will be used.
   * <p><b>Default:</b> 32768 (32 kibibytes)</p>
   * <p><b>Valid Values:</b> [-1,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T receiveBufferBytes(Integer value);

  /**
   * <p><b>max.request.size</b></p>
   * The maximum size of a request in bytes.<br>This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.<br>This is also effectively a cap on the maximum uncompressed record batch size.<br>Note that the server has its own cap on the record batch size (after compression if compression is enabled) which may be different from this.
   * <p><b>Default:</b> 1048576</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T maxRequestSize(Integer value);

  /**
   * <p><b>reconnect.backoff.ms</b></p>
   * The base amount of time to wait before attempting to reconnect to a given host.<br>This avoids repeatedly connecting to a host in a tight loop.<br>This backoff applies to all connection attempts by the client to a broker.
   * <p><b>Default:</b> 50</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMs(Long value);

  /**
   * <p><b>reconnect.backoff.max.ms</b></p>
   * The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect.<br>If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum.<br>After calculating the backoff increase, 20% random jitter is added to avoid connection storms.
   * <p><b>Default:</b> 1000 (1 second)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T reconnectBackoffMaxMs(Long value);

  /**
   * <p><b>retry.backoff.ms</b></p>
   * The amount of time to wait before attempting to retry a failed request to a given topic partition.<br>This avoids repeatedly sending requests in a tight loop under some failure scenarios.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T retryBackoffMs(Long value);

  /**
   * <p><b>max.block.ms</b></p>
   * The configuration controls how long the <code>KafkaProducer</code>'s <code>send()</code>, <code>partitionsFor()</code>, <code>initTransactions()</code>, <code>sendOffsetsToTransaction()</code>, <code>commitTransaction()</code> and <code>abortTransaction()</code> methods will block.<br>For <code>send()</code> this timeout bounds the total time waiting for both metadata fetch and buffer allocation (blocking in the user-supplied serializers or partitioner is not counted against this timeout).<br>For <code>partitionsFor()</code> this timeout bounds the time spent waiting for metadata if it is unavailable.<br>The transaction-related methods always block, but may timeout if the transaction coordinator could not be discovered or did not respond within the timeout.
   * <p><b>Default:</b> 60000 (1 minute)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T maxBlockMs(Long value);

  /**
   * <p><b>request.timeout.ms</b></p>
   * The configuration controls the maximum amount of time the client will wait for the response of a request.<br>If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.<br>This should be larger than <code>replica.lag.time.max.ms</code> (a broker configuration) to reduce the possibility of message duplication due to unnecessary producer retries.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T requestTimeoutMs(Integer value);

  /**
   * <p><b>metadata.max.age.ms</b></p>
   * The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metadataMaxAgeMs(Long value);

  /**
   * <p><b>metadata.max.idle.ms</b></p>
   * Controls how long the producer will cache metadata for a topic that's idle.<br>If the elapsed time since a topic was last produced to exceeds the metadata idle duration, then the topic's metadata is forgotten and the next access to it will force a metadata fetch request.
   * <p><b>Default:</b> 300000 (5 minutes)</p>
   * <p><b>Valid Values:</b> [5000,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metadataMaxIdleMs(Long value);

  /**
   * <p><b>metrics.sample.window.ms</b></p>
   * The window of time a metrics sample is computed over.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> [0,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsSampleWindowMs(Long value);

  /**
   * <p><b>metrics.num.samples</b></p>
   * The number of samples maintained to compute metrics.
   * <p><b>Default:</b> 2</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsNumSamples(Integer value);

  /**
   * <p><b>metrics.recording.level</b></p>
   * The highest recording level for metrics.
   * <p><b>Default:</b> INFO</p>
   * <p><b>Valid Values:</b> [INFO, DEBUG, TRACE]</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricsRecordingLevel(String value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(List<String> value);

  /**
   * <p><b>metric.reporters</b></p>
   * A list of classes to use as metrics reporters.<br>Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation.<br>The JmxReporter is always included to register JMX statistics.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> low</p>
   */
  T metricReporters(String value);

  /**
   * <p><b>max.in.flight.requests.per.connection</b></p>
   * The maximum number of unacknowledged requests the client will send on a single connection before blocking.<br>Note that if this configuration is set to be greater than 1 and <code>enable.idempotence</code> is set to false, there is a risk of message reordering after a failed send due to retries (i.e., if retries are enabled);  if retries are disabled or if <code>enable.idempotence</code> is set to true, ordering will be preserved.<br>Additionally, enabling idempotence requires the value of this configuration to be less than or equal to 5.<br>If conflicting configurations are set and idempotence is not explicitly enabled, idempotence is disabled.<br>
   * <p><b>Default:</b> 5</p>
   * <p><b>Valid Values:</b> [1,...]</p>
   * <p><b>Importance:</b> low</p>
   */
  T maxInFlightRequestsPerConnection(Integer value);

  /**
   * <p><b>key.serializer</b></p>
   * Serializer class for key that implements the <code>org.apache.kafka.common.serialization.Serializer</code> interface.
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T keySerializer(Class value);

  /**
   * <p><b>value.serializer</b></p>
   * Serializer class for value that implements the <code>org.apache.kafka.common.serialization.Serializer</code> interface.
   * <p><b>Default:</b> </p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T valueSerializer(Class value);

  /**
   * <p><b>socket.connection.setup.timeout.ms</b></p>
   * The amount of time the client will wait for the socket connection to be established.<br>If the connection is not built before the timeout elapses, clients will close the socket channel.
   * <p><b>Default:</b> 10000 (10 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T socketConnectionSetupTimeoutMs(Long value);

  /**
   * <p><b>socket.connection.setup.timeout.max.ms</b></p>
   * The maximum amount of time the client will wait for the socket connection to be established.<br>The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum.<br>To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.
   * <p><b>Default:</b> 30000 (30 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T socketConnectionSetupTimeoutMaxMs(Long value);

  /**
   * <p><b>connections.max.idle.ms</b></p>
   * Close idle connections after the number of milliseconds specified by this config.
   * <p><b>Default:</b> 540000 (9 minutes)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T connectionsMaxIdleMs(Long value);

  /**
   * <p><b>partitioner.class</b></p>
   * A class to use to determine which partition to be send to when produce the records.<br>Available options are:<ul><li>If not set, the default partitioning logic is used.<br>This strategy will try sticking to a partition until batch.size bytes is produced to the partition.<br>It works with the strategy:<ul><li>If no partition is specified but a key is present, choose a partition based on a hash of the key</li><li>If no partition or key is present, choose the sticky partition that changes when batch.size bytes are produced to the partition.</li></ul></li><li><code>org.apache.kafka.clients.producer.RoundRobinPartitioner</code>: This partitioning strategy is that each record in a series of consecutive records will be sent to a different partition(no matter if the 'key' is provided or not), until we run out of partitions and start over again.<br>Note: There's a known issue that will cause uneven distribution when new batch is created.<br>Please check KAFKA-9965 for more detail.</li></ul><p>Implementing the <code>org.apache.kafka.clients.producer.Partitioner</code> interface allows you to plug in a custom partitioner.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T partitionerClass(Class value);

  /**
   * <p><b>interceptor.classes</b></p>
   * A list of classes to use as interceptors.<br>Implementing the <code>org.apache.kafka.clients.producer.ProducerInterceptor</code> interface allows you to intercept (and possibly mutate) the records received by the producer before they are published to the Kafka cluster.<br>By default, there are no interceptors.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> low</p>
   */
  T interceptorClasses(List<String> value);

  /**
   * <p><b>interceptor.classes</b></p>
   * A list of classes to use as interceptors.<br>Implementing the <code>org.apache.kafka.clients.producer.ProducerInterceptor</code> interface allows you to intercept (and possibly mutate) the records received by the producer before they are published to the Kafka cluster.<br>By default, there are no interceptors.
   * <p><b>Default:</b> ""</p>
   * <p><b>Valid Values:</b> non-null string</p>
   * <p><b>Importance:</b> low</p>
   */
  T interceptorClasses(String value);

  /**
   * <p><b>security.protocol</b></p>
   * Protocol used to communicate with brokers.<br>Valid values are: PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL.
   * <p><b>Default:</b> PLAINTEXT</p>
   * <p><b>Valid Values:</b> [PLAINTEXT, SSL, SASL_PLAINTEXT, SASL_SSL]</p>
   * <p><b>Importance:</b> medium</p>
   */
  T securityProtocol(String value);

  /**
   * <p><b>security.providers</b></p>
   * A list of configurable creator classes each returning a provider implementing security algorithms.<br>These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T securityProviders(String value);

  /**
   * <p><b>ssl.protocol</b></p>
   * The SSL protocol used to generate the SSLContext.<br>The default is 'TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>This value should be fine for most use cases.<br>Allowed values in recent JVMs are 'TLSv1.2' and 'TLSv1.3'.<br>'TLS', 'TLSv1.1', 'SSL', 'SSLv2' and 'SSLv3' may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.<br>With the default value for this config and 'ssl.enabled.protocols', clients will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'.<br>If this config is set to 'TLSv1.2', clients will not use 'TLSv1.3' even if it is one of the values in ssl.enabled.protocols and the server only supports 'TLSv1.3'.
   * <p><b>Default:</b> TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslProtocol(String value);

  /**
   * <p><b>ssl.provider</b></p>
   * The name of the security provider used for SSL connections.<br>Default value is the default security provider of the JVM.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslProvider(String value);

  /**
   * <p><b>ssl.cipher.suites</b></p>
   * A list of cipher suites.<br>This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.<br>By default all the available cipher suites are supported.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslCipherSuites(List<String> value);

  /**
   * <p><b>ssl.cipher.suites</b></p>
   * A list of cipher suites.<br>This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.<br>By default all the available cipher suites are supported.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslCipherSuites(String value);

  /**
   * <p><b>ssl.enabled.protocols</b></p>
   * The list of protocols enabled for SSL connections.<br>The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2).<br>This default should be fine for most cases.<br>Also see the config documentation for `ssl.protocol`.
   * <p><b>Default:</b> TLSv1.2,TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslEnabledProtocols(List<String> value);

  /**
   * <p><b>ssl.enabled.protocols</b></p>
   * The list of protocols enabled for SSL connections.<br>The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise.<br>With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2).<br>This default should be fine for most cases.<br>Also see the config documentation for `ssl.protocol`.
   * <p><b>Default:</b> TLSv1.2,TLSv1.3</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslEnabledProtocols(String value);

  /**
   * <p><b>ssl.keystore.type</b></p>
   * The file format of the key store file.<br>This is optional for client.<br>The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].
   * <p><b>Default:</b> JKS</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslKeystoreType(String value);

  /**
   * <p><b>ssl.keystore.location</b></p>
   * The location of the key store file.<br>This is optional for client and can be used for two-way authentication for client.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreLocation(String value);

  /**
   * <p><b>ssl.keystore.password</b></p>
   * The store password for the key store file.<br>This is optional for client and only needed if 'ssl.keystore.location' is configured.<br>Key store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystorePassword(Password value);

  /**
   * <p><b>ssl.keystore.password</b></p>
   * The store password for the key store file.<br>This is optional for client and only needed if 'ssl.keystore.location' is configured.<br>Key store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystorePassword(String value);

  /**
   * <p><b>ssl.key.password</b></p>
   * The password of the private key in the key store file or the PEM key specified in `ssl.keystore.key'.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeyPassword(Password value);

  /**
   * <p><b>ssl.key.password</b></p>
   * The password of the private key in the key store file or the PEM key specified in `ssl.keystore.key'.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeyPassword(String value);

  /**
   * <p><b>ssl.keystore.key</b></p>
   * Private key in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with PKCS#8 keys.<br>If the key is encrypted, key password must be specified using 'ssl.key.password'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreKey(Password value);

  /**
   * <p><b>ssl.keystore.key</b></p>
   * Private key in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with PKCS#8 keys.<br>If the key is encrypted, key password must be specified using 'ssl.key.password'
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreKey(String value);

  /**
   * <p><b>ssl.keystore.certificate.chain</b></p>
   * Certificate chain in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with a list of X.509 certificates
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreCertificateChain(Password value);

  /**
   * <p><b>ssl.keystore.certificate.chain</b></p>
   * Certificate chain in the format specified by 'ssl.keystore.type'.<br>Default SSL engine factory supports only PEM format with a list of X.509 certificates
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslKeystoreCertificateChain(String value);

  /**
   * <p><b>ssl.truststore.certificates</b></p>
   * Trusted certificates in the format specified by 'ssl.truststore.type'.<br>Default SSL engine factory supports only PEM format with X.509 certificates.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreCertificates(Password value);

  /**
   * <p><b>ssl.truststore.certificates</b></p>
   * Trusted certificates in the format specified by 'ssl.truststore.type'.<br>Default SSL engine factory supports only PEM format with X.509 certificates.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreCertificates(String value);

  /**
   * <p><b>ssl.truststore.type</b></p>
   * The file format of the trust store file.<br>The values currently supported by the default `ssl.engine.factory.class` are [JKS, PKCS12, PEM].
   * <p><b>Default:</b> JKS</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T sslTruststoreType(String value);

  /**
   * <p><b>ssl.truststore.location</b></p>
   * The location of the trust store file.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststoreLocation(String value);

  /**
   * <p><b>ssl.truststore.password</b></p>
   * The password for the trust store file.<br>If a password is not set, trust store file configured will still be used, but integrity checking is disabled.<br>Trust store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststorePassword(Password value);

  /**
   * <p><b>ssl.truststore.password</b></p>
   * The password for the trust store file.<br>If a password is not set, trust store file configured will still be used, but integrity checking is disabled.<br>Trust store password is not supported for PEM format.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> high</p>
   */
  T sslTruststorePassword(String value);

  /**
   * <p><b>ssl.keymanager.algorithm</b></p>
   * The algorithm used by key manager factory for SSL connections.<br>Default value is the key manager factory algorithm configured for the Java Virtual Machine.
   * <p><b>Default:</b> SunX509</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslKeymanagerAlgorithm(String value);

  /**
   * <p><b>ssl.trustmanager.algorithm</b></p>
   * The algorithm used by trust manager factory for SSL connections.<br>Default value is the trust manager factory algorithm configured for the Java Virtual Machine.
   * <p><b>Default:</b> PKIX</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslTrustmanagerAlgorithm(String value);

  /**
   * <p><b>ssl.endpoint.identification.algorithm</b></p>
   * The endpoint identification algorithm to validate server hostname using server certificate.<br>
   * <p><b>Default:</b> https</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslEndpointIdentificationAlgorithm(String value);

  /**
   * <p><b>ssl.secure.random.implementation</b></p>
   * The SecureRandom PRNG implementation to use for SSL cryptography operations.<br>
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslSecureRandomImplementation(String value);

  /**
   * <p><b>ssl.engine.factory.class</b></p>
   * The class of type org.apache.kafka.common.security.auth.SslEngineFactory to provide SSLEngine objects.<br>Default value is org.apache.kafka.common.security.ssl.DefaultSslEngineFactory
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T sslEngineFactoryClass(Class value);

  /**
   * <p><b>sasl.kerberos.service.name</b></p>
   * The Kerberos principal name that Kafka runs as.<br>This can be defined either in Kafka's JAAS config or in Kafka's config.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslKerberosServiceName(String value);

  /**
   * <p><b>sasl.kerberos.kinit.cmd</b></p>
   * Kerberos kinit command path.
   * <p><b>Default:</b> /usr/bin/kinit</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosKinitCmd(String value);

  /**
   * <p><b>sasl.kerberos.ticket.renew.window.factor</b></p>
   * Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.
   * <p><b>Default:</b> 0.8</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosTicketRenewWindowFactor(Double value);

  /**
   * <p><b>sasl.kerberos.ticket.renew.jitter</b></p>
   * Percentage of random jitter added to the renewal time.
   * <p><b>Default:</b> 0.05</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosTicketRenewJitter(Double value);

  /**
   * <p><b>sasl.kerberos.min.time.before.relogin</b></p>
   * Login thread sleep time between refresh attempts.
   * <p><b>Default:</b> 60000</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslKerberosMinTimeBeforeRelogin(Long value);

  /**
   * <p><b>sasl.login.refresh.window.factor</b></p>
   * Login refresh thread will sleep until the specified window factor relative to the credential's lifetime has been reached, at which time it will try to refresh the credential.<br>Legal values are between 0.5 (50%) and 1.0 (100%) inclusive; a default value of 0.8 (80%) is used if no value is specified.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 0.8</p>
   * <p><b>Valid Values:</b> [0.5,...,1.0]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshWindowFactor(Double value);

  /**
   * <p><b>sasl.login.refresh.window.jitter</b></p>
   * The maximum amount of random jitter relative to the credential's lifetime that is added to the login refresh thread's sleep time.<br>Legal values are between 0 and 0.25 (25%) inclusive; a default value of 0.05 (5%) is used if no value is specified.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 0.05</p>
   * <p><b>Valid Values:</b> [0.0,...,0.25]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshWindowJitter(Double value);

  /**
   * <p><b>sasl.login.refresh.min.period.seconds</b></p>
   * The desired minimum time for the login refresh thread to wait before refreshing a credential, in seconds.<br>Legal values are between 0 and 900 (15 minutes); a default value of 60 (1 minute) is used if no value is specified.<br> This value and  sasl.login.refresh.buffer.seconds are both ignored if their sum exceeds the remaining lifetime of a credential.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 60</p>
   * <p><b>Valid Values:</b> [0,...,900]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshMinPeriodSeconds(Short value);

  /**
   * <p><b>sasl.login.refresh.buffer.seconds</b></p>
   * The amount of buffer time before credential expiration to maintain when refreshing a credential, in seconds.<br>If a refresh would otherwise occur closer to expiration than the number of buffer seconds then the refresh will be moved up to maintain as much of the buffer time as possible.<br>Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified.<br>This value and sasl.login.refresh.min.period.seconds are both ignored if their sum exceeds the remaining lifetime of a credential.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 300</p>
   * <p><b>Valid Values:</b> [0,...,3600]</p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRefreshBufferSeconds(Short value);

  /**
   * <p><b>sasl.mechanism</b></p>
   * SASL mechanism used for client connections.<br>This may be any mechanism for which a security provider is available.<br>GSSAPI is the default mechanism.
   * <p><b>Default:</b> GSSAPI</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslMechanism(String value);

  /**
   * <p><b>sasl.jaas.config</b></p>
   * JAAS login context parameters for SASL connections in the format used by JAAS configuration files.<br>JAAS configuration file format is described <a href="http://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html">here</a>.<br>The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>.<br>For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslJaasConfig(Password value);

  /**
   * <p><b>sasl.jaas.config</b></p>
   * JAAS login context parameters for SASL connections in the format used by JAAS configuration files.<br>JAAS configuration file format is described <a href="http://docs.oracle.com/javase/8/docs/technotes/guides/security/jgss/tutorials/LoginConfigFile.html">here</a>.<br>The format for the value is: <code>loginModuleClass controlFlag (optionName=optionValue)*;</code>.<br>For brokers, the config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.jaas.config=com.example.ScramLoginModule required;
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslJaasConfig(String value);

  /**
   * <p><b>sasl.client.callback.handler.class</b></p>
   * The fully qualified name of a SASL client callback handler class that implements the AuthenticateCallbackHandler interface.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslClientCallbackHandlerClass(Class value);

  /**
   * <p><b>sasl.login.callback.handler.class</b></p>
   * The fully qualified name of a SASL login callback handler class that implements the AuthenticateCallbackHandler interface.<br>For brokers, login callback handler config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.callback.handler.class=com.example.CustomScramLoginCallbackHandler
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslLoginCallbackHandlerClass(Class value);

  /**
   * <p><b>sasl.login.class</b></p>
   * The fully qualified name of a class that implements the Login interface.<br>For brokers, login config must be prefixed with listener prefix and SASL mechanism name in lower-case.<br>For example, listener.name.sasl_ssl.scram-sha-256.sasl.login.class=com.example.CustomScramLogin
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslLoginClass(Class value);

  /**
   * <p><b>sasl.login.connect.timeout.ms</b></p>
   * The (optional) value in milliseconds for the external authentication provider connection timeout.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginConnectTimeoutMs(Integer value);

  /**
   * <p><b>sasl.login.read.timeout.ms</b></p>
   * The (optional) value in milliseconds for the external authentication provider read timeout.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginReadTimeoutMs(Integer value);

  /**
   * <p><b>sasl.login.retry.backoff.max.ms</b></p>
   * The (optional) value in milliseconds for the maximum wait between login attempts to the external authentication provider.<br>Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 10000 (10 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRetryBackoffMaxMs(Long value);

  /**
   * <p><b>sasl.login.retry.backoff.ms</b></p>
   * The (optional) value in milliseconds for the initial wait between login attempts to the external authentication provider.<br>Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting.<br>Currently applies only to OAUTHBEARER.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslLoginRetryBackoffMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.scope.claim.name</b></p>
   * The OAuth claim for the scope is often named "scope", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.
   * <p><b>Default:</b> scope</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerScopeClaimName(String value);

  /**
   * <p><b>sasl.oauthbearer.sub.claim.name</b></p>
   * The OAuth claim for the subject is often named "sub", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.
   * <p><b>Default:</b> sub</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerSubClaimName(String value);

  /**
   * <p><b>sasl.oauthbearer.token.endpoint.url</b></p>
   * The URL for the OAuth/OIDC identity provider.<br>If the URL is HTTP(S)-based, it is the issuer's token endpoint URL to which requests will be made to login based on the configuration in sasl.jaas.config.<br>If the URL is file-based, it specifies a file containing an access token (in JWT serialized form) issued by the OAuth/OIDC identity provider to use for authorization.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslOauthbearerTokenEndpointUrl(String value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.url</b></p>
   * The OAuth/OIDC provider URL from which the provider's <a href="https://datatracker.ietf.org/doc/html/rfc7517#section-5">JWKS (JSON Web Key Set)</a> can be retrieved.<br>The URL can be HTTP(S)-based or file-based.<br>If the URL is HTTP(S)-based, the JWKS data will be retrieved from the OAuth/OIDC provider via the configured URL on broker startup.<br>All then-current keys will be cached on the broker for incoming requests.<br>If an authentication request is received for a JWT that includes a "kid" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.<br>However, the broker polls the URL every sasl.oauthbearer.jwks.endpoint.refresh.ms milliseconds to refresh the cache with any forthcoming keys before any JWT requests that include them are received.<br>If the URL is file-based, the broker will load the JWKS file from a configured location on startup.<br>In the event that the JWT includes a "kid" header value that isn't in the JWKS file, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> medium</p>
   */
  T saslOauthbearerJwksEndpointUrl(String value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.refresh.ms</b></p>
   * The (optional) value in milliseconds for the broker to wait between refreshing its JWKS (JSON Web Key Set) cache that contains the keys to verify the signature of the JWT.
   * <p><b>Default:</b> 3600000 (1 hour)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRefreshMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms</b></p>
   * The (optional) value in milliseconds for the maximum wait between attempts to retrieve the JWKS (JSON Web Key Set) from the external authentication provider.<br>JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.
   * <p><b>Default:</b> 10000 (10 seconds)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRetryBackoffMaxMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.jwks.endpoint.retry.backoff.ms</b></p>
   * The (optional) value in milliseconds for the initial wait between JWKS (JSON Web Key Set) retrieval attempts from the external authentication provider.<br>JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.
   * <p><b>Default:</b> 100</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerJwksEndpointRetryBackoffMs(Long value);

  /**
   * <p><b>sasl.oauthbearer.clock.skew.seconds</b></p>
   * The (optional) value in seconds to allow for differences between the time of the OAuth/OIDC identity provider and the broker.
   * <p><b>Default:</b> 30</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerClockSkewSeconds(Integer value);

  /**
   * <p><b>sasl.oauthbearer.expected.audience</b></p>
   * The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences.<br>The JWT will be inspected for the standard OAuth "aud" claim and if this value is set, the broker will match the value from JWT's "aud" claim  to see if there is an exact match.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedAudience(List<String> value);

  /**
   * <p><b>sasl.oauthbearer.expected.audience</b></p>
   * The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences.<br>The JWT will be inspected for the standard OAuth "aud" claim and if this value is set, the broker will match the value from JWT's "aud" claim  to see if there is an exact match.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedAudience(String value);

  /**
   * <p><b>sasl.oauthbearer.expected.issuer</b></p>
   * The (optional) setting for the broker to use to verify that the JWT was created by the expected issuer.<br>The JWT will be inspected for the standard OAuth "iss" claim and if this value is set, the broker will match it exactly against what is in the JWT's "iss" claim.<br>If there is no match, the broker will reject the JWT and authentication will fail.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T saslOauthbearerExpectedIssuer(String value);

  /**
   * <p><b>enable.idempotence</b></p>
   * When set to 'true', the producer will ensure that exactly one copy of each message is written in the stream.<br>If 'false', producer retries due to broker failures, etc., may write duplicates of the retried message in the stream.<br>Note that enabling idempotence requires <code>max.in.flight.requests.per.connection</code> to be less than or equal to 5 (with message ordering preserved for any allowable value), <code>retries</code> to be greater than 0, and <code>acks</code> must be 'all'.<br><p>Idempotence is enabled by default if no conflicting configurations are set.<br>If conflicting configurations are set and idempotence is not explicitly enabled, idempotence is disabled.<br>If idempotence is explicitly enabled and conflicting configurations are set, a <code>ConfigException</code> is thrown.
   * <p><b>Default:</b> true</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T enableIdempotence(Boolean value);

  /**
   * <p><b>transaction.timeout.ms</b></p>
   * The maximum amount of time in ms that the transaction coordinator will wait for a transaction status update from the producer before proactively aborting the ongoing transaction.If this value is larger than the transaction.max.timeout.ms setting in the broker, the request will fail with a <code>InvalidTxnTimeoutException</code> error.
   * <p><b>Default:</b> 60000 (1 minute)</p>
   * <p><b>Valid Values:</b> </p>
   * <p><b>Importance:</b> low</p>
   */
  T transactionTimeoutMs(Integer value);

  /**
   * <p><b>transactional.id</b></p>
   * The TransactionalId to use for transactional delivery.<br>This enables reliability semantics which span multiple producer sessions since it allows the client to guarantee that transactions using the same TransactionalId have been completed prior to starting any new transactions.<br>If no TransactionalId is provided, then the producer is limited to idempotent delivery.<br>If a TransactionalId is configured, <code>enable.idempotence</code> is implied.<br>By default the TransactionId is not configured, which means transactions cannot be used.<br>Note that, by default, transactions require a cluster of at least three brokers which is the recommended setting for production; for development you can change this, by adjusting broker setting <code>transaction.state.log.replication.factor</code>.
   * <p><b>Default:</b> null</p>
   * <p><b>Valid Values:</b> non-empty string</p>
   * <p><b>Importance:</b> low</p>
   */
  T transactionalId(String value);

  default T self() {
    return (T)this;
  }
}
