/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.kobuka.gen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.streams.StreamsConfig;

public class Generator {
    public static final String CLIENT_PACKAGE = "org.swisspush.kobuka.client.base";

    public static void main(String[] args) throws IOException {
        Path path = Paths.get(args[0] + "/target/generated-sources/kobuka/", new String[0]);
        Generator.generateBuilder(CLIENT_PACKAGE, "ConsumerConfig", Generator.stream(ConsumerConfig.configDef()), path);
        Generator.generateBuilder(CLIENT_PACKAGE, "ProducerConfig", Generator.stream(ProducerConfig.configDef()), path);
        Generator.generateBuilder(CLIENT_PACKAGE, "AdminClientConfig", Generator.stream(AdminClientConfig.configDef()), path);
        Generator.generateBuilder(CLIENT_PACKAGE, "StreamsConfig", Generator.stream(StreamsConfig.configDef()), path);
        HashSet commonKeys = new HashSet(ConsumerConfig.configDef().configKeys().keySet());
        commonKeys.retainAll(ProducerConfig.configDef().configKeys().keySet());
        commonKeys.retainAll(AdminClientConfig.configDef().configKeys().keySet());
        commonKeys.retainAll(StreamsConfig.configDef().configKeys().keySet());
        ConfigDef commonConfigs = new ConfigDef();
        SaslConfigs.addClientSaslSupport((ConfigDef)commonConfigs);
        SslConfigs.addClientSslSupport((ConfigDef)commonConfigs);
        commonKeys.addAll(commonConfigs.configKeys().keySet());
        Stream<Map.Entry<String, ConfigDef.ConfigKey>> commonConfigMap = AdminClientConfig.configDef().configKeys().entrySet().stream().filter(entry -> commonKeys.contains(entry.getKey()));
        Generator.generateBuilder(CLIENT_PACKAGE, "CommonClientConfig", commonConfigMap, path);
    }

    private static Stream<Map.Entry<String, ConfigDef.ConfigKey>> stream(ConfigDef configDef) {
        return configDef.configKeys().entrySet().stream();
    }

    private static void generateBuilder(String packageName, String baseName, Stream<Map.Entry<String, ConfigDef.ConfigKey>> definitions, Path path) throws IOException {
        String interfaceName = baseName + "Fields";
        String className = "Abstract" + baseName + "Builder";
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)packageName, (String)interfaceName, (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})}));
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)className).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)packageName, (String)interfaceName, (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addTypeVariable(TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get((String)packageName, (String)className, (String[])new String[0]), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})}));
        classBuilder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), (String)"configs", (Modifier[])new Modifier[0]).initializer(CodeBlock.builder().add("new $T<>()", new Object[]{HashMap.class}).build()).build());
        definitions.filter(entry -> !((ConfigDef.ConfigKey)entry.getValue()).internalConfig).forEach(entry -> {
            Generator.generateMethod(interfaceBuilder, classBuilder, (ConfigDef.ConfigKey)entry.getValue(), Generator.resolveType(((ConfigDef.ConfigKey)entry.getValue()).type));
            if (((ConfigDef.ConfigKey)entry.getValue()).type == ConfigDef.Type.LIST || ((ConfigDef.ConfigKey)entry.getValue()).type == ConfigDef.Type.PASSWORD) {
                Generator.generateMethod(interfaceBuilder, classBuilder, (ConfigDef.ConfigKey)entry.getValue(), (TypeName)ClassName.get(String.class));
            }
        });
        interfaceBuilder.addMethod(MethodSpec.methodBuilder((String)"self").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)TypeVariableName.get((String)"T")).addStatement("return (T)this", new Object[0]).build());
        JavaFile interfaceJavaFile = JavaFile.builder((String)packageName, (TypeSpec)interfaceBuilder.build()).build();
        JavaFile classJavaFile = JavaFile.builder((String)packageName, (TypeSpec)classBuilder.build()).build();
        interfaceJavaFile.writeTo(path);
        classJavaFile.writeTo(path);
    }

    private static void generateMethod(TypeSpec.Builder interfaceBuilder, TypeSpec.Builder classBuilder, ConfigDef.ConfigKey key, TypeName type) {
        interfaceBuilder.addMethod(MethodSpec.methodBuilder((String)Generator.toCamelCase(key.displayName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("<p><b>" + key.displayName + "</b></p>\n" + key.documentation.replaceAll("\\. ", ".<br>") + "\n<p><b>Default:</b> " + Generator.renderDefault(key) + "</p>\n<p><b>Valid Values:</b> " + (key.validator != null ? key.validator.toString() : "") + "</p>\n<p><b>Importance:</b> " + key.importance.toString().toLowerCase(Locale.ROOT) + "</p>", new Object[0]).returns((TypeName)TypeVariableName.get((String)"T")).addParameter(type, "value", new Modifier[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)Generator.toCamelCase(key.name)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"T")).addParameter(type, "value", new Modifier[0]).addStatement("configs.put($S, value)", new Object[]{key.name}).addStatement("return self()", new Object[0]).build());
    }

    private static TypeName resolveType(ConfigDef.Type type) {
        return switch (type) {
            case ConfigDef.Type.INT -> ClassName.get(Integer.class);
            case ConfigDef.Type.BOOLEAN -> ClassName.get(Boolean.class);
            case ConfigDef.Type.CLASS -> ClassName.get(Class.class);
            case ConfigDef.Type.DOUBLE -> ClassName.get(Double.class);
            case ConfigDef.Type.LONG -> ClassName.get(Long.class);
            case ConfigDef.Type.SHORT -> ClassName.get(Short.class);
            case ConfigDef.Type.LIST -> ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class});
            case ConfigDef.Type.PASSWORD -> ClassName.get(Password.class);
            default -> ClassName.get(String.class);
        };
    }

    private static String renderDefault(ConfigDef.ConfigKey key) {
        if (key.hasDefault()) {
            if (key.defaultValue == null) {
                return "null";
            }
            String defaultValueStr = ConfigDef.convertToString((Object)key.defaultValue, (ConfigDef.Type)key.type);
            if (defaultValueStr.isEmpty()) {
                return "\"\"";
            }
            String suffix = "";
            if (key.name.endsWith(".bytes")) {
                suffix = Generator.niceMemoryUnits(((Number)key.defaultValue).longValue());
            } else if (key.name.endsWith(".ms")) {
                suffix = Generator.niceTimeUnits(((Number)key.defaultValue).longValue());
            }
            return defaultValueStr + suffix;
        }
        return "";
    }

    private static String niceMemoryUnits(long bytes) {
        int i;
        long value = bytes;
        for (i = 0; value != 0L && i < 4 && value % 1024L == 0L; value /= 1024L, ++i) {
        }
        return switch (i) {
            case 1 -> " (" + value + " kibibyte" + (value == 1L ? ")" : "s)");
            case 2 -> " (" + value + " mebibyte" + (value == 1L ? ")" : "s)");
            case 3 -> " (" + value + " gibibyte" + (value == 1L ? ")" : "s)");
            case 4 -> " (" + value + " tebibyte" + (value == 1L ? ")" : "s)");
            default -> "";
        };
    }

    private static String niceTimeUnits(long millis) {
        int i;
        long value = millis;
        long[] divisors = new long[]{1000L, 60L, 60L, 24L};
        String[] units = new String[]{"second", "minute", "hour", "day"};
        for (i = 0; value != 0L && i < 4 && value % divisors[i] == 0L; value /= divisors[i], ++i) {
        }
        if (i > 0) {
            return " (" + value + " " + units[i - 1] + (value > 1L ? "s)" : ")");
        }
        return "";
    }

    private static String toCamelCase(String str) {
        Matcher matcher = Pattern.compile("[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+").matcher(str);
        ArrayList<String> matched = new ArrayList<String>();
        while (matcher.find()) {
            matched.add(matcher.group(0));
        }
        String camelcase = matched.stream().map(x -> x.substring(0, 1).toUpperCase() + x.substring(1).toLowerCase()).collect(Collectors.joining());
        return camelcase.substring(0, 1).toLowerCase() + camelcase.substring(1);
    }
}

