package org.swisspush.kobuka.spring;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Generated;
import net.karneim.pojobuilder.GwtIncompatible;
import org.aopalliance.aop.Advice;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ContainerProperties.AckMode;
import org.springframework.kafka.listener.ContainerProperties.AssignmentCommitOption;
import org.springframework.kafka.listener.ContainerProperties.EOSMode;
import org.springframework.kafka.support.LogIfLevelEnabled.Level;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.swisspush.kobuka.spring.internal.Builder;
import org.swisspush.kobuka.spring.internal.ContainerPropertiesProvider;

@Generated("PojoBuilder")
public class ContainerPropertiesBuilder
    implements Builder<ContainerProperties>, Cloneable {
  protected ContainerPropertiesBuilder self;
  protected ConcurrentKafkaListenerContainerFactory<?, ?> value$factory$org$springframework$kafka$config$ConcurrentKafkaListenerContainerFactory;
  protected boolean isSet$factory$org$springframework$kafka$config$ConcurrentKafkaListenerContainerFactory;
  protected long value$pollTimeout$long;
  protected boolean isSet$pollTimeout$long;
  protected String value$groupId$java$lang$String;
  protected boolean isSet$groupId$java$lang$String;
  protected String value$clientId$java$lang$String;
  protected boolean isSet$clientId$java$lang$String;
  protected ConsumerRebalanceListener value$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener;
  protected boolean isSet$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener;
  protected OffsetCommitCallback value$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback;
  protected boolean isSet$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback;
  protected boolean value$syncCommits$boolean;
  protected boolean isSet$syncCommits$boolean;
  protected Level value$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level;
  protected boolean isSet$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level;
  protected Properties value$kafkaConsumerProperties$java$util$Properties;
  protected boolean isSet$kafkaConsumerProperties$java$util$Properties;
  protected Duration value$authorizationExceptionRetryInterval$java$time$Duration;
  protected boolean isSet$authorizationExceptionRetryInterval$java$time$Duration;
  protected int value$commitRetries$int;
  protected boolean isSet$commitRetries$int;
  protected boolean value$onlyLogRecordMetadata$boolean;
  protected boolean isSet$onlyLogRecordMetadata$boolean;
  protected boolean value$fixTxOffsets$boolean;
  protected boolean isSet$fixTxOffsets$boolean;
  protected Object value$messageListener$java$lang$Object;
  protected boolean isSet$messageListener$java$lang$Object;
  protected AckMode value$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode;
  protected boolean isSet$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode;
  protected int value$ackCount$int;
  protected boolean isSet$ackCount$int;
  protected long value$ackTime$long;
  protected boolean isSet$ackTime$long;
  protected AsyncListenableTaskExecutor value$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor;
  protected boolean isSet$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor;
  protected long value$shutdownTimeout$long;
  protected boolean isSet$shutdownTimeout$long;
  protected Duration value$syncCommitTimeout$java$time$Duration;
  protected boolean isSet$syncCommitTimeout$java$time$Duration;
  protected Long value$idleEventInterval$java$lang$Long;
  protected boolean isSet$idleEventInterval$java$lang$Long;
  protected Long value$idlePartitionEventInterval$java$lang$Long;
  protected boolean isSet$idlePartitionEventInterval$java$lang$Long;
  protected PlatformTransactionManager value$transactionManager$org$springframework$transaction$PlatformTransactionManager;
  protected boolean isSet$transactionManager$org$springframework$transaction$PlatformTransactionManager;
  protected int value$monitorInterval$int;
  protected boolean isSet$monitorInterval$int;
  protected TaskScheduler value$scheduler$org$springframework$scheduling$TaskScheduler;
  protected boolean isSet$scheduler$org$springframework$scheduling$TaskScheduler;
  protected float value$noPollThreshold$float;
  protected boolean isSet$noPollThreshold$float;
  protected boolean value$logContainerConfig$boolean;
  protected boolean isSet$logContainerConfig$boolean;
  protected boolean value$missingTopicsFatal$boolean;
  protected boolean isSet$missingTopicsFatal$boolean;
  protected long value$idleBetweenPolls$long;
  protected boolean isSet$idleBetweenPolls$long;
  protected boolean value$micrometerEnabled$boolean;
  protected boolean isSet$micrometerEnabled$boolean;
  protected Map<String, String> value$micrometerTags$java$util$Map;
  protected boolean isSet$micrometerTags$java$util$Map;
  protected Duration value$consumerStartTimeout$java$time$Duration;
  protected boolean isSet$consumerStartTimeout$java$time$Duration;
  protected Duration value$consumerStartTimout$java$time$Duration;
  protected boolean isSet$consumerStartTimout$java$time$Duration;
  protected Boolean value$subBatchPerPartition$java$lang$Boolean;
  protected boolean isSet$subBatchPerPartition$java$lang$Boolean;
  protected AssignmentCommitOption value$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption;
  protected boolean isSet$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption;
  protected boolean value$deliveryAttemptHeader$boolean;
  protected boolean isSet$deliveryAttemptHeader$boolean;
  protected EOSMode value$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode;
  protected boolean isSet$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode;
  protected TransactionDefinition value$transactionDefinition$org$springframework$transaction$TransactionDefinition;
  protected boolean isSet$transactionDefinition$org$springframework$transaction$TransactionDefinition;
  protected Advice[] value$adviceChain$org$aopalliance$aop$Advice$L;
  protected boolean isSet$adviceChain$org$aopalliance$aop$Advice$L;
  protected boolean value$stopContainerWhenFenced$boolean;
  protected boolean isSet$stopContainerWhenFenced$boolean;
  protected boolean value$stopImmediate$boolean;
  protected boolean isSet$stopImmediate$boolean;

  /**
   * Creates a new {@link ContainerPropertiesBuilder}.
   */
  public ContainerPropertiesBuilder() {
    self = (ContainerPropertiesBuilder)this;
  }

  /**
   * Sets the default value for the factory property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder factory(ConcurrentKafkaListenerContainerFactory<?, ?> value) {
    this.value$factory$org$springframework$kafka$config$ConcurrentKafkaListenerContainerFactory = value;
    this.isSet$factory$org$springframework$kafka$config$ConcurrentKafkaListenerContainerFactory = true;
    return self;
  }

  /**
   * Sets the default value for the pollTimeout property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder pollTimeout(long value) {
    this.value$pollTimeout$long = value;
    this.isSet$pollTimeout$long = true;
    return self;
  }

  /**
   * Sets the default value for the groupId property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder groupId(String value) {
    this.value$groupId$java$lang$String = value;
    this.isSet$groupId$java$lang$String = true;
    return self;
  }

  /**
   * Sets the default value for the clientId property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder clientId(String value) {
    this.value$clientId$java$lang$String = value;
    this.isSet$clientId$java$lang$String = true;
    return self;
  }

  /**
   * Sets the default value for the consumerRebalanceListener property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder consumerRebalanceListener(ConsumerRebalanceListener value) {
    this.value$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener = value;
    this.isSet$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener = true;
    return self;
  }

  /**
   * Sets the default value for the commitCallback property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder commitCallback(OffsetCommitCallback value) {
    this.value$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback = value;
    this.isSet$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback = true;
    return self;
  }

  /**
   * Sets the default value for the syncCommits property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder syncCommits(boolean value) {
    this.value$syncCommits$boolean = value;
    this.isSet$syncCommits$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the commitLogLevel property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder commitLogLevel(Level value) {
    this.value$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level = value;
    this.isSet$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level = true;
    return self;
  }

  /**
   * Sets the default value for the kafkaConsumerProperties property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder kafkaConsumerProperties(Properties value) {
    this.value$kafkaConsumerProperties$java$util$Properties = value;
    this.isSet$kafkaConsumerProperties$java$util$Properties = true;
    return self;
  }

  /**
   * Sets the default value for the authorizationExceptionRetryInterval property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder authorizationExceptionRetryInterval(Duration value) {
    this.value$authorizationExceptionRetryInterval$java$time$Duration = value;
    this.isSet$authorizationExceptionRetryInterval$java$time$Duration = true;
    return self;
  }

  /**
   * Sets the default value for the commitRetries property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder commitRetries(int value) {
    this.value$commitRetries$int = value;
    this.isSet$commitRetries$int = true;
    return self;
  }

  /**
   * Sets the default value for the onlyLogRecordMetadata property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder onlyLogRecordMetadata(boolean value) {
    this.value$onlyLogRecordMetadata$boolean = value;
    this.isSet$onlyLogRecordMetadata$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the fixTxOffsets property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder fixTxOffsets(boolean value) {
    this.value$fixTxOffsets$boolean = value;
    this.isSet$fixTxOffsets$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the messageListener property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder messageListener(Object value) {
    this.value$messageListener$java$lang$Object = value;
    this.isSet$messageListener$java$lang$Object = true;
    return self;
  }

  /**
   * Sets the default value for the ackMode property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder ackMode(AckMode value) {
    this.value$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode = value;
    this.isSet$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode = true;
    return self;
  }

  /**
   * Sets the default value for the ackCount property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder ackCount(int value) {
    this.value$ackCount$int = value;
    this.isSet$ackCount$int = true;
    return self;
  }

  /**
   * Sets the default value for the ackTime property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder ackTime(long value) {
    this.value$ackTime$long = value;
    this.isSet$ackTime$long = true;
    return self;
  }

  /**
   * Sets the default value for the consumerTaskExecutor property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder consumerTaskExecutor(AsyncListenableTaskExecutor value) {
    this.value$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor = value;
    this.isSet$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor = true;
    return self;
  }

  /**
   * Sets the default value for the shutdownTimeout property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder shutdownTimeout(long value) {
    this.value$shutdownTimeout$long = value;
    this.isSet$shutdownTimeout$long = true;
    return self;
  }

  /**
   * Sets the default value for the syncCommitTimeout property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder syncCommitTimeout(Duration value) {
    this.value$syncCommitTimeout$java$time$Duration = value;
    this.isSet$syncCommitTimeout$java$time$Duration = true;
    return self;
  }

  /**
   * Sets the default value for the idleEventInterval property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder idleEventInterval(Long value) {
    this.value$idleEventInterval$java$lang$Long = value;
    this.isSet$idleEventInterval$java$lang$Long = true;
    return self;
  }

  /**
   * Sets the default value for the idlePartitionEventInterval property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder idlePartitionEventInterval(Long value) {
    this.value$idlePartitionEventInterval$java$lang$Long = value;
    this.isSet$idlePartitionEventInterval$java$lang$Long = true;
    return self;
  }

  /**
   * Sets the default value for the transactionManager property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder transactionManager(PlatformTransactionManager value) {
    this.value$transactionManager$org$springframework$transaction$PlatformTransactionManager = value;
    this.isSet$transactionManager$org$springframework$transaction$PlatformTransactionManager = true;
    return self;
  }

  /**
   * Sets the default value for the monitorInterval property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder monitorInterval(int value) {
    this.value$monitorInterval$int = value;
    this.isSet$monitorInterval$int = true;
    return self;
  }

  /**
   * Sets the default value for the scheduler property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder scheduler(TaskScheduler value) {
    this.value$scheduler$org$springframework$scheduling$TaskScheduler = value;
    this.isSet$scheduler$org$springframework$scheduling$TaskScheduler = true;
    return self;
  }

  /**
   * Sets the default value for the noPollThreshold property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder noPollThreshold(float value) {
    this.value$noPollThreshold$float = value;
    this.isSet$noPollThreshold$float = true;
    return self;
  }

  /**
   * Sets the default value for the logContainerConfig property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder logContainerConfig(boolean value) {
    this.value$logContainerConfig$boolean = value;
    this.isSet$logContainerConfig$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the missingTopicsFatal property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder missingTopicsFatal(boolean value) {
    this.value$missingTopicsFatal$boolean = value;
    this.isSet$missingTopicsFatal$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the idleBetweenPolls property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder idleBetweenPolls(long value) {
    this.value$idleBetweenPolls$long = value;
    this.isSet$idleBetweenPolls$long = true;
    return self;
  }

  /**
   * Sets the default value for the micrometerEnabled property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder micrometerEnabled(boolean value) {
    this.value$micrometerEnabled$boolean = value;
    this.isSet$micrometerEnabled$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the micrometerTags property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder micrometerTags(Map<String, String> value) {
    this.value$micrometerTags$java$util$Map = value;
    this.isSet$micrometerTags$java$util$Map = true;
    return self;
  }

  /**
   * Sets the default value for the consumerStartTimeout property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder consumerStartTimeout(Duration value) {
    this.value$consumerStartTimeout$java$time$Duration = value;
    this.isSet$consumerStartTimeout$java$time$Duration = true;
    return self;
  }

  /**
   * Sets the default value for the consumerStartTimout property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder consumerStartTimout(Duration value) {
    this.value$consumerStartTimout$java$time$Duration = value;
    this.isSet$consumerStartTimout$java$time$Duration = true;
    return self;
  }

  /**
   * Sets the default value for the subBatchPerPartition property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder subBatchPerPartition(Boolean value) {
    this.value$subBatchPerPartition$java$lang$Boolean = value;
    this.isSet$subBatchPerPartition$java$lang$Boolean = true;
    return self;
  }

  /**
   * Sets the default value for the assignmentCommitOption property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder assignmentCommitOption(AssignmentCommitOption value) {
    this.value$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption = value;
    this.isSet$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption = true;
    return self;
  }

  /**
   * Sets the default value for the deliveryAttemptHeader property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder deliveryAttemptHeader(boolean value) {
    this.value$deliveryAttemptHeader$boolean = value;
    this.isSet$deliveryAttemptHeader$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the eosMode property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder eosMode(EOSMode value) {
    this.value$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode = value;
    this.isSet$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode = true;
    return self;
  }

  /**
   * Sets the default value for the transactionDefinition property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder transactionDefinition(TransactionDefinition value) {
    this.value$transactionDefinition$org$springframework$transaction$TransactionDefinition = value;
    this.isSet$transactionDefinition$org$springframework$transaction$TransactionDefinition = true;
    return self;
  }

  /**
   * Sets the default value for the adviceChain property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder adviceChain(Advice... value) {
    this.value$adviceChain$org$aopalliance$aop$Advice$L = value;
    this.isSet$adviceChain$org$aopalliance$aop$Advice$L = true;
    return self;
  }

  /**
   * Sets the default value for the stopContainerWhenFenced property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder stopContainerWhenFenced(boolean value) {
    this.value$stopContainerWhenFenced$boolean = value;
    this.isSet$stopContainerWhenFenced$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the stopImmediate property.
   *
   * @param value the default value
   * @return this builder
   */
  public ContainerPropertiesBuilder stopImmediate(boolean value) {
    this.value$stopImmediate$boolean = value;
    this.isSet$stopImmediate$boolean = true;
    return self;
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @Override
  @GwtIncompatible
  public Object clone() {
    try {
      ContainerPropertiesBuilder result = (ContainerPropertiesBuilder)super.clone();
      result.self = result;
      return result;
    } catch (CloneNotSupportedException e) {
      throw new InternalError(e.getMessage());
    }
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @GwtIncompatible
  public ContainerPropertiesBuilder but() {
    return (ContainerPropertiesBuilder)clone();
  }

  /**
   * Creates a new {@link ContainerProperties} based on this builder's settings.
   *
   * @return the created ContainerProperties
   */
  @Override
  public ContainerProperties build() {
    try {
      ContainerProperties result = ContainerPropertiesProvider.create(value$factory$org$springframework$kafka$config$ConcurrentKafkaListenerContainerFactory);
      if (isSet$pollTimeout$long) {
        result.setPollTimeout(value$pollTimeout$long);
      }
      if (isSet$groupId$java$lang$String) {
        result.setGroupId(value$groupId$java$lang$String);
      }
      if (isSet$clientId$java$lang$String) {
        result.setClientId(value$clientId$java$lang$String);
      }
      if (isSet$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener) {
        result.setConsumerRebalanceListener(value$consumerRebalanceListener$org$apache$kafka$clients$consumer$ConsumerRebalanceListener);
      }
      if (isSet$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback) {
        result.setCommitCallback(value$commitCallback$org$apache$kafka$clients$consumer$OffsetCommitCallback);
      }
      if (isSet$syncCommits$boolean) {
        result.setSyncCommits(value$syncCommits$boolean);
      }
      if (isSet$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level) {
        result.setCommitLogLevel(value$commitLogLevel$org$springframework$kafka$support$LogIfLevelEnabled$Level);
      }
      if (isSet$kafkaConsumerProperties$java$util$Properties) {
        result.setKafkaConsumerProperties(value$kafkaConsumerProperties$java$util$Properties);
      }
      if (isSet$authorizationExceptionRetryInterval$java$time$Duration) {
        result.setAuthorizationExceptionRetryInterval(value$authorizationExceptionRetryInterval$java$time$Duration);
      }
      if (isSet$commitRetries$int) {
        result.setCommitRetries(value$commitRetries$int);
      }
      if (isSet$onlyLogRecordMetadata$boolean) {
        result.setOnlyLogRecordMetadata(value$onlyLogRecordMetadata$boolean);
      }
      if (isSet$fixTxOffsets$boolean) {
        result.setFixTxOffsets(value$fixTxOffsets$boolean);
      }
      if (isSet$messageListener$java$lang$Object) {
        result.setMessageListener(value$messageListener$java$lang$Object);
      }
      if (isSet$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode) {
        result.setAckMode(value$ackMode$org$springframework$kafka$listener$ContainerProperties$AckMode);
      }
      if (isSet$ackCount$int) {
        result.setAckCount(value$ackCount$int);
      }
      if (isSet$ackTime$long) {
        result.setAckTime(value$ackTime$long);
      }
      if (isSet$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor) {
        result.setConsumerTaskExecutor(value$consumerTaskExecutor$org$springframework$core$task$AsyncListenableTaskExecutor);
      }
      if (isSet$shutdownTimeout$long) {
        result.setShutdownTimeout(value$shutdownTimeout$long);
      }
      if (isSet$syncCommitTimeout$java$time$Duration) {
        result.setSyncCommitTimeout(value$syncCommitTimeout$java$time$Duration);
      }
      if (isSet$idleEventInterval$java$lang$Long) {
        result.setIdleEventInterval(value$idleEventInterval$java$lang$Long);
      }
      if (isSet$idlePartitionEventInterval$java$lang$Long) {
        result.setIdlePartitionEventInterval(value$idlePartitionEventInterval$java$lang$Long);
      }
      if (isSet$transactionManager$org$springframework$transaction$PlatformTransactionManager) {
        result.setTransactionManager(value$transactionManager$org$springframework$transaction$PlatformTransactionManager);
      }
      if (isSet$monitorInterval$int) {
        result.setMonitorInterval(value$monitorInterval$int);
      }
      if (isSet$scheduler$org$springframework$scheduling$TaskScheduler) {
        result.setScheduler(value$scheduler$org$springframework$scheduling$TaskScheduler);
      }
      if (isSet$noPollThreshold$float) {
        result.setNoPollThreshold(value$noPollThreshold$float);
      }
      if (isSet$logContainerConfig$boolean) {
        result.setLogContainerConfig(value$logContainerConfig$boolean);
      }
      if (isSet$missingTopicsFatal$boolean) {
        result.setMissingTopicsFatal(value$missingTopicsFatal$boolean);
      }
      if (isSet$idleBetweenPolls$long) {
        result.setIdleBetweenPolls(value$idleBetweenPolls$long);
      }
      if (isSet$micrometerEnabled$boolean) {
        result.setMicrometerEnabled(value$micrometerEnabled$boolean);
      }
      if (isSet$micrometerTags$java$util$Map) {
        result.setMicrometerTags(value$micrometerTags$java$util$Map);
      }
      if (isSet$consumerStartTimeout$java$time$Duration) {
        result.setConsumerStartTimeout(value$consumerStartTimeout$java$time$Duration);
      }
      if (isSet$consumerStartTimout$java$time$Duration) {
        result.setConsumerStartTimout(value$consumerStartTimout$java$time$Duration);
      }
      if (isSet$subBatchPerPartition$java$lang$Boolean) {
        result.setSubBatchPerPartition(value$subBatchPerPartition$java$lang$Boolean);
      }
      if (isSet$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption) {
        result.setAssignmentCommitOption(value$assignmentCommitOption$org$springframework$kafka$listener$ContainerProperties$AssignmentCommitOption);
      }
      if (isSet$deliveryAttemptHeader$boolean) {
        result.setDeliveryAttemptHeader(value$deliveryAttemptHeader$boolean);
      }
      if (isSet$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode) {
        result.setEosMode(value$eosMode$org$springframework$kafka$listener$ContainerProperties$EOSMode);
      }
      if (isSet$transactionDefinition$org$springframework$transaction$TransactionDefinition) {
        result.setTransactionDefinition(value$transactionDefinition$org$springframework$transaction$TransactionDefinition);
      }
      if (isSet$adviceChain$org$aopalliance$aop$Advice$L) {
        result.setAdviceChain(value$adviceChain$org$aopalliance$aop$Advice$L);
      }
      if (isSet$stopContainerWhenFenced$boolean) {
        result.setStopContainerWhenFenced(value$stopContainerWhenFenced$boolean);
      }
      if (isSet$stopImmediate$boolean) {
        result.setStopImmediate(value$stopImmediate$boolean);
      }
      return result;
    } catch (RuntimeException ex) {
      throw ex;
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
}
