package org.swisspush.kobuka.spring;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Generated;
import net.karneim.pojobuilder.GwtIncompatible;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerFactory.Listener;
import org.springframework.kafka.core.ConsumerPostProcessor;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.swisspush.kobuka.spring.internal.Builder;
import org.swisspush.kobuka.spring.internal.DefaultKafkaConsumerFactoryProvider;

@Generated("PojoBuilder")
public abstract class AbstractDefaultKafkaConsumerFactoryBuilder<K, V>
    implements Builder<DefaultKafkaConsumerFactory<K, V>>, Cloneable {
  protected DefaultKafkaConsumerFactoryBuilder<K, V> self;
  protected Map<String, Object> value$configs$java$util$Map;
  protected boolean isSet$configs$java$util$Map;
  protected List<Listener<K, V>> value$withListeners$java$util$List;
  protected boolean isSet$withListeners$java$util$List;
  protected List<ConsumerPostProcessor<K, V>> value$withPostProcessors$java$util$List;
  protected boolean isSet$withPostProcessors$java$util$List;
  protected Supplier<String> value$bootstrapServersSupplier$java$util$function$Supplier;
  protected boolean isSet$bootstrapServersSupplier$java$util$function$Supplier;
  protected Deserializer<K> value$keyDeserializer$org$apache$kafka$common$serialization$Deserializer;
  protected boolean isSet$keyDeserializer$org$apache$kafka$common$serialization$Deserializer;
  protected Deserializer<V> value$valueDeserializer$org$apache$kafka$common$serialization$Deserializer;
  protected boolean isSet$valueDeserializer$org$apache$kafka$common$serialization$Deserializer;
  protected Supplier<Deserializer<K>> value$keyDeserializerSupplier$java$util$function$Supplier;
  protected boolean isSet$keyDeserializerSupplier$java$util$function$Supplier;
  protected Supplier<Deserializer<V>> value$valueDeserializerSupplier$java$util$function$Supplier;
  protected boolean isSet$valueDeserializerSupplier$java$util$function$Supplier;
  protected boolean value$configureDeserializers$boolean;
  protected boolean isSet$configureDeserializers$boolean;

  /**
   * Creates a new {@link AbstractDefaultKafkaConsumerFactoryBuilder}.
   */
  public AbstractDefaultKafkaConsumerFactoryBuilder() {
    self = (DefaultKafkaConsumerFactoryBuilder<K, V>)this;
  }

  /**
   * Sets the default value for the configs property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> configs(Map<String, Object> value) {
    this.value$configs$java$util$Map = value;
    this.isSet$configs$java$util$Map = true;
    return self;
  }

  /**
   * Sets the default value for the withListeners property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> withListeners(List<Listener<K, V>> value) {
    this.value$withListeners$java$util$List = value;
    this.isSet$withListeners$java$util$List = true;
    return self;
  }

  /**
   * Sets the default value for the withPostProcessors property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> withPostProcessors(List<ConsumerPostProcessor<K, V>> value) {
    this.value$withPostProcessors$java$util$List = value;
    this.isSet$withPostProcessors$java$util$List = true;
    return self;
  }

  /**
   * Sets the default value for the bootstrapServersSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> bootstrapServersSupplier(Supplier<String> value) {
    this.value$bootstrapServersSupplier$java$util$function$Supplier = value;
    this.isSet$bootstrapServersSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the keyDeserializer property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> keyDeserializer(Deserializer<K> value) {
    this.value$keyDeserializer$org$apache$kafka$common$serialization$Deserializer = value;
    this.isSet$keyDeserializer$org$apache$kafka$common$serialization$Deserializer = true;
    return self;
  }

  /**
   * Sets the default value for the valueDeserializer property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> valueDeserializer(Deserializer<V> value) {
    this.value$valueDeserializer$org$apache$kafka$common$serialization$Deserializer = value;
    this.isSet$valueDeserializer$org$apache$kafka$common$serialization$Deserializer = true;
    return self;
  }

  /**
   * Sets the default value for the keyDeserializerSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> keyDeserializerSupplier(Supplier<Deserializer<K>> value) {
    this.value$keyDeserializerSupplier$java$util$function$Supplier = value;
    this.isSet$keyDeserializerSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the valueDeserializerSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> valueDeserializerSupplier(Supplier<Deserializer<V>> value) {
    this.value$valueDeserializerSupplier$java$util$function$Supplier = value;
    this.isSet$valueDeserializerSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the configureDeserializers property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaConsumerFactoryBuilder<K, V> configureDeserializers(boolean value) {
    this.value$configureDeserializers$boolean = value;
    this.isSet$configureDeserializers$boolean = true;
    return self;
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @Override
  @GwtIncompatible
  public Object clone() {
    try {
      @SuppressWarnings("unchecked")
      DefaultKafkaConsumerFactoryBuilder<K, V> result = (DefaultKafkaConsumerFactoryBuilder<K, V>)super.clone();
      result.self = result;
      return result;
    } catch (CloneNotSupportedException e) {
      throw new InternalError(e.getMessage());
    }
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @SuppressWarnings("unchecked")
  @GwtIncompatible
  public DefaultKafkaConsumerFactoryBuilder<K, V> but() {
    return (DefaultKafkaConsumerFactoryBuilder<K, V>)clone();
  }

  /**
   * Creates a new {@link DefaultKafkaConsumerFactory} based on this builder's settings.
   *
   * @return the created DefaultKafkaConsumerFactory
   */
  @Override
  public DefaultKafkaConsumerFactory<K, V> build() {
    try {
      DefaultKafkaConsumerFactory<K, V> result = DefaultKafkaConsumerFactoryProvider.createDefaultKafkaConsumerFactory(value$configs$java$util$Map, value$withListeners$java$util$List, value$withPostProcessors$java$util$List);
      if (isSet$bootstrapServersSupplier$java$util$function$Supplier) {
        result.setBootstrapServersSupplier(value$bootstrapServersSupplier$java$util$function$Supplier);
      }
      if (isSet$keyDeserializer$org$apache$kafka$common$serialization$Deserializer) {
        result.setKeyDeserializer(value$keyDeserializer$org$apache$kafka$common$serialization$Deserializer);
      }
      if (isSet$valueDeserializer$org$apache$kafka$common$serialization$Deserializer) {
        result.setValueDeserializer(value$valueDeserializer$org$apache$kafka$common$serialization$Deserializer);
      }
      if (isSet$keyDeserializerSupplier$java$util$function$Supplier) {
        result.setKeyDeserializerSupplier(value$keyDeserializerSupplier$java$util$function$Supplier);
      }
      if (isSet$valueDeserializerSupplier$java$util$function$Supplier) {
        result.setValueDeserializerSupplier(value$valueDeserializerSupplier$java$util$function$Supplier);
      }
      if (isSet$configureDeserializers$boolean) {
        result.setConfigureDeserializers(value$configureDeserializers$boolean);
      }
      return result;
    } catch (RuntimeException ex) {
      throw ex;
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
}
