package org.swisspush.kobuka.spring;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Generated;
import net.karneim.pojobuilder.GwtIncompatible;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.ProducerFactory.Listener;
import org.springframework.kafka.core.ProducerPostProcessor;
import org.swisspush.kobuka.spring.internal.Builder;
import org.swisspush.kobuka.spring.internal.DefaultKafkaProducerFactoryProvider;

@Generated("PojoBuilder")
public abstract class AbstractDefaultKafkaProducerFactoryBuilder<K, V>
    implements Builder<DefaultKafkaProducerFactory<K, V>>, Cloneable {
  protected DefaultKafkaProducerFactoryBuilder<K, V> self;
  protected Map<String, Object> value$configs$java$util$Map;
  protected boolean isSet$configs$java$util$Map;
  protected List<Listener<K, V>> value$withListeners$java$util$List;
  protected boolean isSet$withListeners$java$util$List;
  protected List<ProducerPostProcessor<K, V>> value$withPostProcessors$java$util$List;
  protected boolean isSet$withPostProcessors$java$util$List;
  protected Supplier<String> value$bootstrapServersSupplier$java$util$function$Supplier;
  protected boolean isSet$bootstrapServersSupplier$java$util$function$Supplier;
  protected Serializer<K> value$keySerializer$org$apache$kafka$common$serialization$Serializer;
  protected boolean isSet$keySerializer$org$apache$kafka$common$serialization$Serializer;
  protected Serializer<V> value$valueSerializer$org$apache$kafka$common$serialization$Serializer;
  protected boolean isSet$valueSerializer$org$apache$kafka$common$serialization$Serializer;
  protected Supplier<Serializer<K>> value$keySerializerSupplier$java$util$function$Supplier;
  protected boolean isSet$keySerializerSupplier$java$util$function$Supplier;
  protected Supplier<Serializer<V>> value$valueSerializerSupplier$java$util$function$Supplier;
  protected boolean isSet$valueSerializerSupplier$java$util$function$Supplier;
  protected boolean value$configureSerializers$boolean;
  protected boolean isSet$configureSerializers$boolean;
  protected int value$physicalCloseTimeout$int;
  protected boolean isSet$physicalCloseTimeout$int;
  protected String value$transactionIdPrefix$java$lang$String;
  protected boolean isSet$transactionIdPrefix$java$lang$String;
  protected boolean value$producerPerThread$boolean;
  protected boolean isSet$producerPerThread$boolean;
  protected boolean value$producerPerConsumerPartition$boolean;
  protected boolean isSet$producerPerConsumerPartition$boolean;
  protected Duration value$maxAge$java$time$Duration;
  protected boolean isSet$maxAge$java$time$Duration;

  /**
   * Creates a new {@link AbstractDefaultKafkaProducerFactoryBuilder}.
   */
  public AbstractDefaultKafkaProducerFactoryBuilder() {
    self = (DefaultKafkaProducerFactoryBuilder<K, V>)this;
  }

  /**
   * Sets the default value for the configs property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> configs(Map<String, Object> value) {
    this.value$configs$java$util$Map = value;
    this.isSet$configs$java$util$Map = true;
    return self;
  }

  /**
   * Sets the default value for the withListeners property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> withListeners(List<Listener<K, V>> value) {
    this.value$withListeners$java$util$List = value;
    this.isSet$withListeners$java$util$List = true;
    return self;
  }

  /**
   * Sets the default value for the withPostProcessors property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> withPostProcessors(List<ProducerPostProcessor<K, V>> value) {
    this.value$withPostProcessors$java$util$List = value;
    this.isSet$withPostProcessors$java$util$List = true;
    return self;
  }

  /**
   * Sets the default value for the bootstrapServersSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> bootstrapServersSupplier(Supplier<String> value) {
    this.value$bootstrapServersSupplier$java$util$function$Supplier = value;
    this.isSet$bootstrapServersSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the keySerializer property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> keySerializer(Serializer<K> value) {
    this.value$keySerializer$org$apache$kafka$common$serialization$Serializer = value;
    this.isSet$keySerializer$org$apache$kafka$common$serialization$Serializer = true;
    return self;
  }

  /**
   * Sets the default value for the valueSerializer property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> valueSerializer(Serializer<V> value) {
    this.value$valueSerializer$org$apache$kafka$common$serialization$Serializer = value;
    this.isSet$valueSerializer$org$apache$kafka$common$serialization$Serializer = true;
    return self;
  }

  /**
   * Sets the default value for the keySerializerSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> keySerializerSupplier(Supplier<Serializer<K>> value) {
    this.value$keySerializerSupplier$java$util$function$Supplier = value;
    this.isSet$keySerializerSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the valueSerializerSupplier property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> valueSerializerSupplier(Supplier<Serializer<V>> value) {
    this.value$valueSerializerSupplier$java$util$function$Supplier = value;
    this.isSet$valueSerializerSupplier$java$util$function$Supplier = true;
    return self;
  }

  /**
   * Sets the default value for the configureSerializers property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> configureSerializers(boolean value) {
    this.value$configureSerializers$boolean = value;
    this.isSet$configureSerializers$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the physicalCloseTimeout property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> physicalCloseTimeout(int value) {
    this.value$physicalCloseTimeout$int = value;
    this.isSet$physicalCloseTimeout$int = true;
    return self;
  }

  /**
   * Sets the default value for the transactionIdPrefix property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> transactionIdPrefix(String value) {
    this.value$transactionIdPrefix$java$lang$String = value;
    this.isSet$transactionIdPrefix$java$lang$String = true;
    return self;
  }

  /**
   * Sets the default value for the producerPerThread property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> producerPerThread(boolean value) {
    this.value$producerPerThread$boolean = value;
    this.isSet$producerPerThread$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the producerPerConsumerPartition property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> producerPerConsumerPartition(boolean value) {
    this.value$producerPerConsumerPartition$boolean = value;
    this.isSet$producerPerConsumerPartition$boolean = true;
    return self;
  }

  /**
   * Sets the default value for the maxAge property.
   *
   * @param value the default value
   * @return this builder
   */
  public DefaultKafkaProducerFactoryBuilder<K, V> maxAge(Duration value) {
    this.value$maxAge$java$time$Duration = value;
    this.isSet$maxAge$java$time$Duration = true;
    return self;
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @Override
  @GwtIncompatible
  public Object clone() {
    try {
      @SuppressWarnings("unchecked")
      DefaultKafkaProducerFactoryBuilder<K, V> result = (DefaultKafkaProducerFactoryBuilder<K, V>)super.clone();
      result.self = result;
      return result;
    } catch (CloneNotSupportedException e) {
      throw new InternalError(e.getMessage());
    }
  }

  /**
   * Returns a clone of this builder.
   *
   * @return the clone
   */
  @SuppressWarnings("unchecked")
  @GwtIncompatible
  public DefaultKafkaProducerFactoryBuilder<K, V> but() {
    return (DefaultKafkaProducerFactoryBuilder<K, V>)clone();
  }

  /**
   * Creates a new {@link DefaultKafkaProducerFactory} based on this builder's settings.
   *
   * @return the created DefaultKafkaProducerFactory
   */
  @Override
  public DefaultKafkaProducerFactory<K, V> build() {
    try {
      DefaultKafkaProducerFactory<K, V> result = DefaultKafkaProducerFactoryProvider.create(value$configs$java$util$Map, value$withListeners$java$util$List, value$withPostProcessors$java$util$List);
      if (isSet$bootstrapServersSupplier$java$util$function$Supplier) {
        result.setBootstrapServersSupplier(value$bootstrapServersSupplier$java$util$function$Supplier);
      }
      if (isSet$keySerializer$org$apache$kafka$common$serialization$Serializer) {
        result.setKeySerializer(value$keySerializer$org$apache$kafka$common$serialization$Serializer);
      }
      if (isSet$valueSerializer$org$apache$kafka$common$serialization$Serializer) {
        result.setValueSerializer(value$valueSerializer$org$apache$kafka$common$serialization$Serializer);
      }
      if (isSet$keySerializerSupplier$java$util$function$Supplier) {
        result.setKeySerializerSupplier(value$keySerializerSupplier$java$util$function$Supplier);
      }
      if (isSet$valueSerializerSupplier$java$util$function$Supplier) {
        result.setValueSerializerSupplier(value$valueSerializerSupplier$java$util$function$Supplier);
      }
      if (isSet$configureSerializers$boolean) {
        result.setConfigureSerializers(value$configureSerializers$boolean);
      }
      if (isSet$physicalCloseTimeout$int) {
        result.setPhysicalCloseTimeout(value$physicalCloseTimeout$int);
      }
      if (isSet$transactionIdPrefix$java$lang$String) {
        result.setTransactionIdPrefix(value$transactionIdPrefix$java$lang$String);
      }
      if (isSet$producerPerThread$boolean) {
        result.setProducerPerThread(value$producerPerThread$boolean);
      }
      if (isSet$producerPerConsumerPartition$boolean) {
        result.setProducerPerConsumerPartition(value$producerPerConsumerPartition$boolean);
      }
      if (isSet$maxAge$java$time$Duration) {
        result.setMaxAge(value$maxAge$java$time$Duration);
      }
      return result;
    } catch (RuntimeException ex) {
      throw ex;
    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
  }
}
