/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.api;

import org.apache.ode.bpel.compiler.api.SourceLocation;
import org.apache.ode.utils.msg.CommonMessages;
import org.apache.ode.utils.msg.MessageBundle;

public class CompilationMessage {
    public static final short INFO = 0;
    public static final short WARN = 1;
    public static final short ERROR = 2;
    public short phase;
    public short severity;
    public String code;
    public String messageText;
    public SourceLocation source;
    private static final CommonMessages __commonMsgs = MessageBundle.getMessages(CommonMessages.class);
    private static final String[] SEVERITY_LEVELS = new String[]{__commonMsgs.strInfo().toLowerCase() + ": ", __commonMsgs.strWarning().toLowerCase() + ": ", __commonMsgs.strError().toLowerCase() + ": "};

    public CompilationMessage setSource(SourceLocation source) {
        this.source = source;
        return this;
    }

    public String toErrorString() {
        StringBuffer buf = new StringBuffer();
        if (this.source != null) {
            buf.append(this.source.getURI());
            buf.append(':');
            buf.append(this.source.getLineNo());
            buf.append(": ");
        }
        buf.append(SEVERITY_LEVELS[this.severity]);
        buf.append('[');
        buf.append(this.code);
        buf.append("] ");
        buf.append(this.messageText);
        return buf.toString();
    }

    public String toString() {
        return "CompilationMessage: " + this.toErrorString();
    }
}

