/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OFlow;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.ChildInfo;
import org.apache.ode.bpel.runtime.CompensationHandler;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.LinkInfo;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.LinkStatusChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannel;
import org.apache.ode.bpel.runtime.channels.ParentScopeChannelListener;
import org.apache.ode.bpel.runtime.channels.TerminationChannel;
import org.apache.ode.bpel.runtime.channels.TerminationChannelListener;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.utils.stl.FilterIterator;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.w3c.dom.Element;

class FLOW
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private OFlow _oflow;
    private Set<ChildInfo> _children = new HashSet<ChildInfo>();

    public FLOW(ActivityInfo self, ScopeFrame frame, LinkFrame linkFrame) {
        super(self, frame, linkFrame);
        this._oflow = (OFlow)self.o;
    }

    @Override
    public void run() {
        LinkFrame myLinkFrame = new LinkFrame(this._linkFrame);
        for (OLink link : this._oflow.localLinks) {
            LinkStatusChannel lsc = this.newChannel(LinkStatusChannel.class);
            myLinkFrame.links.put(link, new LinkInfo(link, lsc, lsc));
        }
        for (OActivity ochild : this._oflow.parallelActivities) {
            ChildInfo childInfo = new ChildInfo(new ActivityInfo(this.genMonotonic(), ochild, this.newChannel(TerminationChannel.class), this.newChannel(ParentScopeChannel.class)));
            this._children.add(childInfo);
            FLOW.instance(this.createChild(childInfo.activity, this._scopeFrame, myLinkFrame));
        }
        FLOW.instance(new ACTIVE());
    }

    @Override
    public String toString() {
        return "<T:Act:Flow:" + this._oflow.name + ">";
    }

    private Iterator<ChildInfo> active() {
        return new FilterIterator<ChildInfo>(this._children.iterator(), new MemberOfFunction<ChildInfo>(){

            @Override
            public boolean isMember(ChildInfo childInfo) {
                return !childInfo.completed;
            }
        });
    }

    private class ACTIVE
    extends BpelJacobRunnable {
        private static final long serialVersionUID = -8494641460279049245L;
        private FaultData _fault;
        private HashSet<CompensationHandler> _compensations = new HashSet();

        private ACTIVE() {
        }

        @Override
        public void run() {
            Iterator active = FLOW.this.active();
            if (active.hasNext()) {
                HashSet<ChannelListener> mlSet = new HashSet<ChannelListener>();
                mlSet.add(new TerminationChannelListener(FLOW.this._self.self){
                    private static final long serialVersionUID = 2554750258974084466L;

                    @Override
                    public void terminate() {
                        Iterator i = FLOW.this.active();
                        while (i.hasNext()) {
                            1.replication(((ChildInfo)i.next()).activity.self).terminate();
                        }
                        1.instance(ACTIVE.this);
                    }
                });
                while (active.hasNext()) {
                    final ChildInfo child = (ChildInfo)active.next();
                    mlSet.add(new ParentScopeChannelListener(child.activity.parent){
                        private static final long serialVersionUID = -8027205709169238172L;

                        @Override
                        public void completed(FaultData faultData, Set<CompensationHandler> compensations) {
                            child.completed = true;
                            ACTIVE.this._compensations.addAll(compensations);
                            if (faultData != null && ACTIVE.this._fault == null) {
                                Iterator i = FLOW.this.active();
                                while (i.hasNext()) {
                                    2.replication(((ChildInfo)i.next()).activity.self).terminate();
                                }
                                ACTIVE.this._fault = faultData;
                            }
                            2.instance(ACTIVE.this);
                        }

                        @Override
                        public void compensate(OScope scope, SynchChannel ret) {
                            FLOW.this._self.parent.compensate(scope, ret);
                            2.instance(ACTIVE.this);
                        }

                        @Override
                        public void cancelled() {
                            this.completed(null, CompensationHandler.emptySet());
                        }

                        @Override
                        public void failure(String reason, Element data) {
                            this.completed(null, CompensationHandler.emptySet());
                        }
                    });
                }
                ACTIVE.object(false, mlSet);
            } else {
                FLOW.this._self.parent.completed(this._fault, this._compensations);
            }
        }
    }
}

