/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath10.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.elang.xpath10.compiler.SourceLocatorWrapper;

public class XslCompilationErrorListener
implements ErrorListener {
    private static final Log __log = LogFactory.getLog(XslCompilationErrorListener.class);
    private CompilerContext _cc;

    public XslCompilationErrorListener(CompilerContext cc) {
        this._cc = cc;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        if (__log.isWarnEnabled()) {
            __log.warn((Object)exception);
        }
        this.recover((short)1, exception);
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        if (__log.isErrorEnabled()) {
            __log.error((Object)exception);
        }
        this.recover((short)2, exception);
        throw exception;
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        if (__log.isFatalEnabled()) {
            __log.fatal((Object)exception);
        }
        this.recover((short)2, exception);
        throw exception;
    }

    private void recover(short severity, TransformerException exception) {
        SourceLocatorWrapper loc;
        CompilationMessage cmsg = new CompilationMessage();
        cmsg.severity = severity;
        cmsg.code = "parseXsl";
        cmsg.phase = 0;
        cmsg.messageText = exception.getMessageAndLocation();
        CompilationException ce = new CompilationException(cmsg, (Throwable)exception);
        SourceLocatorWrapper sourceLocatorWrapper = loc = exception.getLocator() != null ? new SourceLocatorWrapper(exception.getLocator()) : null;
        if (this._cc != null) {
            this._cc.recoveredFromError(loc, ce);
        } else {
            __log.error((Object)"XSL stylesheet parsing error! ", (Throwable)exception);
        }
    }
}

