/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpel.osgi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.switchyard.ServiceDomain;
import org.switchyard.component.bpel.riftsaw.RiftsawBPELExchangeHandler;

public class RiftsawBPELOSGiExchangeHandler
extends RiftsawBPELExchangeHandler {
    private static final Logger LOG = Logger.getLogger(RiftsawBPELOSGiExchangeHandler.class);
    private final ServiceDomain _domain;

    protected RiftsawBPELOSGiExchangeHandler(ServiceDomain domain) {
        super(domain);
        this._domain = domain;
    }

    @Override
    protected File getDeployment() throws Exception {
        Bundle applicationBundle = this.getApplicationBundle();
        Enumeration deploymentEntries = applicationBundle.findEntries("/", "deploy.xml", false);
        if (deploymentEntries.hasMoreElements()) {
            return this.expandDeployment(applicationBundle, (URL)deploymentEntries.nextElement());
        }
        throw new Exception("Bundle does not contain deploy.xml file: " + applicationBundle.getSymbolicName());
    }

    @Override
    protected String getDeploymentName() throws Exception {
        return this.getApplicationBundle().getSymbolicName();
    }

    private Bundle getApplicationBundle() throws Exception {
        return (Bundle)this._domain.getProperty("switchyard.deployment.bundle");
    }

    private File expandDeployment(Bundle applicationBundle, URL deployXmlUrl) throws IOException {
        File rootDirectory = this.getDataDirectory(applicationBundle);
        this.copyFile(deployXmlUrl, rootDirectory);
        Enumeration bpelFiles = applicationBundle.findEntries("/", "*.bpel*", true);
        if (bpelFiles != null) {
            while (bpelFiles.hasMoreElements()) {
                this.copyFile((URL)bpelFiles.nextElement(), rootDirectory);
            }
        }
        return rootDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(URL source, File rootDirectory) throws IOException {
        File destination = new File(rootDirectory, source.getPath());
        if (!destination.getName().matches(".+\\.bpel(-\\d+)?") && !"deploy.xml".equals(destination.getName())) {
            LOG.warnf("Skipping file copy for \"%s\", not a *.bpel or deploy.xml file.", (Object)destination.getName());
            return;
        }
        destination.getParentFile().mkdirs();
        ReadableByteChannel input = null;
        AbstractInterruptibleChannel output = null;
        try {
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            input = Channels.newChannel(source.openStream());
            output = new FileOutputStream(destination).getChannel();
            while (input.read(buffer) > 0) {
                buffer.flip();
                ((FileChannel)output).write(buffer);
                buffer.clear();
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getDataDirectory(Bundle bundle2) {
        File dataDirectory = bundle2.getDataFile("");
        File deploymentsDirectory = new File(dataDirectory, "bpel");
        if (!deploymentsDirectory.exists()) {
            deploymentsDirectory.mkdirs();
            deploymentsDirectory.deleteOnExit();
        }
        return deploymentsDirectory;
    }
}

