/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xpath20.runtime;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.xpath.XPathExpressionImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPath20ExpressionModifier {
    private NSContext contextUris;
    private NamePool namePool;

    public XPath20ExpressionModifier(NSContext contextUris, NamePool namePool) {
        this.contextUris = contextUris;
        this.namePool = namePool;
    }

    public void insertMissingData(XPathExpression xpathExpr, Node contextNode) throws DOMException, TransformerException {
        if (contextNode == null || !(contextNode instanceof Element) || !(xpathExpr instanceof XPathExpressionImpl)) {
            return;
        }
        Expression expression = ((XPathExpressionImpl)xpathExpr).getInternalExpression();
        Iterator subExpressions = expression.iterateSubExpressions();
        if (!subExpressions.hasNext()) {
            return;
        }
        Expression subExpr = (Expression)subExpressions.next();
        if (!(subExpr instanceof PathExpression)) {
            return;
        }
        Document document = contextNode.getOwnerDocument();
        PathExpression pathExpr = (PathExpression)subExpr;
        Expression step = pathExpr.getFirstStep();
        while (step != null) {
            ItemChecker itemChecker;
            Expression baseExpr;
            if (step instanceof AxisExpression) {
                AxisExpression axisExpr = (AxisExpression)step;
                NodeTest nodeTest = axisExpr.getNodeTest();
                if (!(nodeTest instanceof NameTest)) break;
                NameTest nameTest = (NameTest)nodeTest;
                QName childName = this.getQualifiedName(nameTest.getFingerprint(), this.namePool, this.contextUris);
                if (3 == axisExpr.getAxis()) {
                    if (NodeKindTest.ELEMENT.getNodeKindMask() != nameTest.getNodeKindMask()) break;
                    NodeList children = ((Element)contextNode).getElementsByTagNameNS(childName.getNamespaceURI(), childName.getLocalPart());
                    if (children == null || children.getLength() == 0) {
                        Element child = document.createElementNS(childName.getNamespaceURI(), DOMUtils.getQualifiedName(childName));
                        contextNode.appendChild(child);
                        contextNode = child;
                    } else {
                        if (children.getLength() != 1) break;
                        contextNode = children.item(0);
                    }
                } else {
                    Attr attribute;
                    if (2 != axisExpr.getAxis() || NodeKindTest.ATTRIBUTE.getNodeKindMask() != nameTest.getNodeKindMask() || (attribute = ((Element)contextNode).getAttributeNodeNS(childName.getNamespaceURI(), childName.getLocalPart())) != null) break;
                    attribute = document.createAttributeNS(childName.getNamespaceURI(), childName.getLocalPart());
                    ((Element)contextNode).setAttributeNode(attribute);
                    contextNode = attribute;
                }
            } else if (!(step instanceof ItemChecker) || !((baseExpr = (itemChecker = (ItemChecker)step).getBaseExpression()) instanceof VariableReference)) break;
            if (pathExpr == null) break;
            Expression remainingSteps = pathExpr.getRemainingSteps();
            if (remainingSteps instanceof PathExpression) {
                pathExpr = (PathExpression)remainingSteps;
                step = pathExpr.getFirstStep();
                continue;
            }
            if (!(remainingSteps instanceof AxisExpression)) continue;
            pathExpr = null;
            step = (AxisExpression)remainingSteps;
        }
    }

    private QName getQualifiedName(int fingerprint, NamePool namePool, NSContext nsContext) {
        String localName = namePool.getLocalName(fingerprint);
        String prefix = namePool.getPrefix(fingerprint);
        String uri = namePool.getURI(fingerprint);
        if (prefix == null || "".equals(prefix)) {
            for (String nsPrefix : nsContext.getPrefixes()) {
                String nsUri = nsContext.getNamespaceURI(nsPrefix);
                if (!nsUri.equals(uri)) continue;
                prefix = nsPrefix;
            }
        }
        return new QName(uri, localName, prefix);
    }
}

